/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.validation.JSAnnotatingVisitor;
import com.intellij.lang.javascript.validation.JSKeywordHighlighterVisitor;
import com.intellij.lang.javascript.validation.JavaScriptAnnotatingVisitor;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSAnalysisHandlersFactory {
    public static final LanguageExtension<JSAnalysisHandlersFactory> EP_NAME = new LanguageExtension("JavaScript.analysisHandlersFactory");
    private static final JSAnalysisHandlersFactory DEFAULT_INSTANCE = new JSAnalysisHandlersFactory();

    @NotNull
    public static JSAnalysisHandlersFactory forElement(@Nullable PsiElement element) {
        Language dialect = element != null ? DialectDetector.languageOfElement(element) : null;
        JSAnalysisHandlersFactory jSAnalysisHandlersFactory = JSAnalysisHandlersFactory.forLanguage(dialect);
        if (jSAnalysisHandlersFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/JSAnalysisHandlersFactory", "forElement"));
        }
        return jSAnalysisHandlersFactory;
    }

    @NotNull
    public static JSAnalysisHandlersFactory forLanguage(@Nullable Language dialect) {
        JSAnalysisHandlersFactory dialectSpecificFactory = dialect != null ? (JSAnalysisHandlersFactory)EP_NAME.forLanguage(dialect) : null;
        JSAnalysisHandlersFactory jSAnalysisHandlersFactory = dialectSpecificFactory != null ? dialectSpecificFactory : DEFAULT_INSTANCE;
        if (jSAnalysisHandlersFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/JSAnalysisHandlersFactory", "forLanguage"));
        }
        return jSAnalysisHandlersFactory;
    }

    @NotNull
    public JSAnnotatingVisitor createAnnotatingVisitor(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/lang/javascript/JSAnalysisHandlersFactory", "createAnnotatingVisitor"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/javascript/JSAnalysisHandlersFactory", "createAnnotatingVisitor"));
        }
        JavaScriptAnnotatingVisitor javaScriptAnnotatingVisitor = new JavaScriptAnnotatingVisitor(psiElement, holder);
        if (javaScriptAnnotatingVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/JSAnalysisHandlersFactory", "createAnnotatingVisitor"));
        }
        return javaScriptAnnotatingVisitor;
    }

    public JSKeywordHighlighterVisitor createKeywordHighlighterVisitor(@NotNull AnnotationHolder holder) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/javascript/JSAnalysisHandlersFactory", "createKeywordHighlighterVisitor"));
        }
        return new JSKeywordHighlighterVisitor(holder);
    }
}

