/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.base;

import com.intellij.ui.LayeredIcon;
import com.intellij.util.ui.EmptyIcon;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class PaddedIconBuilder {
    private final Icon myIcon;
    private int myTop;
    private int myBottom;
    private int myLeft;
    private int myRight;

    public PaddedIconBuilder(@NotNull Icon icon) {
        if (icon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/lang/javascript/buildTools/base/PaddedIconBuilder", "<init>"));
        }
        this.myIcon = icon;
    }

    @NotNull
    public PaddedIconBuilder setTopBottomPaddings(int top, int bottom) {
        this.myTop = top;
        this.myBottom = bottom;
        PaddedIconBuilder paddedIconBuilder = this;
        if (paddedIconBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/base/PaddedIconBuilder", "setTopBottomPaddings"));
        }
        return paddedIconBuilder;
    }

    @NotNull
    public PaddedIconBuilder setLeftRightPaddings(int left, int right) {
        this.myLeft = left;
        this.myRight = right;
        PaddedIconBuilder paddedIconBuilder = this;
        if (paddedIconBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/base/PaddedIconBuilder", "setLeftRightPaddings"));
        }
        return paddedIconBuilder;
    }

    @NotNull
    public Icon build() {
        int width = this.myLeft + this.myIcon.getIconWidth() + this.myRight;
        int height = this.myTop + this.myIcon.getIconHeight() + this.myBottom;
        LayeredIcon result = new LayeredIcon(2);
        result.setIcon((Icon)EmptyIcon.create((int)width, (int)height), 0);
        result.setIcon(this.myIcon, 1, this.myLeft, this.myTop);
        LayeredIcon layeredIcon = result;
        if (layeredIcon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/base/PaddedIconBuilder", "build"));
        }
        return layeredIcon;
    }
}

