/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.gulp.rc;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.LocalFileFinder;

public class GulpFilter
implements Filter,
DumbAware {
    private final Project myProject;

    public GulpFilter(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpFilter", "<init>"));
        }
        this.myProject = project;
    }

    @Nullable
    public Filter.Result applyFilter(String line, int entireLength) {
        String path;
        VirtualFile file;
        if (GulpFilter.isAbsolutePath(line) && (file = LocalFileFinder.findFile((String)(path = line.trim()))) != null && !file.isDirectory()) {
            return new Filter.Result(entireLength - line.length(), entireLength - line.length() + path.length(), (HyperlinkInfo)new OpenFileHyperlinkInfo(this.myProject, file, -1));
        }
        return null;
    }

    private static boolean isAbsolutePath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpFilter", "isAbsolutePath"));
        }
        return SystemInfo.isWindows ? FileUtil.isWindowsAbsolutePath((String)path) : FileUtil.isUnixAbsolutePath((String)path);
    }
}

