/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.editing;

import com.intellij.codeInsight.editorActions.smartEnter.SmartEnterProcessor;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptExportAssignment;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;

public class JSSmartEnterProcessor
extends SmartEnterProcessor {
    public boolean process(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        JSFunction fun;
        PsiElement statement;
        PsiElement nextMeaningfulElement;
        PsiElement element;
        PsiElement originalElement;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/editing/JSSmartEnterProcessor", "process"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/javascript/editing/JSSmartEnterProcessor", "process"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/lang/javascript/editing/JSSmartEnterProcessor", "process"));
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement originalAt = psiFile.findElementAt(offset);
        PsiElement at = originalAt;
        if (at == null && offset > 0) {
            at = psiFile.findElementAt(offset - 1);
        }
        if (at == null) {
            return false;
        }
        PsiElement psiElement = originalElement = at instanceof PsiWhiteSpace ? PsiTreeUtil.prevLeaf((PsiElement)at) : at;
        if (at == originalAt && at.getNode() != null && at.getNode().getElementType() == JSTokenTypes.RPAR && at.getParent() instanceof JSArgumentList) {
            originalElement = PsiTreeUtil.prevLeaf((PsiElement)at);
        }
        if ((element = originalElement) != null && !(element instanceof PsiErrorElement) && (nextMeaningfulElement = JSSmartEnterProcessor.evalMeaningfulElement(at, true)) instanceof PsiErrorElement) {
            element = nextMeaningfulElement;
            offset = element.getTextOffset();
        }
        if ((statement = JSSmartEnterProcessor.getParentStatement(element)) instanceof JSBlockStatement && statement.getParent() instanceof JSFunctionExpression) {
            statement = JSSmartEnterProcessor.getParentStatement(statement);
        }
        String semicolon = JSCodeStyleSettings.getSemicolon(psiFile);
        PsiElement elementParent = element.getParent();
        if (statement != null && JSSmartEnterProcessor.requiresSemicolon(statement) && !(elementParent instanceof JSFunction) && JSSmartEnterProcessor.hasNoSemicolonAtEnd(statement)) {
            JSExpression invoked;
            PsiElement grandParent;
            offset = statement.getTextRange().getEndOffset();
            int shiftOffset = semicolon.length();
            JSReferenceExpression referenceExpression = null;
            boolean afterCall = false;
            if (elementParent instanceof JSArgumentList && (grandParent = elementParent.getParent()) instanceof JSCallExpression && (invoked = ((JSCallExpression)grandParent).getMethodExpression()) instanceof JSReferenceExpression) {
                referenceExpression = (JSReferenceExpression)invoked;
                afterCall = true;
            }
            if (statement instanceof JSExpressionStatement && referenceExpression == null) {
                JSExpression expression = ((JSExpressionStatement)statement).getExpression();
                if (expression instanceof JSCallExpression) {
                    expression = ((JSCallExpression)expression).getMethodExpression();
                    afterCall = true;
                }
                if (expression instanceof JSReferenceExpression) {
                    referenceExpression = (JSReferenceExpression)expression;
                }
            } else if (referenceExpression == null && elementParent instanceof JSReferenceExpression && statement instanceof JSVarStatement) {
                referenceExpression = (JSReferenceExpression)elementParent;
            }
            if (referenceExpression != null && PsiTreeUtil.lastChild((PsiElement)statement).getNode().getElementType() != JSTokenTypes.RPAR) {
                ResolveResult[] results = referenceExpression.multiResolve(false);
                if (results.length > 0) {
                    JSFunctionItem function;
                    PsiElement resolve = results[0].getElement();
                    JSFunctionItem jSFunctionItem = function = resolve == null ? null : JSPsiImplUtils.calculatePossibleFunction(resolve);
                    if (function != null && !function.isGetProperty() && !function.isSetProperty()) {
                        semicolon = (afterCall ? ")" : "()") + semicolon;
                        shiftOffset = semicolon.length();
                        if (!afterCall && function.getParameters().length > 0) {
                            shiftOffset = 1;
                        }
                    } else if (resolve instanceof JSClass && !JSResolveUtil.isExprInStrictTypeContext(referenceExpression)) {
                        String newSemicolon = (afterCall ? ")" : "()") + semicolon;
                        shiftOffset = newSemicolon.length();
                        if (afterCall) {
                            shiftOffset -= semicolon.length();
                        }
                        semicolon = newSemicolon;
                    } else if (afterCall) {
                        semicolon = this.calcTailAfterCall(element, semicolon);
                        shiftOffset = semicolon.length();
                    }
                } else if (afterCall) {
                    semicolon = this.calcTailAfterCall(element, semicolon);
                    shiftOffset = semicolon.length();
                }
            }
            if (this.addSemicolonIfNeeded(project, editor, psiFile, offset, semicolon, shiftOffset)) {
                return true;
            }
        }
        PsiElement prevMeaningfulElement = JSSmartEnterProcessor.evalMeaningfulElement(element, false);
        String errorDescription = null;
        if (element != null && !(element instanceof PsiErrorElement) && prevMeaningfulElement != null) {
            element = prevMeaningfulElement;
        }
        if (element instanceof PsiErrorElement) {
            errorDescription = ((PsiErrorElement)element).getErrorDescription();
            if (JSBundle.message((String)"javascript.parser.message.expected.lbrace", (Object[])new Object[0]).equals(errorDescription) || JSBundle.message((String)"javascript.parser.message.expected.statement", (Object[])new Object[0]).equals(errorDescription)) {
                String tail = "";
                if (element.getParent() instanceof JSFunctionExpression) {
                    tail = JSSmartEnterProcessor.calcTail(semicolon, element);
                }
                this.insertCommitReformat(project, editor, psiFile, offset, "{\n\n}" + tail, 2, true);
                return true;
            }
        }
        if (JSBundle.message((String)"javascript.parser.message.expected.lparen", (Object[])new Object[0]).equals(errorDescription) || JSBundle.message((String)"javascript.parser.message.expected.function.name", (Object[])new Object[0]).equals(errorDescription)) {
            this.insertCommitReformat(project, editor, psiFile, offset, "() {}" + JSSmartEnterProcessor.calcTail(semicolon, element), 1, false);
            return true;
        }
        if ((statement instanceof JSIfStatement || statement instanceof JSLoopStatement) && (JSBundle.message((String)"javascript.parser.message.expected.rparen", (Object[])new Object[0]).equals(errorDescription) || ")".equals(originalElement.getText()))) {
            boolean hasBody = false;
            if (statement instanceof JSIfStatement) {
                hasBody = ((JSIfStatement)statement).getThen() instanceof JSBlockStatement;
            } else if (statement instanceof JSLoopStatement) {
                hasBody = ((JSLoopStatement)statement).getBody() instanceof JSBlockStatement;
            }
            if (!hasBody) {
                offset = CharArrayUtil.shiftForwardUntil((CharSequence)editor.getDocument().getCharsSequence(), (int)offset, (String)"\n") - 1;
                String s = "{\n\n}";
                int shiftOffset = 2;
                if (JSBundle.message((String)"javascript.parser.message.expected.rparen", (Object[])new Object[0]).equals(errorDescription)) {
                    s = ")" + s;
                    ++shiftOffset;
                }
                this.insertCommitReformat(project, editor, psiFile, offset + 1, s, shiftOffset, true);
                return true;
            }
            if (JSBundle.message((String)"javascript.parser.message.expected.rparen", (Object[])new Object[0]).equals(errorDescription)) {
                offset = CharArrayUtil.shiftForwardUntil((CharSequence)editor.getDocument().getCharsSequence(), (int)offset, (String)"{") - 1;
                offset = CharArrayUtil.shiftBackwardUntil((CharSequence)editor.getDocument().getCharsSequence(), (int)offset, (String)"\n \t");
                this.insertCommitReformat(project, editor, psiFile, offset + 1, ")", 1, true);
            }
        }
        return (fun = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)element, JSFunction.class)) != null && JSSmartEnterProcessor.isInterfaceFunction(fun) && JSSmartEnterProcessor.hasNoSemicolonAtEnd((PsiElement)fun) && this.addSemicolonIfNeeded(project, editor, psiFile, fun.getTextRange().getEndOffset(), semicolon, semicolon.length());
    }

    private static PsiElement getParentStatement(PsiElement element) {
        return PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{JSStatement.class, ES6ImportExportDeclaration.class, TypeScriptExportAssignment.class});
    }

    private String calcTailAfterCall(PsiElement element, String semicolon) {
        semicolon = ")" + semicolon;
        if (element instanceof PsiErrorElement && JSBundle.message((String)"javascript.parser.message.missing.rbrace", (Object[])new Object[0]).equals(((PsiErrorElement)element).getErrorDescription())) {
            semicolon = "}" + semicolon;
        }
        return semicolon;
    }

    private static String calcTail(String semicolon, PsiElement element) {
        JSElement base = (JSElement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{JSArgumentList.class, JSIndexedPropertyAccessExpression.class, JSStatement.class});
        String tail = "";
        if (base instanceof JSArgumentList && TreeUtil.findChildBackward((ASTNode)base.getNode(), (IElementType)JSTokenTypes.RPAR) == null) {
            tail = ")";
            base = (JSElement)PsiTreeUtil.getParentOfType((PsiElement)base, (Class[])new Class[]{JSArgumentList.class, JSIndexedPropertyAccessExpression.class, JSStatement.class});
        }
        if (base instanceof JSStatement && base.getLastChild().getNode().getElementType() != JSTokenTypes.SEMICOLON && JSSmartEnterProcessor.requiresSemicolon((PsiElement)((JSStatement)base))) {
            tail = tail + semicolon;
        }
        return tail;
    }

    private boolean addSemicolonIfNeeded(Project project, Editor editor, PsiFile psiFile, int offset, String semicolon, int shiftOffset) {
        if (semicolon.length() > 0) {
            this.insertCommitReformat(project, editor, psiFile, offset, semicolon, shiftOffset, false);
            return true;
        }
        return false;
    }

    private static boolean hasNoSemicolonAtEnd(PsiElement statement) {
        return PsiTreeUtil.lastChild((PsiElement)statement).getNode().getElementType() != JSTokenTypes.SEMICOLON;
    }

    private static boolean isInterfaceFunction(JSFunction elementParent) {
        PsiElement parent = JSResolveUtil.findParent((PsiElement)elementParent);
        return parent instanceof JSClass && ((JSClass)parent).isInterface();
    }

    private static boolean requiresSemicolon(PsiElement statement) {
        return !(statement instanceof JSIfStatement) && !(statement instanceof JSSwitchStatement) && !(statement instanceof JSBlockStatement) && !(statement instanceof JSPackageStatement) && !(statement instanceof JSLoopStatement);
    }

    private void insertCommitReformat(Project project, Editor editor, PsiFile psiFile, int offset, String str, int shiftOffset, boolean adjustLineIndent) {
        editor.getDocument().insertString(offset, (CharSequence)str);
        editor.getCaretModel().moveToOffset(offset + shiftOffset);
        this.commit(editor);
        PsiElement at = psiFile.findElementAt(offset + shiftOffset - 1);
        PsiElement parentOfType = PsiTreeUtil.getParentOfType((PsiElement)at, (Class[])new Class[]{JSStatement.class, JSFunction.class, JSClass.class, JSFile.class});
        try {
            this.reformat(parentOfType);
            if (adjustLineIndent) {
                CodeStyleManager.getInstance((Project)project).adjustLineIndent(psiFile, editor.getCaretModel().getOffset());
            }
        }
        catch (IncorrectOperationException ex) {
            Logger.getInstance((String)((Object)((Object)this)).getClass().getName()).error((Throwable)ex);
        }
    }

    private static PsiElement evalMeaningfulElement(PsiElement element, boolean forward) {
        PsiElement prev;
        if (element == null) {
            return null;
        }
        PsiElement psiElement = prev = forward ? PsiTreeUtil.nextLeaf((PsiElement)element) : PsiTreeUtil.prevLeaf((PsiElement)element);
        if (prev == null) {
            return null;
        }
        if (prev instanceof PsiWhiteSpace) {
            prev = forward ? PsiTreeUtil.nextLeaf((PsiElement)prev) : PsiTreeUtil.prevLeaf((PsiElement)prev);
        }
        return prev;
    }
}

