/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSLanguageUtil;
import com.intellij.lang.javascript.formatter.PostFormatProcessorUtil;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSDoWhileStatement;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSWhileStatement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.codeStyle.PostFormatProcessor;
import com.intellij.psi.impl.source.codeStyle.PostFormatProcessorHelper;
import org.jetbrains.annotations.NotNull;

public class JSBracePostFormatProcessor
implements PostFormatProcessor {
    public PsiElement processElement(@NotNull PsiElement source, @NotNull CodeStyleSettings settings) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/formatter/JSBracePostFormatProcessor", "processElement"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/formatter/JSBracePostFormatProcessor", "processElement"));
        }
        JSBraceEnforcer braceEnforcer = new JSBraceEnforcer(source.getProject(), settings);
        return PostFormatProcessorUtil.processElement(source, settings, (childElement, childRange) -> braceEnforcer.processElementRange((PsiElement)childElement, (TextRange)childRange));
    }

    @NotNull
    public TextRange processText(@NotNull PsiFile source, @NotNull TextRange rangeToReformat, @NotNull CodeStyleSettings settings) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/formatter/JSBracePostFormatProcessor", "processText"));
        }
        if (rangeToReformat == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeToReformat", "com/intellij/lang/javascript/formatter/JSBracePostFormatProcessor", "processText"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/formatter/JSBracePostFormatProcessor", "processText"));
        }
        JSBraceEnforcer jsBraceEnforcer = new JSBraceEnforcer(source.getProject(), settings);
        TextRange textRange = PostFormatProcessorUtil.processText(source, rangeToReformat, settings, (childElement, childRange) -> jsBraceEnforcer.processElementRange((PsiElement)childElement, (TextRange)childRange));
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/formatter/JSBracePostFormatProcessor", "processText"));
        }
        return textRange;
    }

    private static class JSBraceEnforcer
    extends JSRecursiveElementVisitor {
        private CommonCodeStyleSettings mySettings;
        private final CodeStyleSettings myTopSettings;
        private final PostFormatProcessorHelper myPostFormatProcessor;
        private final Project myProject;

        public JSBraceEnforcer(Project project, CodeStyleSettings settings) {
            this.myProject = project;
            this.myTopSettings = settings;
            this.myPostFormatProcessor = new PostFormatProcessorHelper((CommonCodeStyleSettings)settings);
        }

        public void visitJSIfStatement(JSIfStatement node) {
            if (this.myPostFormatProcessor.isElementPartlyInRange((PsiElement)node)) {
                super.visitJSIfStatement(node);
                this.processStatement((JSStatement)node, node.getThen(), this.mySettings.IF_BRACE_FORCE);
                if (!(node.getElse() instanceof JSIfStatement) || !this.mySettings.SPECIAL_ELSE_IF_TREATMENT) {
                    this.processStatement((JSStatement)node, node.getElse(), this.mySettings.IF_BRACE_FORCE);
                }
            }
        }

        public void visitJSDoWhileStatement(JSDoWhileStatement node) {
            if (this.myPostFormatProcessor.isElementPartlyInRange((PsiElement)node)) {
                super.visitJSDoWhileStatement(node);
                this.processStatement((JSStatement)node, node.getBody(), this.mySettings.DOWHILE_BRACE_FORCE);
            }
        }

        public void visitJSWhileStatement(JSWhileStatement node) {
            if (this.myPostFormatProcessor.isElementPartlyInRange((PsiElement)node)) {
                super.visitJSWhileStatement(node);
                this.processStatement((JSStatement)node, node.getBody(), this.mySettings.WHILE_BRACE_FORCE);
            }
        }

        public void visitJSForStatement(JSForStatement node) {
            if (this.myPostFormatProcessor.isElementPartlyInRange((PsiElement)node)) {
                super.visitJSForStatement(node);
                this.processStatement((JSStatement)node, node.getBody(), this.mySettings.FOR_BRACE_FORCE);
            }
        }

        public void visitJSForInStatement(JSForInStatement node) {
            if (this.myPostFormatProcessor.isElementPartlyInRange((PsiElement)node)) {
                super.visitJSForInStatement(node);
                this.processStatement((JSStatement)node, node.getBody(), this.mySettings.FOR_BRACE_FORCE);
            }
        }

        private void processStatement(JSStatement statement, JSStatement blockCandidate, int options) {
            if (blockCandidate instanceof JSBlockStatement || blockCandidate == null) {
                return;
            }
            if (options == 3 || options == 1 && PostFormatProcessorHelper.isMultiline((PsiElement)statement)) {
                this.replaceWithBlock(statement, blockCandidate);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void replaceWithBlock(@NotNull JSStatement parent, JSStatement blockCandidate) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/lang/javascript/formatter/JSBracePostFormatProcessor$JSBraceEnforcer", "replaceWithBlock"));
            }
            assert (parent.isValid());
            if (!this.myPostFormatProcessor.isElementFullyInRange((PsiElement)blockCandidate)) {
                return;
            }
            String oldText = blockCandidate.getText();
            StringBuilder buf = new StringBuilder(oldText.length() + 3);
            buf.append('{');
            buf.append(oldText);
            buf.append("\n}");
            int oldTextLength = parent.getTextLength();
            try {
                ASTNode replacement = JSChangeUtil.createJSTreeFromText(this.myProject, buf.toString(), JSUtils.getDialect(parent.getContainingFile()));
                if (replacement == null) {
                    return;
                }
                ASTNode parentNode = parent.getNode();
                PsiElement blockCandidateNextSibling = blockCandidate.getNextSibling();
                if (blockCandidateNextSibling instanceof PsiWhiteSpace) {
                    CodeEditUtil.removeChild((ASTNode)parentNode, (ASTNode)blockCandidateNextSibling.getNode());
                }
                CodeEditUtil.replaceChild((ASTNode)parentNode, (ASTNode)blockCandidate.getNode(), (ASTNode)replacement);
                PsiDocumentManager docManager = PsiDocumentManager.getInstance((Project)this.myProject);
                Document doc = docManager.getDocument(parent.getContainingFile());
                if (doc != null) {
                    SmartPsiElementPointer pointer = SmartPointerManager.getInstance((Project)this.myProject).createSmartPsiElementPointer((PsiElement)parent);
                    docManager.doPostponedOperationsAndUnblockDocument(doc);
                    JSStatement element = (JSStatement)pointer.getElement();
                    if (element != null) {
                        CodeStyleManager.getInstance((Project)this.myProject).reformatNewlyAddedElement(element.getParent().getNode(), element.getNode());
                    }
                }
            }
            finally {
                this.myPostFormatProcessor.updateResultRange(oldTextLength, parent.getTextLength());
            }
        }

        public TextRange processElementRange(PsiElement element, TextRange rangeToReformat) {
            this.mySettings = this.myTopSettings.getCommonSettings(JSLanguageUtil.getLanguageDialect(element));
            this.myPostFormatProcessor.setResultTextRange(rangeToReformat);
            element.accept((PsiElementVisitor)this);
            return this.myPostFormatProcessor.getResultTextRange();
        }
    }
}

