/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.highlighting;

import com.intellij.codeInsight.highlighting.BraceMatcherTerminationAspect;
import com.intellij.lang.BracePair;
import com.intellij.lang.PairedBraceMatcher;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSBraceMatcher
implements PairedBraceMatcher,
BraceMatcherTerminationAspect {
    private static final BracePair[] PAIRS = new BracePair[]{new BracePair(JSTokenTypes.LPAR, JSTokenTypes.RPAR, false), new BracePair(JSTokenTypes.LBRACKET, JSTokenTypes.RBRACKET, false), new BracePair(JSTokenTypes.LBRACE, JSTokenTypes.RBRACE, true)};

    public BracePair[] getPairs() {
        return PAIRS;
    }

    public boolean isPairedBracesAllowedBeforeType(@NotNull IElementType lbraceType, @Nullable IElementType tokenType) {
        if (lbraceType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lbraceType", "com/intellij/lang/javascript/highlighting/JSBraceMatcher", "isPairedBracesAllowedBeforeType"));
        }
        return JSTokenTypes.WHITE_SPACE == tokenType || JSTokenTypes.COMMENTS.contains(tokenType) || tokenType == JSTokenTypes.SEMICOLON || tokenType == JSTokenTypes.COMMA || tokenType == JSTokenTypes.RPAR || tokenType == JSTokenTypes.RBRACKET || tokenType == JSTokenTypes.RBRACE || tokenType == JSTokenTypes.STRING_TEMPLATE_PART || tokenType == JSTokenTypes.BACKQUOTE || tokenType == JSTokenTypes.GT && lbraceType == JSTokenTypes.LBRACE || null == tokenType;
    }

    public int getCodeConstructStart(PsiFile file, int openingBraceOffset) {
        PsiElement element = file.findElementAt(openingBraceOffset);
        if (element == null || element instanceof PsiFile) {
            return openingBraceOffset;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof JSBlockStatement) {
            parent = parent.getParent();
        }
        return parent.getTextRange().getStartOffset();
    }

    public boolean shouldStopMatch(boolean forward, @NotNull IElementType braceType, @NotNull HighlighterIterator iterator) {
        if (braceType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "braceType", "com/intellij/lang/javascript/highlighting/JSBraceMatcher", "shouldStopMatch"));
        }
        if (iterator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterator", "com/intellij/lang/javascript/highlighting/JSBraceMatcher", "shouldStopMatch"));
        }
        IElementType currType = iterator.getTokenType();
        if (forward && currType == JSTokenTypes.RPAR && braceType != JSTokenTypes.LPAR) {
            int retreatCount = 0;
            iterator.retreat();
            ++retreatCount;
            currType = iterator.getTokenType();
            if (currType == JSTokenTypes.WHITE_SPACE) {
                iterator.retreat();
                ++retreatCount;
                currType = iterator.getTokenType();
            }
            for (int i = retreatCount; i > 0; --i) {
                iterator.advance();
            }
            if (currType == braceType) {
                return true;
            }
        }
        return false;
    }
}

