/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.inspections.NewLineEraser;
import com.intellij.lang.javascript.intentions.ES6CoolRefactoring;
import com.intellij.lang.javascript.intentions.JSFunctionsHelper;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ES6ConvertForEachToForOfIntention
extends JavaScriptIntention
implements ES6CoolRefactoring {
    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/inspections/ES6ConvertForEachToForOfIntention", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/inspections/ES6ConvertForEachToForOfIntention", "isAvailable"));
        }
        if (!super.isAvailable(project, editor, element)) {
            return false;
        }
        if (!ES6CoolRefactoring.isEs6Compatible(element)) {
            return false;
        }
        if (element.getContainingFile() instanceof JSFile || PsiTreeUtil.getParentOfType((PsiElement)element, JSEmbeddedContent.class, (boolean)false) != null) {
            return new MyParser(element).isValid();
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/inspections/ES6ConvertForEachToForOfIntention", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/inspections/ES6ConvertForEachToForOfIntention", "invoke"));
        }
        MyParser parser = new MyParser(element);
        if (!parser.isValid()) {
            return;
        }
        ES6ConvertForEachToForOfIntention.fixImpl(parser);
    }

    private static void fixImpl(@NotNull MyParser parser) {
        if (parser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parser", "com/intellij/lang/javascript/inspections/ES6ConvertForEachToForOfIntention", "fixImpl"));
        }
        String parameter = parser.getForEachParameter() != null ? parser.getForEachParameter().getText() : parser.getNewForParameterName();
        StringBuilder sb = new StringBuilder("for (const ").append(parameter).append(" of arr) {}");
        Project project = parser.getHook().getProject();
        JSForInStatement forInStatement = (JSForInStatement)JSChangeUtil.createStatementFromText(project, sb.toString()).getPsi(JSForInStatement.class);
        assert (forInStatement != null);
        forInStatement.getCollectionExpression().replace(parser.getQualifier());
        ES6ConvertForEachToForOfIntention.replaceBody(project, parser, forInStatement, parameter);
        if (parser.getElement().getParent() instanceof JSStatement) {
            parser.getElement().getParent().replace((PsiElement)forInStatement);
        } else {
            parser.getElement().replace((PsiElement)forInStatement);
        }
    }

    private static void replaceBody(Project project, @NotNull MyParser parser, JSForInStatement forInStatement, String parameter) {
        if (parser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parser", "com/intellij/lang/javascript/inspections/ES6ConvertForEachToForOfIntention", "replaceBody"));
        }
        assert (forInStatement.getBody() instanceof JSBlockStatement);
        if (parser.getHookReference() != null) {
            StringBuilder text = new StringBuilder("{\n").append(parser.getHookReference().getText()).append("(").append(parameter);
            if (parser.getHookArgNum() > 1) {
                text.append(", -1");
            }
            if (parser.getHookArgNum() > 2) {
                text.append(", ").append(parser.getQualifier().getText());
            }
            text.append(");\n}");
            JSBlockStatement newBlock = (JSBlockStatement)JSChangeUtil.createStatementFromText(project, text.toString()).getPsi(JSBlockStatement.class);
            forInStatement.getBody().replace((JSStatement)newBlock);
        } else {
            JSStatement block = JSFunctionsHelper.moveFunctionBody(parser.getHook(), (JSBlockStatement)forInStatement.getBody());
            Collection returnStatements = PsiTreeUtil.findChildrenOfType((PsiElement)block, JSReturnStatement.class);
            for (JSReturnStatement statement : returnStatements) {
                JSExpression expression = statement.getExpression();
                if (expression instanceof JSReferenceExpression || expression instanceof JSLiteralExpression || expression instanceof JSArrayLiteralExpression) {
                    NewLineEraser eraser = new NewLineEraser((PsiElement)statement);
                    statement.delete();
                    eraser.process();
                    continue;
                }
                statement.replace((JSStatement)JSChangeUtil.createStatementFromText(project, expression.getText() + JSCodeStyleSettings.getSemicolon(forInStatement.getContainingFile())).getPsi(JSStatement.class));
            }
        }
    }

    @NotNull
    public String getText() {
        String string = JSBundle.message((String)"js.convert.for.each.to.for.of.intention.text", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/ES6ConvertForEachToForOfIntention", "getText"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"js.convert.for.each.to.for.of.intention.family", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/ES6ConvertForEachToForOfIntention", "getFamilyName"));
        }
        return string;
    }

    private static class MyParser {
        private final PsiElement myElement;
        private JSParameter myForEachParameter;
        private JSFunction myHook;
        private int myHookArgNum;
        private JSExpression myQualifier;
        private JSReferenceExpression myHookReference;
        private boolean myIsValid;
        private static TokenSet PRIMITIVES = TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.DOT, JSTokenTypes.COMMA, JSTokenTypes.LBRACKET, JSTokenTypes.RBRACKET, JSTokenTypes.LPAR, JSTokenTypes.RPAR});

        public MyParser(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/inspections/ES6ConvertForEachToForOfIntention$MyParser", "<init>"));
            }
            this.myElement = element = MyParser.findFunctionCall(element);
            if (!(element instanceof JSCallExpression)) {
                return;
            }
            JSCallExpression call = (JSCallExpression)element;
            JSExpression method = call.getMethodExpression();
            JSExpression[] arguments = call.getArguments();
            if (!(method instanceof JSReferenceExpression)) {
                return;
            }
            if (!"forEach".equals(((JSReferenceExpression)method).getReferenceName())) {
                return;
            }
            if (!this.checkArguments(arguments)) {
                return;
            }
            if (!this.checkQualifier(((JSReferenceExpression)method).getQualifier())) {
                return;
            }
            this.myIsValid = true;
        }

        public String getNewForParameterName() {
            return JSChangeUtil.generateNewVarName("item", (PsiElement)this.myHook);
        }

        private static PsiElement findFunctionCall(PsiElement element) {
            PsiElement call;
            if (element instanceof JSCallExpression) {
                return element;
            }
            if (PRIMITIVES.contains(element.getNode().getElementType()) || JSTokenTypes.OPERATIONS.contains(element.getNode().getElementType())) {
                element = element.getParent();
            }
            if (element.getNode().getElementType() == JSTokenTypes.IDENTIFIER) {
                element = element.getParent();
            }
            if (JSTokenTypes.LITERALS.contains(element.getNode().getElementType()) && element.getParent() instanceof JSLiteralExpression) {
                element = element.getParent();
            }
            while (element instanceof JSExpression && !(element instanceof JSReferenceExpression)) {
                element = element.getParent();
            }
            if (element instanceof JSReferenceExpression && (call = JSResolveUtil.getTopReferenceParent(element)) instanceof JSCallExpression) {
                return call;
            }
            return null;
        }

        @NotNull
        public PsiElement getElement() {
            PsiElement psiElement = this.myElement;
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/ES6ConvertForEachToForOfIntention$MyParser", "getElement"));
            }
            return psiElement;
        }

        public JSParameter getForEachParameter() {
            return this.myForEachParameter;
        }

        public JSFunction getHook() {
            return this.myHook;
        }

        public boolean isValid() {
            return this.myIsValid;
        }

        public JSExpression getQualifier() {
            return this.myQualifier;
        }

        public JSReferenceExpression getHookReference() {
            return this.myHookReference;
        }

        public int getHookArgNum() {
            return this.myHookArgNum;
        }

        private boolean checkQualifier(JSExpression qualifier) {
            if (qualifier == null) {
                return false;
            }
            this.myQualifier = qualifier;
            return true;
        }

        private boolean checkArguments(JSExpression[] arguments) {
            if (arguments.length != 1) {
                return false;
            }
            if (arguments[0] instanceof JSReferenceExpression) {
                this.myHookReference = (JSReferenceExpression)arguments[0];
                PsiElement resolve = this.myHookReference.resolve();
                if (resolve == null || !resolve.isValid() || !(resolve instanceof JSFunction)) {
                    return false;
                }
                this.myHook = (JSFunction)resolve;
            } else if (arguments[0] instanceof JSFunction) {
                this.myHook = (JSFunction)arguments[0];
            } else {
                return false;
            }
            JSParameter[] parameters = this.myHook.getParameterVariables();
            this.myHookArgNum = parameters.length;
            if (this.myHookArgNum > 3) {
                return false;
            }
            if (this.myHookArgNum >= 1) {
                this.myForEachParameter = parameters[0];
            }
            if (this.myHookArgNum >= 2) {
                return ReferencesSearch.search((PsiElement)parameters[1], (SearchScope)new LocalSearchScope((PsiElement)this.myHook)).findFirst() == null;
            }
            return true;
        }
    }
}

