/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.intentions.ES6ConvertToTemplateStringHelper;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseIntroduceHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSStringConcatenationToES6TemplateHelper {
    private static final Set<Character> TO_ESCAPE = "nrtfbr`{}".chars().mapToObj(value -> Character.valueOf((char)value)).collect(Collectors.toSet());
    private static final Condition<PsiElement> BINARY_OR_CONDITIONAL_EXPRESSION_PREDICATE = element -> element instanceof JSBinaryExpression || element instanceof JSConditionalExpression;

    @NotNull
    static String unquoteUnescapeEscape(@Nullable PsiElement element) {
        if (element == null) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/intentions/JSStringConcatenationToES6TemplateHelper", "unquoteUnescapeEscape"));
            }
            return "";
        }
        String string = StringUtil.unquoteString((String)element.getText());
        StringBuilder sb = new StringBuilder();
        boolean escaped = false;
        for (int i = 0; i < string.length(); ++i) {
            char ch = string.charAt(i);
            if (!escaped) {
                if ('\\' == ch) {
                    escaped = true;
                    continue;
                }
                if ('`' == ch || '{' == ch) {
                    sb.append("\\").append(ch);
                    continue;
                }
                sb.append(ch);
                continue;
            }
            if ('`' == ch || '{' == ch) {
                sb.append("\\").append(ch);
            } else if ('\"' != ch && '\'' != ch) {
                sb.append('\\');
            }
            sb.append(ch);
            escaped = false;
        }
        String string2 = sb.toString();
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/intentions/JSStringConcatenationToES6TemplateHelper", "unquoteUnescapeEscape"));
        }
        return string2;
    }

    public static PsiElement findSuitableExpression(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/JSStringConcatenationToES6TemplateHelper", "findSuitableExpression"));
        }
        List<JSExpression> list = JSStringConcatenationToES6TemplateHelper.findExpressionsList(element);
        if (list == null) {
            PsiLanguageInjectionHost host = InjectedLanguageUtil.findInjectionHost((PsiElement)element);
            if (host != null) {
                list = JSStringConcatenationToES6TemplateHelper.findExpressionsList((PsiElement)host);
            }
            if (list == null) {
                return JSStringConcatenationToES6TemplateHelper.tryLiteralVariant(element);
            }
        }
        Collections.reverse(list);
        for (JSExpression expression : list) {
            ES6ConvertToTemplateStringHelper helper = new ES6ConvertToTemplateStringHelper(expression);
            helper.process();
            if (!helper.isValid()) continue;
            return JSStringConcatenationToES6TemplateHelper.replaceStringWithTemplate((PsiElement)expression, helper.convert());
        }
        return JSStringConcatenationToES6TemplateHelper.tryLiteralVariant(element);
    }

    private static PsiElement tryLiteralVariant(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/JSStringConcatenationToES6TemplateHelper", "tryLiteralVariant"));
        }
        if (element instanceof JSLiteralExpression && ((JSLiteralExpression)element).isQuotedLiteral()) {
            return JSStringConcatenationToES6TemplateHelper.replaceStringWithTemplate(element);
        }
        if (element instanceof LeafPsiElement && ((LeafPsiElement)element).getElementType() == JSTokenTypes.STRING_LITERAL && element.getParent() instanceof JSLiteralExpression) {
            return JSStringConcatenationToES6TemplateHelper.replaceStringWithTemplate(element);
        }
        return null;
    }

    @Nullable
    public static List<JSExpression> findExpressionsList(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/JSStringConcatenationToES6TemplateHelper", "findExpressionsList"));
        }
        return JSStringConcatenationToES6TemplateHelper.findExpressionListImpl(element, true);
    }

    @Nullable
    private static List<JSExpression> findExpressionListImpl(@NotNull PsiElement element, boolean adjustElement) {
        JSExpression parent;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/JSStringConcatenationToES6TemplateHelper", "findExpressionListImpl"));
        }
        ArrayList<JSExpression> list = new ArrayList<JSExpression>();
        JSExpression previous = null;
        while ((parent = (JSExpression)PsiTreeUtil.findFirstParent((PsiElement)(previous == null ? element : previous.getParent()), BINARY_OR_CONDITIONAL_EXPRESSION_PREDICATE)) != null) {
            list.add(parent);
            previous = parent;
        }
        if (previous == null) {
            if (adjustElement) {
                return JSStringConcatenationToES6TemplateHelper.findExpressionListImpl(JSBaseIntroduceHandler.adjustElement(element.getTextRange().getStartOffset(), element), false);
            }
            return null;
        }
        return list;
    }

    static PsiElement replaceStringWithTemplate(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/JSStringConcatenationToES6TemplateHelper", "replaceStringWithTemplate"));
        }
        return JSStringConcatenationToES6TemplateHelper.replaceStringWithTemplate(element, "`" + JSStringConcatenationToES6TemplateHelper.unquoteUnescapeEscape(element) + "`");
    }

    static PsiElement replaceStringWithTemplate(@NotNull PsiElement element, @NotNull String text) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/JSStringConcatenationToES6TemplateHelper", "replaceStringWithTemplate"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/javascript/intentions/JSStringConcatenationToES6TemplateHelper", "replaceStringWithTemplate"));
        }
        Language dialect = JSStringConcatenationToES6TemplateHelper.getLanguage(element);
        PsiFile dummy = PsiFileFactory.getInstance((Project)element.getProject()).createFileFromText(dialect, (CharSequence)text);
        return element.replace(PsiTreeUtil.findChildOfType((PsiElement)dummy, JSLiteralExpression.class));
    }

    private static Language getLanguage(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/JSStringConcatenationToES6TemplateHelper", "getLanguage"));
        }
        JSLanguageDialect dialect = DialectDetector.getLanguageDialect(element);
        if (dialect != null) {
            return dialect;
        }
        return JavascriptLanguage.INSTANCE;
    }
}

