/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.lang.javascript.linter.IntentionActionWithTimeout;
import com.intellij.lang.javascript.linter.NavigateToPropertyInConfig;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class JSLinterEditConfigFileAction
extends IntentionActionWithTimeout
implements Iconable {
    protected final VirtualFile myVirtualFile;
    private final Icon myIcon;
    private String myProperty;

    public JSLinterEditConfigFileAction(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/lang/javascript/linter/JSLinterEditConfigFileAction", "<init>"));
        }
        super(50);
        this.myVirtualFile = virtualFile;
        this.myIcon = virtualFile.getFileType().getIcon();
    }

    public void setProperty(String property) {
        this.myProperty = property;
    }

    public Icon getIcon(@Iconable.IconFlags int flags) {
        return this.myIcon;
    }

    @Override
    @NotNull
    public String getText() {
        if (this.myProperty != null) {
            String string = "Edit " + this.myProperty + " in " + this.myVirtualFile.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterEditConfigFileAction", "getText"));
            }
            return string;
        }
        String string = "Edit " + this.myVirtualFile.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterEditConfigFileAction", "getText"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterEditConfigFileAction", "getFamilyName"));
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/JSLinterEditConfigFileAction", "isAvailable"));
        }
        return true;
    }

    @Override
    public void invokeReally(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/JSLinterEditConfigFileAction", "invokeReally"));
        }
        if (this.myProperty != null) {
            NavigateToPropertyInConfig.navigate(project, this.myVirtualFile, this.myProperty);
        } else {
            FileEditorManager manager = FileEditorManager.getInstance((Project)project);
            manager.openFile(this.myVirtualFile, true);
        }
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }
}

