/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.json.psi.JsonProperty;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.OpenSourceUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class NavigateToPropertyInConfig {
    public static void navigate(@NotNull Project project, @NotNull VirtualFile virtualFile, @NotNull String code) {
        PsiFile file;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/NavigateToPropertyInConfig", "navigate"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/lang/javascript/linter/NavigateToPropertyInConfig", "navigate"));
        }
        if (code == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "code", "com/intellij/lang/javascript/linter/NavigateToPropertyInConfig", "navigate"));
        }
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
        if (document != null && (file = PsiDocumentManager.getInstance((Project)project).getPsiFile(document)) != null) {
            Collection properties = PsiTreeUtil.findChildrenOfType((PsiElement)file, JsonProperty.class);
            for (JsonProperty property : properties) {
                if (!code.equals(property.getName())) continue;
                OpenSourceUtil.navigate((boolean)true, (Navigatable[])new Navigatable[]{new OpenFileDescriptor(project, virtualFile, property.getTextOffset())});
                return;
            }
        }
        OpenSourceUtil.navigate((boolean)true, (Navigatable[])new Navigatable[]{new OpenFileDescriptor(project, virtualFile)});
    }
}

