/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint;

import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.lang.javascript.linter.JSNpmLinterState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EslintState
implements JSNpmLinterState<EslintState> {
    public static final EslintState DEFAULT = new Builder().build();
    private final NodeJsInterpreterRef myInterpreterRef;
    private final String myEslintPackagePath;
    private final boolean myCustomConfigFileUsed;
    private final String myCustomConfigFilePath;
    private final String myAdditionalRulesDirPath;
    private final String myExtraOptions;

    public EslintState(@NotNull Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/lang/javascript/linter/eslint/EslintState", "<init>"));
        }
        this.myInterpreterRef = builder.myInterpreterRef;
        this.myEslintPackagePath = builder.myEslintPackagePath;
        this.myCustomConfigFileUsed = builder.myCustomConfigFileUsed;
        this.myCustomConfigFilePath = builder.myCustomConfigFilePath;
        this.myAdditionalRulesDirPath = builder.myAdditionalRulesDirPath;
        this.myExtraOptions = builder.myExtraOptions;
    }

    @Override
    @NotNull
    public NodeJsInterpreterRef getInterpreterRef() {
        NodeJsInterpreterRef nodeJsInterpreterRef = this.myInterpreterRef;
        if (nodeJsInterpreterRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintState", "getInterpreterRef"));
        }
        return nodeJsInterpreterRef;
    }

    @NotNull
    public String getEslintPackagePath() {
        String string = this.myEslintPackagePath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintState", "getEslintPackagePath"));
        }
        return string;
    }

    public boolean isCustomConfigFileUsed() {
        return this.myCustomConfigFileUsed;
    }

    @NotNull
    public String getCustomConfigFilePath() {
        String string = this.myCustomConfigFilePath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintState", "getCustomConfigFilePath"));
        }
        return string;
    }

    @NotNull
    public String getAdditionalRulesDirPath() {
        String string = this.myAdditionalRulesDirPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintState", "getAdditionalRulesDirPath"));
        }
        return string;
    }

    @NotNull
    public String getExtraOptions() {
        String string = this.myExtraOptions;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintState", "getExtraOptions"));
        }
        return string;
    }

    @Override
    @Nullable
    public String getLinterPackagePath() {
        return this.myEslintPackagePath;
    }

    @Override
    public EslintState withLinterPackagePath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/lang/javascript/linter/eslint/EslintState", "withLinterPackagePath"));
        }
        return new EslintState(new Builder(this).setEslintPackagePath(path));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EslintState state = (EslintState)o;
        return this.myCustomConfigFileUsed == state.myCustomConfigFileUsed && this.myCustomConfigFilePath.equals(state.myCustomConfigFilePath) && this.myEslintPackagePath.equals(state.myEslintPackagePath) && this.myInterpreterRef.getReferenceName().equals(state.myInterpreterRef.getReferenceName()) && this.myAdditionalRulesDirPath.equals(state.myAdditionalRulesDirPath) && this.myExtraOptions.equals(state.myExtraOptions);
    }

    public int hashCode() {
        int result = this.myInterpreterRef.getReferenceName().hashCode();
        result = 31 * result + this.myEslintPackagePath.hashCode();
        result = 31 * result + (this.myCustomConfigFileUsed ? 1 : 0);
        result = 31 * result + this.myCustomConfigFilePath.hashCode();
        result = 31 * result + this.myAdditionalRulesDirPath.hashCode();
        result = 31 * result + this.myExtraOptions.hashCode();
        return result;
    }

    public String toString() {
        return "node=" + this.myInterpreterRef.getReferenceName() + ", eslint=" + this.myEslintPackagePath + ", isCustomConfig=" + this.myCustomConfigFileUsed + ", customConfig=" + this.myCustomConfigFilePath + ", rulesDir='" + this.myAdditionalRulesDirPath + ", extraOptions='" + this.myExtraOptions;
    }

    public static class Builder {
        private NodeJsInterpreterRef myInterpreterRef;
        private String myEslintPackagePath;
        private boolean myCustomConfigFileUsed;
        private String myCustomConfigFilePath;
        private String myAdditionalRulesDirPath;
        private String myExtraOptions;

        public Builder() {
            this.myInterpreterRef = NodeJsInterpreterRef.createProjectRef();
            this.myEslintPackagePath = "";
            this.myCustomConfigFileUsed = false;
            this.myCustomConfigFilePath = "";
            this.myAdditionalRulesDirPath = "";
            this.myExtraOptions = "";
        }

        public Builder(@NotNull EslintState state) {
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/linter/eslint/EslintState$Builder", "<init>"));
            }
            this.myInterpreterRef = NodeJsInterpreterRef.createProjectRef();
            this.myEslintPackagePath = "";
            this.myCustomConfigFileUsed = false;
            this.myCustomConfigFilePath = "";
            this.myAdditionalRulesDirPath = "";
            this.myExtraOptions = "";
            this.myInterpreterRef = state.getInterpreterRef();
            this.myEslintPackagePath = state.getEslintPackagePath();
            this.myCustomConfigFileUsed = state.isCustomConfigFileUsed();
            this.myCustomConfigFilePath = state.getCustomConfigFilePath();
            this.myAdditionalRulesDirPath = state.getAdditionalRulesDirPath();
            this.myExtraOptions = state.getExtraOptions();
        }

        @NotNull
        public Builder setInterpreterRef(@NotNull NodeJsInterpreterRef interpreterRef) {
            if (interpreterRef == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreterRef", "com/intellij/lang/javascript/linter/eslint/EslintState$Builder", "setInterpreterRef"));
            }
            this.myInterpreterRef = interpreterRef;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintState$Builder", "setInterpreterRef"));
            }
            return builder;
        }

        @NotNull
        public Builder setEslintPackagePath(@NotNull String eslintPackagePath) {
            if (eslintPackagePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eslintPackagePath", "com/intellij/lang/javascript/linter/eslint/EslintState$Builder", "setEslintPackagePath"));
            }
            this.myEslintPackagePath = eslintPackagePath;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintState$Builder", "setEslintPackagePath"));
            }
            return builder;
        }

        @NotNull
        public Builder setCustomConfigFileUsed(boolean customConfigFileUsed) {
            this.myCustomConfigFileUsed = customConfigFileUsed;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintState$Builder", "setCustomConfigFileUsed"));
            }
            return builder;
        }

        @NotNull
        public Builder setCustomConfigFilePath(@NotNull String customConfigFilePath) {
            if (customConfigFilePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "customConfigFilePath", "com/intellij/lang/javascript/linter/eslint/EslintState$Builder", "setCustomConfigFilePath"));
            }
            this.myCustomConfigFilePath = customConfigFilePath;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintState$Builder", "setCustomConfigFilePath"));
            }
            return builder;
        }

        @NotNull
        public Builder setAdditionalRulesDirPath(@NotNull String additionalRulesDirPath) {
            if (additionalRulesDirPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "additionalRulesDirPath", "com/intellij/lang/javascript/linter/eslint/EslintState$Builder", "setAdditionalRulesDirPath"));
            }
            this.myAdditionalRulesDirPath = additionalRulesDirPath;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintState$Builder", "setAdditionalRulesDirPath"));
            }
            return builder;
        }

        @NotNull
        public Builder setExtraOptions(@NotNull String extraOptions) {
            if (extraOptions == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extraOptions", "com/intellij/lang/javascript/linter/eslint/EslintState$Builder", "setExtraOptions"));
            }
            this.myExtraOptions = extraOptions;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintState$Builder", "setExtraOptions"));
            }
            return builder;
        }

        @NotNull
        public EslintState build() {
            EslintState eslintState = new EslintState(this);
            if (eslintState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintState$Builder", "build"));
            }
            return eslintState;
        }
    }
}

