/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jscs.config;

import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonBooleanLiteral;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonNullLiteral;
import com.intellij.json.psi.JsonNumberLiteral;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.javascript.linter.jscs.config.JscsConfigFileType;
import com.intellij.lang.javascript.linter.jscs.config.JscsOption;
import com.intellij.lang.javascript.linter.jscs.config.JscsOptionDescriptor;
import com.intellij.lang.javascript.linter.jscs.config.ValueType;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairConsumer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JscsConfigFileAnnotator
implements Annotator {
    private static final Key<Set<JsonProperty>> ANNOTATED_PROPERTIES = Key.create((String)"JavaScript.Linters.JSCS.Annotated");

    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/linter/jscs/config/JscsConfigFileAnnotator", "annotate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/javascript/linter/jscs/config/JscsConfigFileAnnotator", "annotate"));
        }
        JsonFile jsonFile = JscsConfigFileAnnotator.checkFile(element);
        if (jsonFile != null) {
            JscsConfigFileAnnotator.annotateMe(jsonFile, holder);
        } else {
            PsiElement child;
            JsonObject object;
            PsiFile containingFile = element.getContainingFile();
            JsonFile wrapperJsonFile = JscsConfigFileAnnotator.checkFile((PsiElement)containingFile);
            if (wrapperJsonFile != null && (object = (JsonObject)ObjectUtils.tryCast((Object)(child = wrapperJsonFile.getFirstChild()), JsonObject.class)) != null) {
                PsiElement current = element;
                while (true) {
                    JsonProperty property;
                    if ((property = (JsonProperty)PsiTreeUtil.getParentOfType((PsiElement)current, JsonProperty.class)) == null) {
                        return;
                    }
                    if (property.getParent().equals(object)) {
                        JscsConfigFileAnnotator.checkProperty(holder, new JscsOptionsChecker(), property);
                        break;
                    }
                    current = property.getParent();
                }
            }
        }
    }

    private static JsonFile checkFile(PsiElement element) {
        VirtualFile vFile;
        JsonFile file = (JsonFile)ObjectUtils.tryCast((Object)element, JsonFile.class);
        if (file != null && ((Object)((Object)JscsConfigFileType.INSTANCE)).equals((vFile = file.getViewProvider().getVirtualFile()).getFileType())) {
            return file;
        }
        return null;
    }

    private static void annotateMe(JsonFile file, AnnotationHolder holder) {
        for (PsiElement element : file.getChildren()) {
            JsonObject objectLiteralExpression = (JsonObject)ObjectUtils.tryCast((Object)element, JsonObject.class);
            if (objectLiteralExpression == null) continue;
            JscsConfigFileAnnotator.iterateOptions(objectLiteralExpression, holder, new JscsOptionsChecker());
            break;
        }
    }

    private static <T> void iterateOptions(JsonObject jsonObject, AnnotationHolder holder, OptionChecker<T> checker) {
        List properties = jsonObject.getPropertyList();
        for (JsonProperty property : properties) {
            JscsConfigFileAnnotator.checkProperty(holder, checker, property);
        }
    }

    private static <T> void checkProperty(AnnotationHolder holder, OptionChecker<T> checker, JsonProperty property) {
        String name = property.getName();
        AnnotationSession session = holder.getCurrentAnnotationSession();
        HashSet<JsonProperty> data = (HashSet<JsonProperty>)session.getUserData(ANNOTATED_PROPERTIES);
        if (data == null) {
            data = new HashSet<JsonProperty>();
            session.putUserData(ANNOTATED_PROPERTIES, data);
        }
        if (data.contains(property)) {
            return;
        }
        data.add(property);
        T parsedOption = checker.isValidName(name);
        if (parsedOption != null) {
            checker.processOption(property, parsedOption, holder);
        } else {
            JscsConfigFileAnnotator.createWarningAnnotation(holder, (PsiElement)property.getNameElement(), "Unknown " + checker.getOptionClassName() + " option name");
        }
    }

    private static String getReplacementValuesMessage(@NotNull JscsOption option) {
        if (option == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "option", "com/intellij/lang/javascript/linter/jscs/config/JscsConfigFileAnnotator", "getReplacementValuesMessage"));
        }
        if (option.getDescriptor().isWithKeywords()) {
            return "keywords (if, else, while, ...)";
        }
        if (option.getDescriptor().isWithBinaryOperators()) {
            return "binary operators (+,>,/, ...)";
        }
        if (option.getDescriptor().isWithOperators()) {
            return "operators (+,>,?, ...)";
        }
        return null;
    }

    private static boolean createExpectedTypesAnnotation(List<ValueType> types, AnnotationHolder holder, JsonValue value) {
        new AnnotationTextBuilder(holder, (PsiElement)value).withTypes(types).build();
        return true;
    }

    private static void createWarningAnnotation(@NotNull AnnotationHolder holder, @NotNull PsiElement elt, @Nullable String message) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/javascript/linter/jscs/config/JscsConfigFileAnnotator", "createWarningAnnotation"));
        }
        if (elt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elt", "com/intellij/lang/javascript/linter/jscs/config/JscsConfigFileAnnotator", "createWarningAnnotation"));
        }
        Annotation annotation = holder.createWarningAnnotation(elt, message);
        annotation.setNeedsUpdateOnTyping(true);
    }

    public static class AnnotationTextBuilder {
        @Nullable
        private final AnnotationHolder myHolder;
        @NotNull
        private final PsiElement myElt;
        private String myOptionsReplacement;
        private String[] myOptions;
        private ValueType myExcludeType;
        private boolean myWithOptions;
        private boolean myWithTypes;
        private List<ValueType> myOtherTypes;

        public AnnotationTextBuilder(@Nullable AnnotationHolder holder, @NotNull PsiElement elt) {
            if (elt == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elt", "com/intellij/lang/javascript/linter/jscs/config/JscsConfigFileAnnotator$AnnotationTextBuilder", "<init>"));
            }
            this.myHolder = holder;
            this.myElt = elt;
        }

        public AnnotationTextBuilder withOptionsReplacement(String optionsReplacement) {
            this.myOptionsReplacement = optionsReplacement;
            this.myWithOptions = true;
            return this;
        }

        public AnnotationTextBuilder withOptions(String[] options) {
            if (options != null && options.length == 0) {
                return this;
            }
            this.myOptions = options;
            this.myOptionsReplacement = null;
            this.myWithOptions = true;
            return this;
        }

        public AnnotationTextBuilder withTypes(ValueType excludeType, @NotNull JscsOption option) {
            if (option == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "option", "com/intellij/lang/javascript/linter/jscs/config/JscsConfigFileAnnotator$AnnotationTextBuilder", "withTypes"));
            }
            this.myExcludeType = excludeType;
            this.myWithTypes = true;
            this.myOtherTypes = option.otherTypes(this.myExcludeType);
            return this;
        }

        public AnnotationTextBuilder withTypes(@NotNull List<ValueType> otherTypes) {
            if (otherTypes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "otherTypes", "com/intellij/lang/javascript/linter/jscs/config/JscsConfigFileAnnotator$AnnotationTextBuilder", "withTypes"));
            }
            this.myWithTypes = true;
            this.myOtherTypes = otherTypes;
            return this;
        }

        public AnnotationTextBuilder withTypes(@NotNull JscsOption option) {
            if (option == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "option", "com/intellij/lang/javascript/linter/jscs/config/JscsConfigFileAnnotator$AnnotationTextBuilder", "withTypes"));
            }
            this.myWithTypes = true;
            this.myOtherTypes = option.otherTypes(null);
            return this;
        }

        public void build() {
            String text = this.getText();
            if (text == null) {
                return;
            }
            JscsConfigFileAnnotator.createWarningAnnotation(this.myHolder, this.myElt, text);
        }

        @Nullable
        public String getText() {
            if (!this.myWithOptions && !this.myWithTypes) {
                return null;
            }
            StringBuilder sb = new StringBuilder("Expected");
            int cnt = 0;
            if (this.myWithOptions) {
                if (this.myOptions == null || this.myOptions.length > 1) {
                    sb.append(" values: ");
                } else {
                    sb.append(" value: ");
                }
                cnt = this.appendOptionsValues(sb, cnt);
            }
            if (this.myWithTypes) {
                if (!this.myWithOptions) {
                    sb.append(": ");
                }
                AnnotationTextBuilder.appendTypes(this.myOtherTypes, sb, cnt);
            }
            return sb.toString();
        }

        private static void appendTypes(List<ValueType> otherTypes, StringBuilder sb, int cnt) {
            for (ValueType otherType : otherTypes) {
                if (cnt > 0) {
                    sb.append(" or ");
                }
                sb.append(otherType.getNameOrFixedValue());
                ++cnt;
            }
        }

        private int appendOptionsValues(StringBuilder sb, int cnt) {
            if (this.myOptionsReplacement != null) {
                sb.append(this.myOptionsReplacement);
                ++cnt;
            } else if (this.myOptions != null) {
                for (String s : this.myOptions) {
                    if (cnt > 0) {
                        sb.append(", ");
                    }
                    if ("\t".equals(s)) {
                        sb.append("\"\\t\"");
                    } else if (s.length() == 1) {
                        sb.append(s);
                    } else {
                        sb.append("\"").append(s).append("\"");
                    }
                    ++cnt;
                }
            }
            return cnt;
        }
    }

    private static class JscsOptionsChecker
    implements OptionChecker<JscsOption> {
        private static final Map<Class<? extends JsonValue>, ValueType> typesCombinations = new HashMap<Class<? extends JsonValue>, ValueType>();

        private JscsOptionsChecker() {
        }

        @Override
        public JscsOption isValidName(String name) {
            return JscsOption.safeValueOf(name);
        }

        @Override
        public String getOptionClassName() {
            return "JSCS";
        }

        @Override
        public void processOption(JsonProperty property, JscsOption option, AnnotationHolder holder) {
            JsonValue value = property.getValue();
            if (value == null || ObjectUtils.tryCast((Object)value, JsonNullLiteral.class) != null) {
                return;
            }
            if (!(option.canBe(ValueType.bool) && JscsOptionsChecker.isBooleanLiteral(option.otherTypes(null), holder, value) || option.canBe(ValueType.true_or_false) && JscsOptionsChecker.isTrueOrFalse(option.otherTypes(null), holder, value))) {
                Map<ValueType, JscsOptionDescriptor.ValueDescription> types = option.getDescriptor().getTypes();
                if (JscsOptionsChecker.customValidation(types, option.otherTypes(null), value, holder)) {
                    return;
                }
                if (!(option.canBe(ValueType.obj) && JscsOptionsChecker.isObjectLiteral(types, holder, value, option.name()) || option.canBe(ValueType.str) && JscsOptionsChecker.isStringLiteral(types, option.getTypesList(), holder, value) || option.canBe(ValueType.array) && JscsOptionsChecker.isArray(types, holder, value, JscsConfigFileAnnotator.getReplacementValuesMessage(option)) || option.canBe(ValueType.num_int) && JscsOptionsChecker.isIntLiteral(option.otherTypes(null), holder, value))) {
                    JscsConfigFileAnnotator.createExpectedTypesAnnotation(option.otherTypes(null), holder, value);
                }
            }
        }

        private static boolean customValidation(Map<ValueType, JscsOptionDescriptor.ValueDescription> types, List<ValueType> typesList, JsonValue value, AnnotationHolder holder) {
            ValueType foundType = null;
            for (Map.Entry<Class<? extends JsonValue>, ValueType> entry : typesCombinations.entrySet()) {
                Class<? extends JsonValue> aClass = entry.getKey();
                if (!aClass.isAssignableFrom(value.getClass())) continue;
                if (!types.containsKey((Object)entry.getValue())) {
                    return JscsConfigFileAnnotator.createExpectedTypesAnnotation(typesList, holder, value);
                }
                foundType = entry.getValue();
            }
            if (foundType == null) {
                return JscsConfigFileAnnotator.createExpectedTypesAnnotation(typesList, holder, value);
            }
            JscsOptionDescriptor.ValueDescription description = types.get((Object)foundType);
            if (description instanceof JscsOptionDescriptor.CustomValidation) {
                String checkResult = ((JscsOptionDescriptor.CustomValidation)description).check(value);
                if (checkResult != null) {
                    JscsConfigFileAnnotator.createWarningAnnotation(holder, (PsiElement)value, checkResult);
                }
                return true;
            }
            return false;
        }

        private static boolean isObjectLiteral(Map<ValueType, JscsOptionDescriptor.ValueDescription> map, AnnotationHolder holder, JsonValue value, final String parentName) {
            JsonObject jsonObj = (JsonObject)ObjectUtils.tryCast((Object)value, JsonObject.class);
            if (jsonObj == null) {
                return false;
            }
            JscsOptionDescriptor.ValueDescription valDescriptor = map.get((Object)ValueType.obj);
            if (valDescriptor.equals(JscsOptionDescriptor.ValueDescription.NO_VALIDATION)) {
                return true;
            }
            final JscsOptionDescriptor.ValuesObject descriptor = (JscsOptionDescriptor.ValuesObject)valDescriptor;
            String mandatory = descriptor.getMandatory();
            if (mandatory != null && jsonObj.findProperty(mandatory) == null) {
                JscsConfigFileAnnotator.createWarningAnnotation(holder, (PsiElement)value, "Required property '" + mandatory + "' should be defined");
            }
            if (descriptor.isMustNotBeEmpty() && jsonObj.getPropertyList().isEmpty()) {
                JscsConfigFileAnnotator.createWarningAnnotation(holder, (PsiElement)value, "At least one of the properties should be defined");
            }
            JscsConfigFileAnnotator.iterateOptions(jsonObj, holder, new OptionChecker<Object>(){

                @Override
                public Object isValidName(String name) {
                    return descriptor.getFields().containsKey(name.trim()) ? Boolean.valueOf(true) : null;
                }

                @Override
                public void processOption(JsonProperty property, Object parsedOption, AnnotationHolder holder) {
                    String trim = property.getName().trim();
                    JscsOptionDescriptor field = descriptor.getFields().get(trim);
                    if (field == null) {
                        return;
                    }
                    if (property.getValue() == null) {
                        return;
                    }
                    ArrayList<ValueType> types = new ArrayList<ValueType>(field.getTypes().keySet());
                    if (field.canBe(ValueType.bool) && JscsOptionsChecker.isBooleanLiteral(types, holder, property.getValue())) {
                        return;
                    }
                    if (field.canBe(ValueType.true_or_false) && JscsOptionsChecker.isTrueOrFalse(types, holder, property.getValue())) {
                        return;
                    }
                    if (JscsOptionsChecker.customValidation(field.getTypes(), types, property.getValue(), holder)) {
                        return;
                    }
                    if (field.canBe(ValueType.num_int) && JscsOptionsChecker.isIntLiteral(types, holder, property.getValue())) {
                        return;
                    }
                    if (field.canBe(ValueType.str) && JscsOptionsChecker.isStringLiteral(field.getTypes(), types, holder, property.getValue())) {
                        return;
                    }
                    if (field.canBe(ValueType.array) && JscsOptionsChecker.isArray(field.getTypes(), holder, property.getValue(), null)) {
                        return;
                    }
                    if (field.canBe(ValueType.obj) && JscsOptionsChecker.isObjectLiteral(field.getTypes(), holder, property.getValue(), trim)) {
                        return;
                    }
                    JscsConfigFileAnnotator.createExpectedTypesAnnotation(types, holder, property.getValue());
                }

                @Override
                public String getOptionClassName() {
                    return parentName;
                }
            });
            return true;
        }

        private static boolean isIntLiteral(List<ValueType> types, AnnotationHolder holder, JsonValue value) {
            JsonNumberLiteral literal = (JsonNumberLiteral)ObjectUtils.tryCast((Object)value, JsonNumberLiteral.class);
            if (literal == null) {
                return false;
            }
            try {
                Integer.parseInt(StringUtil.unquoteString((String)literal.getText()));
            }
            catch (NumberFormatException e) {
                new AnnotationTextBuilder(holder, (PsiElement)value).withTypes(types).build();
            }
            return true;
        }

        private static boolean isTrueOrFalse(List<ValueType> types, AnnotationHolder holder, JsonValue value) {
            JsonBooleanLiteral boolLiteral = (JsonBooleanLiteral)ObjectUtils.tryCast((Object)value, JsonBooleanLiteral.class);
            return boolLiteral != null;
        }

        private static boolean isBooleanLiteral(List<ValueType> types, AnnotationHolder holder, JsonValue value) {
            JsonBooleanLiteral boolLiteral = (JsonBooleanLiteral)ObjectUtils.tryCast((Object)value, JsonBooleanLiteral.class);
            if (boolLiteral == null) {
                return false;
            }
            if (!Boolean.TRUE.toString().equals(boolLiteral.getText())) {
                new AnnotationTextBuilder(holder, (PsiElement)value).withTypes(types).build();
            }
            return true;
        }

        private static boolean isArray(Map<ValueType, JscsOptionDescriptor.ValueDescription> map, AnnotationHolder holder, JsonValue value, @Nullable String replacementMessage) {
            JsonArray array = (JsonArray)ObjectUtils.tryCast((Object)value, JsonArray.class);
            if (array == null) {
                return false;
            }
            JscsOptionsChecker.checkForList(map, array, holder, replacementMessage);
            return true;
        }

        private static void checkForList(Map<ValueType, JscsOptionDescriptor.ValueDescription> map, JsonArray array, AnnotationHolder holder, @Nullable String expectedMessage) {
            JscsOptionDescriptor.ValueDescription descriptor = map.get((Object)ValueType.array);
            if (JscsOptionDescriptor.ValueDescription.NO_VALIDATION.equals(descriptor)) {
                JscsOptionsChecker.validateArray(array, holder, (PairConsumer<PsiElement, JsonStringLiteral>)((PairConsumer)(element, literal) -> {}));
                return;
            }
            if (descriptor instanceof JscsOptionDescriptor.StringVerifier) {
                JscsOptionDescriptor.StringVerifier verifier = (JscsOptionDescriptor.StringVerifier)descriptor;
                JscsOptionsChecker.validateArray(array, holder, (PairConsumer<PsiElement, JsonStringLiteral>)((PairConsumer)(element, literal) -> {
                    String error = verifier.validate(literal.getValue());
                    if (error != null) {
                        JscsConfigFileAnnotator.createWarningAnnotation(holder, element, error);
                    }
                }));
                return;
            }
            if (descriptor instanceof JscsOptionDescriptor.ValuesCollection) {
                JscsOptionDescriptor.ValuesCollection valuesCollection = (JscsOptionDescriptor.ValuesCollection)descriptor;
                String[] values = valuesCollection.getArrValues();
                JscsOptionsChecker.validateArray(array, holder, (PairConsumer<PsiElement, JsonStringLiteral>)((PairConsumer)(element, stringLiteral) -> {
                    if (valuesCollection.isOtherValuesAllowed() || values.length == 0) {
                        return;
                    }
                    if (!valuesCollection.contains(StringUtil.unquoteString((String)stringLiteral.getText()))) {
                        new AnnotationTextBuilder(holder, (PsiElement)element).withOptions(values).withOptionsReplacement(expectedMessage).build();
                    }
                }));
            }
        }

        private static void validateArray(JsonArray array, AnnotationHolder holder, PairConsumer<PsiElement, JsonStringLiteral> consumer) {
            for (PsiElement element : array.getChildren()) {
                JsonStringLiteral stringLiteral = (JsonStringLiteral)ObjectUtils.tryCast((Object)element, JsonStringLiteral.class);
                if (stringLiteral == null) {
                    JscsConfigFileAnnotator.createWarningAnnotation(holder, element, "string expected");
                    continue;
                }
                consumer.consume((Object)element, (Object)stringLiteral);
            }
        }

        private static boolean isStringLiteral(Map<ValueType, JscsOptionDescriptor.ValueDescription> map, List<ValueType> types, AnnotationHolder holder, JsonValue value) {
            JsonStringLiteral stringLiteral = (JsonStringLiteral)ObjectUtils.tryCast((Object)value, JsonStringLiteral.class);
            if (stringLiteral == null) {
                return false;
            }
            JscsOptionDescriptor.ValueDescription descriptor = map.get((Object)ValueType.str);
            if (JscsOptionDescriptor.ValueDescription.NO_VALIDATION.equals(descriptor)) {
                return true;
            }
            String strValue = StringUtil.unquoteString((String)stringLiteral.getValue());
            if (descriptor instanceof JscsOptionDescriptor.StringVerifier) {
                String error = ((JscsOptionDescriptor.StringVerifier)descriptor).validate(strValue);
                if (error != null) {
                    JscsConfigFileAnnotator.createWarningAnnotation(holder, (PsiElement)value, error);
                }
                return true;
            }
            if (descriptor instanceof JscsOptionDescriptor.ValuesCollection) {
                JscsOptionDescriptor.ValuesCollection valuesCollection = (JscsOptionDescriptor.ValuesCollection)descriptor;
                String[] values = valuesCollection.getArrValues();
                if (valuesCollection.isOtherValuesAllowed() || values.length == 0) {
                    return true;
                }
                if (!valuesCollection.contains(strValue)) {
                    ArrayList<ValueType> list = new ArrayList<ValueType>(types);
                    list.remove((Object)ValueType.str);
                    new AnnotationTextBuilder(holder, (PsiElement)value).withOptions(values).withTypes(list).build();
                }
                return true;
            }
            return false;
        }

        static {
            typesCombinations.put(JsonStringLiteral.class, ValueType.str);
            typesCombinations.put(JsonNumberLiteral.class, ValueType.num_int);
            typesCombinations.put(JsonArray.class, ValueType.array);
            typesCombinations.put(JsonObject.class, ValueType.obj);
        }
    }

    private static interface OptionChecker<T> {
        public T isValidName(String var1);

        public void processOption(JsonProperty var1, T var2, AnnotationHolder var3);

        public String getOptionClassName();
    }
}

