/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jscs.config;

import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.javascript.linter.jscs.JscsConfiguration;
import com.intellij.lang.javascript.linter.jscs.JscsState;
import com.intellij.lang.javascript.linter.jscs.config.JscsOption;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.Convertor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JscsConfigHelper {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.javascript.linter.jscs.Jscs");
    public static final String CONFIG_JSCS_JSON = "config.jscs.json";

    public static List<String> getExcludedPaths(@NotNull Project project, @NotNull Document document) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/jscs/config/JscsConfigHelper", "getExcludedPaths"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/lang/javascript/linter/jscs/config/JscsConfigHelper", "getExcludedPaths"));
        }
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (psiFile == null) {
            return null;
        }
        return JscsConfigHelper.getExcludedPaths(psiFile);
    }

    public static List<String> getExcludedPaths(PsiFile psiFile) {
        PsiElement child = psiFile.getFirstChild();
        JsonValue excludeValue = (JsonValue)ObjectUtils.doIfCast((Object)child, JsonObject.class, (Convertor)new Convertor<JsonObject, JsonValue>(){

            public JsonValue convert(JsonObject jsonObject) {
                List list = jsonObject.getPropertyList();
                for (JsonProperty property : list) {
                    if (!JscsOption.excludeFiles.name().equals(property.getName())) continue;
                    return property.getValue();
                }
                return null;
            }
        });
        if (excludeValue == null) {
            return null;
        }
        return (List)ObjectUtils.doIfCast((Object)excludeValue, JsonArray.class, (Convertor)new Convertor<JsonArray, List<String>>(){

            public List<String> convert(JsonArray array) {
                ArrayList<String> result = new ArrayList<String>();
                List valueList = array.getValueList();
                for (JsonValue jsonValue : valueList) {
                    String path = (String)ObjectUtils.doIfCast((Object)jsonValue, JsonStringLiteral.class, (Convertor)new Convertor<JsonStringLiteral, String>(){

                        public String convert(final JsonStringLiteral str) {
                            return (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

                                public String compute() {
                                    return StringUtil.stripQuotesAroundValue((String)str.getText());
                                }
                            });
                        }
                    });
                    if (path == null) continue;
                    result.add(path);
                }
                return result.isEmpty() ? null : result;
            }
        });
    }

    @Nullable
    public static VirtualFile createConfigBasedOnPreset(@NotNull Project project) {
        File preset;
        VirtualFile vfPreset;
        File presetsDir;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/jscs/config/JscsConfigHelper", "createConfigBasedOnPreset"));
        }
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        VirtualFile dir = project.getBaseDir();
        File configFile = new File(FileUtil.toSystemDependentName((String)dir.getPath()), CONFIG_JSCS_JSON);
        if (configFile.exists()) {
            return lfs.refreshAndFindFileByIoFile(configFile);
        }
        JscsState jscsState = (JscsState)JscsConfiguration.getInstance(project).getExtendedState().getState();
        if (jscsState.getPreset() != null && !StringUtil.isEmptyOrSpaces((String)jscsState.getPackagePath()) && (presetsDir = new File(jscsState.getPackagePath(), "/presets")).exists() && (vfPreset = lfs.refreshAndFindFileByIoFile(preset = new File(presetsDir, jscsState.getPreset().getCode() + ".json"))) != null && !vfPreset.isDirectory()) {
            try {
                return VfsUtil.copyFile(JscsConfigHelper.class, (VirtualFile)vfPreset, (VirtualFile)project.getBaseDir(), (String)CONFIG_JSCS_JSON);
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
        }
        try {
            VirtualFile file = project.getBaseDir().createChildData(JscsConfigHelper.class, CONFIG_JSCS_JSON);
            file.setBinaryContent("{\n}\n".getBytes(CharsetToolkit.UTF8_CHARSET));
            return file;
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            return null;
        }
    }
}

