/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jshint.version;

import com.google.common.collect.ImmutableList;
import com.intellij.lang.javascript.linter.jshint.JSHintUtil;
import com.intellij.lang.javascript.linter.jshint.version.JSHintVersionDescriptor;
import com.intellij.lang.javascript.linter.jshint.version.JSHintVersionUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Ref;
import com.intellij.ui.JBColor;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ui.SwingHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSHintVersionView
implements Disposable {
    private static final Logger LOG = Logger.getInstance(JSHintVersionView.class);
    private final Project myProject;
    private final Color myDefaultComboboxForegroundColor;
    private final LabeledComponent<JComboBox> myComponent;
    private boolean myUpdatingVersionDescriptors;
    private String myPreservedVersion;
    @Nullable
    private Balloon myActiveErrorBalloon;

    public JSHintVersionView(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/jshint/version/JSHintVersionView", "<init>"));
        }
        this.myUpdatingVersionDescriptors = false;
        this.myProject = project;
        final JComboBox comboBox = JSHintVersionView.createComboBox();
        this.myDefaultComboboxForegroundColor = comboBox.getForeground();
        this.myComponent = LabeledComponent.create((JComponent)comboBox, (String)"&Version:");
        this.myComponent.setLabelLocation("West");
        comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!JSHintVersionView.this.myUpdatingVersionDescriptors) {
                    JSHintVersionView.this.checkSelectedVersion();
                }
            }
        });
        comboBox.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (JSHintVersionView.this.myPreservedVersion != null) {
                    JSHintVersionView.asyncDownloadVersions(() -> JSHintVersionView.this.fillVersions(JSHintVersionView.this.myPreservedVersion), null);
                }
                comboBox.removeFocusListener(this);
            }
        });
    }

    private void checkSelectedVersion() {
        ApplicationManager.getApplication().invokeLater(() -> {
            this.hideActiveErrorBalloon();
            JSHintVersionDescriptor selected = this.getSelectedVersionDescriptor();
            boolean sourceLocallyAvailable = this.obtainSource(selected);
            if (!sourceLocallyAvailable) {
                LOG.info("Can't obtain source of JSHint " + selected.getVersion());
            }
            JComboBox comboBox = (JComboBox)this.myComponent.getComponent();
            comboBox.setForeground(sourceLocallyAvailable ? this.myDefaultComboboxForegroundColor : JBColor.RED);
        });
    }

    private boolean obtainSource(@NotNull JSHintVersionDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/lang/javascript/linter/jshint/version/JSHintVersionView", "obtainSource"));
        }
        if (JSHintVersionUtil.isSourceLocallyAvailable(descriptor.getVersion())) {
            return true;
        }
        Ref innerExceptionRef = Ref.create(null);
        boolean completed = ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/lang/javascript/linter/jshint/version/JSHintVersionView", "lambda$obtainSource$1"));
            }
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            indicator.setText("Downloading " + JSHintVersionUtil.getJSHintSourceFileBaseName(descriptor.getVersion()));
            try {
                JSHintVersionUtil.downloadSourceVersionOnce(indicator, descriptor);
            }
            catch (Exception ex) {
                innerExceptionRef.set((Object)ex);
            }
        }, "JSHint " + descriptor.getVersion(), true, this.myProject);
        if (completed && innerExceptionRef.isNull()) {
            return true;
        }
        Runnable retryAction = () -> {
            this.hideActiveErrorBalloon();
            this.checkSelectedVersion();
        };
        String title = "<b>JSHint " + descriptor.getVersion() + " is not available</b>";
        JComponent errorMessageBalloonContent = completed ? JSHintUtil.createIOExceptionBalloonComponent(title + "<br/>Can not download " + descriptor.getUrl(), retryAction, true) : JSHintUtil.createIOExceptionBalloonComponent(title + "<br/>" + descriptor.getUrl() + " download was cancelled", retryAction, false);
        Balloon balloon = JBPopupFactory.getInstance().createBalloonBuilder(errorMessageBalloonContent).setDialogMode(true).setCloseButtonEnabled(true).setDisposable((Disposable)this).setFillColor(MessageType.ERROR.getPopupBackground()).setContentInsets(new Insets(10, 10, 10, 10)).createBalloon();
        this.hideActiveErrorBalloon();
        balloon.show(this.findRelativePoint(), Balloon.Position.below);
        this.myActiveErrorBalloon = balloon;
        return false;
    }

    private RelativePoint findRelativePoint() {
        JComboBox comboBox = (JComboBox)this.myComponent.getComponent();
        return new RelativePoint((Component)comboBox, new Point(comboBox.getWidth() / 2, (int)((double)comboBox.getHeight() / 1.2)));
    }

    private void hideActiveErrorBalloon() {
        if (this.myActiveErrorBalloon != null) {
            this.myActiveErrorBalloon.hide();
            this.myActiveErrorBalloon = null;
        }
    }

    @NotNull
    public JSHintVersionDescriptor getSelectedVersionDescriptor() {
        JComboBox comboBox = (JComboBox)this.myComponent.getComponent();
        JSHintVersionDescriptor jSHintVersionDescriptor = (JSHintVersionDescriptor)comboBox.getSelectedItem();
        if (jSHintVersionDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/version/JSHintVersionView", "getSelectedVersionDescriptor"));
        }
        return jSHintVersionDescriptor;
    }

    @NotNull
    private static JComboBox createComboBox() {
        ComboBox comboBox = new ComboBox();
        comboBox.setRenderer((ListCellRenderer)new ListCellRendererWrapper<JSHintVersionDescriptor>(){

            public void customize(JList list, JSHintVersionDescriptor value, int index, boolean selected, boolean hasFocus) {
                String text = "no version";
                if (value != null) {
                    text = value.getVersion();
                    if (value.isBundled()) {
                        text = text + " (bundled)";
                    }
                }
                this.setText(text);
            }
        });
        ComboBox comboBox2 = comboBox;
        if (comboBox2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/version/JSHintVersionView", "createComboBox"));
        }
        return comboBox2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillVersions(@Nullable String selectedVersion) {
        this.myUpdatingVersionDescriptors = true;
        try {
            ImmutableList<JSHintVersionDescriptor> descriptors;
            ImmutableList<JSHintVersionDescriptor> fixedDescriptors = descriptors = JSHintVersionUtil.getVersions();
            JSHintVersionDescriptor selectedDescriptor = null;
            if (selectedVersion != null) {
                fixedDescriptors = JSHintVersionUtil.addGuessableVersionDescriptorFirstIfMissing(descriptors, selectedVersion);
                selectedDescriptor = JSHintVersionUtil.find(fixedDescriptors, selectedVersion);
            }
            JComboBox comboBox = (JComboBox)this.myComponent.getComponent();
            SwingHelper.updateItems((JComboBox)comboBox, fixedDescriptors, (Object)selectedDescriptor);
        }
        finally {
            this.myUpdatingVersionDescriptors = false;
        }
    }

    @NotNull
    public Component getComponent() {
        LabeledComponent<JComboBox> labeledComponent = this.myComponent;
        if (labeledComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/version/JSHintVersionView", "getComponent"));
        }
        return labeledComponent;
    }

    public void setVersion(@NotNull String version) {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/lang/javascript/linter/jshint/version/JSHintVersionView", "setVersion"));
        }
        this.myPreservedVersion = version;
        this.fillVersions(version);
        ImmutableList<JSHintVersionDescriptor> descriptors = JSHintVersionUtil.getVersions();
        if (JSHintVersionUtil.find(descriptors, version) != null) {
            this.checkSelectedVersion();
        } else {
            JSHintVersionView.asyncDownloadVersions(() -> {
                if (version == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/lang/javascript/linter/jshint/version/JSHintVersionView", "lambda$setVersion$3"));
                }
                this.fillVersions(version);
                this.checkSelectedVersion();
            }, () -> this.checkSelectedVersion());
        }
    }

    private static void asyncDownloadVersions(@Nullable Runnable onSuccess, @Nullable Runnable onFailure) {
        ModalityState modalityState = ModalityState.any();
        Application application = ApplicationManager.getApplication();
        application.executeOnPooledThread(() -> {
            block3: {
                try {
                    JSHintVersionUtil.downloadVersions(null);
                    if (onSuccess != null) {
                        application.invokeLater(onSuccess, modalityState);
                    }
                }
                catch (Exception e) {
                    LOG.warn("Can't update jshint version list", (Throwable)e);
                    if (onFailure == null) break block3;
                    application.invokeLater(onFailure, modalityState);
                }
            }
        });
    }

    @NotNull
    public String getVersion() {
        JSHintVersionDescriptor selected = this.getSelectedVersionDescriptor();
        String string = selected.getVersion();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/version/JSHintVersionView", "getVersion"));
        }
        return string;
    }

    public void dispose() {
    }
}

