/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules.diagramm;

import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramProvider;
import com.intellij.lang.Language;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.frameworks.amd.JSAmdUtil;
import com.intellij.lang.javascript.intentions.ES6CoolRefactoring;
import com.intellij.lang.javascript.library.JSLibReferenceResolver;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.linter.JSLinterUtil;
import com.intellij.lang.javascript.modules.diagramm.ES6ModuleDataNode;
import com.intellij.lang.javascript.modules.diagramm.ImportedData;
import com.intellij.lang.javascript.modules.diagramm.JSModuleConnectionProvider;
import com.intellij.lang.javascript.modules.diagramm.JSModulesDiagramProvider;
import com.intellij.lang.javascript.modules.diagramm.JSModulesDiagramUtils;
import com.intellij.lang.javascript.modules.diagramm.JSStructuralDiagramItem;
import com.intellij.lang.javascript.modules.diagramm.JSStructuralUiEdge;
import com.intellij.lang.javascript.modules.diagramm.JSStructuralUiNode;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.css.CssFileType;
import com.intellij.psi.impl.include.FileIncludeManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.xml.util.HtmlUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSModuleDependencyData {
    @NotNull
    private final Project myProject;
    @NotNull
    private final GlobalSearchScope myScope;
    @NotNull
    private final Map<VirtualFile, ES6ModuleDataNode> myNodes;
    @NotNull
    private final Map<String, ES6ModuleDataNode> myNotResolvedNodes;
    @NotNull
    private final SmartPointerManager mySpm;

    public JSModuleDependencyData(@NotNull Project project, @NotNull GlobalSearchScope scope) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/modules/diagramm/JSModuleDependencyData", "<init>"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/javascript/modules/diagramm/JSModuleDependencyData", "<init>"));
        }
        this.myProject = project;
        this.myScope = scope;
        this.mySpm = SmartPointerManager.getInstance((Project)this.myProject);
        this.myNodes = new HashMap<VirtualFile, ES6ModuleDataNode>();
        this.myNotResolvedNodes = new HashMap<String, ES6ModuleDataNode>();
    }

    public void calculate() {
        JSModuleConnectionProvider[] extensions = (JSModuleConnectionProvider[])Extensions.getExtensions(JSModuleConnectionProvider.EXTENSION_POINT_NAME);
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        DumbService.getInstance((Project)this.myProject).runReadActionInSmartMode(() -> {
            FileBasedIndex.getInstance().iterateIndexableFiles(fileOrDir -> {
                if (this.myScope.contains(fileOrDir) && !fileOrDir.isDirectory()) {
                    PsiFile psiFile = psiManager.findFile(fileOrDir);
                    if (psiFile == null) {
                        return true;
                    }
                    JSModuleDependencyData.setProgressText(psiFile);
                    if (fileOrDir.getFileType() instanceof LanguageFileType && ((LanguageFileType)fileOrDir.getFileType()).getLanguage().isKindOf((Language)JavascriptLanguage.INSTANCE)) {
                        this.jsDetection((PsiElement)psiFile);
                    } else if (fileOrDir.getFileType() instanceof LanguageFileType && JSLinterUtil.isPureHtmlFile(psiFile) || JSLinterUtil.isVueFile(psiFile)) {
                        Collection embeddedContents = PsiTreeUtil.findChildrenOfType((PsiElement)psiFile, JSEmbeddedContent.class);
                        if (!embeddedContents.isEmpty()) {
                            for (JSEmbeddedContent content : embeddedContents) {
                                this.jsDetection((PsiElement)content);
                            }
                        }
                        this.includedFilesDetection(psiFile);
                    } else if (CssFileType.INSTANCE.equals(fileOrDir.getFileType())) {
                        this.includedFilesDetection(psiFile);
                    }
                    for (JSModuleConnectionProvider extension : extensions) {
                        List<JSModuleConnectionProvider.Link> dependencies = extension.getDependencies(psiFile);
                        if (dependencies == null) continue;
                        for (JSModuleConnectionProvider.Link dependency : dependencies) {
                            ES6ModuleDataNode node = this.getNode((PsiElement)psiFile);
                            ES6ModuleDataNode target = this.getNode(dependency.getTarget().getElement());
                            ImportedData importedData = new ImportedData(dependency.getSourceName(), dependency.getTargetName(), dependency.getTarget(), target);
                            importedData.setProvider(extension);
                            importedData.setIcon(dependency.getIcon());
                            node.dependsOn(dependency.getSource(), importedData);
                        }
                    }
                }
                return true;
            }, this.myProject, ProgressManager.getInstance().getProgressIndicator());
            for (Map.Entry<VirtualFile, ES6ModuleDataNode> entry : this.myNodes.entrySet()) {
                if (!this.myScope.contains(entry.getKey())) continue;
                entry.getValue().inScope();
            }
        });
    }

    private static void setProgressText(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/lang/javascript/modules/diagramm/JSModuleDependencyData", "setProgressText"));
        }
        ProgressIndicator pi = ProgressManager.getInstance().getProgressIndicator();
        if (pi != null) {
            pi.setText("Processing " + psiFile.getName() + (psiFile.getParent() == null ? "" : " (" + psiFile.getParent().getVirtualFile().getPath() + ")"));
        }
    }

    private void includedFilesDetection(PsiFile file) {
        if (file instanceof XmlFile) {
            this.processHtmlIncludes((XmlFile)file);
            return;
        }
        VirtualFile[] files = FileIncludeManager.getManager((Project)file.getProject()).getIncludedFiles(file.getVirtualFile(), true);
        ArrayList<VirtualFile> filesList = new ArrayList<VirtualFile>(Arrays.asList(files));
        for (VirtualFile virtualFile : filesList) {
            PsiFile dependencyFile = file.getManager().findFile(virtualFile);
            if (dependencyFile == null) continue;
            ES6ModuleDataNode node = this.getNode((PsiElement)file);
            ES6ModuleDataNode target = this.getNode((PsiElement)dependencyFile);
            this.fileInclusion(file, dependencyFile, node, target);
        }
    }

    private void fileInclusion(@NotNull PsiFile file, @Nullable PsiFile dependencyFile, @NotNull ES6ModuleDataNode node, @NotNull ES6ModuleDataNode target) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/modules/diagramm/JSModuleDependencyData", "fileInclusion"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/modules/diagramm/JSModuleDependencyData", "fileInclusion"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/lang/javascript/modules/diagramm/JSModuleDependencyData", "fileInclusion"));
        }
        String name = dependencyFile == null ? target.getName() : dependencyFile.getName();
        ImportedData importedData = new ImportedData(name, name, dependencyFile == null ? null : this.mySpm.createSmartPsiElementPointer((PsiElement)dependencyFile), target).setLogicalImport(false);
        node.dependsOn((SmartPsiElementPointer<PsiElement>)this.mySpm.createSmartPsiElementPointer((PsiElement)file), importedData);
    }

    private void processHtmlIncludes(@NotNull XmlFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/lang/javascript/modules/diagramm/JSModuleDependencyData", "processHtmlIncludes"));
        }
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        HtmlUtil.getIncludedPathsElements((XmlFile)psiFile).stream().filter(el -> el != null && !StringUtil.isEmptyOrSpaces((String)el.getValue())).forEach(el -> {
            PsiFile targetFile;
            if (psiFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/lang/javascript/modules/diagramm/JSModuleDependencyData", "lambda$processHtmlIncludes$3"));
            }
            String path = el.getValue();
            VirtualFile virtualFile = lfs.findFileByPath(path);
            if (virtualFile == null) {
                File relativeFoundFile = new File(new File(psiFile.getVirtualFile().getParent().getPath()), path);
                virtualFile = lfs.findFileByIoFile(relativeFoundFile);
            }
            ES6ModuleDataNode node = this.getNode((PsiElement)psiFile);
            PsiFile psiFile2 = targetFile = virtualFile != null ? psiFile.getManager().findFile(virtualFile) : null;
            if (targetFile != null) {
                ES6ModuleDataNode target = this.getNode((PsiElement)targetFile);
                this.fileInclusion((PsiFile)psiFile, targetFile, node, target);
            } else {
                PsiElement resolve;
                PsiReference libReference = JSLibReferenceResolver.getLibReference(el);
                if (libReference != null && (resolve = libReference.resolve()) != null && resolve.isValid()) {
                    ES6ModuleDataNode target = this.getNode(resolve);
                    target.setName(path);
                    ImportedData importedData = new ImportedData(path, path, (SmartPsiElementPointer<PsiElement>)this.mySpm.createSmartPsiElementPointer(resolve), target).setLogicalImport(false);
                    node.dependsOn((SmartPsiElementPointer<PsiElement>)this.mySpm.createSmartPsiElementPointer((PsiElement)psiFile), importedData);
                    return;
                }
                this.fileInclusion((PsiFile)psiFile, null, node, this.getFictiveNode(path));
            }
        });
    }

    private void jsDetection(PsiElement context) {
        if (ES6CoolRefactoring.isEs6Compatible(context)) {
            this.es6Detection(context);
        }
        this.requireAndDefineArgumentDetection(context);
    }

    @Nullable
    private static PsiFile findRequireFile(PsiReference requireReference) {
        if (requireReference == null) {
            return null;
        }
        PsiElement requireResolve = requireReference.resolve();
        if (!(requireResolve instanceof PsiFile) || !requireResolve.isValid()) {
            return null;
        }
        return (PsiFile)requireResolve;
    }

    private void requireAndDefineArgumentDetection(PsiElement context) {
        Collection expressions = PsiTreeUtil.findChildrenOfType((PsiElement)context, JSCallExpression.class);
        for (JSCallExpression expression : expressions) {
            if (expression.isRequireCall()) {
                this.processRequireCall(context, expression);
                continue;
            }
            if (!expression.isDefineCall()) continue;
            this.processAmdCall(context, expression);
        }
    }

    private void processAmdCall(PsiElement context, JSCallExpression expression) {
        JSAmdUtil.AmdLoaderCallParametersChecker checker = new JSAmdUtil.AmdLoaderCallParametersChecker(expression.getArguments());
        if (!checker.isCorrect()) {
            return;
        }
        JSArrayLiteralExpression array = checker.getArray();
        if (array != null) {
            for (JSExpression ref : array.getExpressions()) {
                String amdFileName;
                ES6ModuleDataNode amdTarget;
                PsiReference reference = JSModuleDependencyData.findReference(context, ref);
                if (reference == null) continue;
                PsiElement amdResolve = reference.resolve();
                ES6ModuleDataNode node = this.getNode(context);
                if (!(amdResolve instanceof PsiFile) || !amdResolve.isValid()) {
                    String text = StringUtil.unquoteString((String)reference.getCanonicalText());
                    amdTarget = this.getFictiveNode(text);
                    amdFileName = text;
                } else {
                    amdTarget = this.getNode(amdResolve);
                    amdFileName = ((PsiFile)amdResolve).getName();
                }
                ImportedData importedData = new ImportedData(amdFileName, amdFileName, amdResolve == null ? null : this.mySpm.createSmartPsiElementPointer(amdResolve), amdTarget);
                node.dependsOn((SmartPsiElementPointer<PsiElement>)this.mySpm.createSmartPsiElementPointer(context), importedData);
            }
        }
    }

    private void processRequireCall(PsiElement context, JSCallExpression expression) {
        String sourceName;
        String targetFileName;
        ES6ModuleDataNode target;
        PsiReference requireReference = JSModuleDependencyData.getRequireReference(context, expression);
        if (requireReference == null) {
            return;
        }
        ES6ModuleDataNode node = this.getNode(context);
        PsiFile requirePsiFile = JSModuleDependencyData.findRequireFile(requireReference);
        if (requirePsiFile == null) {
            String text = StringUtil.unquoteString((String)requireReference.getCanonicalText());
            target = this.getFictiveNode(text);
            targetFileName = text;
        } else {
            target = this.getNode((PsiElement)requirePsiFile);
            targetFileName = requirePsiFile.getName();
        }
        JSVariable variable = (JSVariable)PsiTreeUtil.getParentOfType((PsiElement)expression, JSVariable.class);
        String string = sourceName = variable != null ? variable.getName() : null;
        if (expression.getParent() instanceof JSReferenceExpression) {
            PsiElement resolve;
            JSReferenceExpression current;
            ArrayList<String> tail = new ArrayList<String>();
            for (current = (JSReferenceExpression)expression.getParent(); current != null; current = (JSReferenceExpression)current.getParent()) {
                tail.add(current.getReferenceName());
                if (!(current.getParent() instanceof JSReferenceExpression)) break;
            }
            if ((resolve = current.resolve()) == null) {
                resolve = JSModuleDependencyData.multiResolve(requirePsiFile, current);
            }
            String name = StringUtil.join(tail, (String)".");
            ImportedData importedData = new ImportedData(sourceName == null ? name : sourceName, name, resolve == null ? null : this.mySpm.createSmartPsiElementPointer(resolve), target);
            node.dependsOn((SmartPsiElementPointer<PsiElement>)this.mySpm.createSmartPsiElementPointer((PsiElement)current), importedData);
        } else {
            ImportedData importedData = new ImportedData(sourceName == null ? targetFileName : sourceName, targetFileName, requirePsiFile == null ? null : this.mySpm.createSmartPsiElementPointer((PsiElement)requirePsiFile), target);
            node.dependsOn((SmartPsiElementPointer<PsiElement>)this.mySpm.createSmartPsiElementPointer((PsiElement)(variable != null ? variable : expression)), importedData);
        }
    }

    private static PsiElement multiResolve(@Nullable PsiFile requireResolve, @NotNull JSReferenceExpression current) {
        ResolveResult[] results;
        if (current == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/lang/javascript/modules/diagramm/JSModuleDependencyData", "multiResolve"));
        }
        for (ResolveResult result : results = current.multiResolve(false)) {
            if (!result.isValidResult() || result.getElement() == null || !result.getElement().getContainingFile().equals(requireResolve)) continue;
            return result.getElement();
        }
        if (requireResolve != null) {
            VirtualFile folder = JSLibraryUtil.getLibraryFolder(requireResolve.getVirtualFile());
            if (folder == null) {
                return null;
            }
            for (ResolveResult result : results) {
                if (!result.isValidResult() || result.getElement() == null || !VfsUtilCore.isAncestor((VirtualFile)folder, (VirtualFile)result.getElement().getContainingFile().getVirtualFile(), (boolean)false)) continue;
                return result.getElement();
            }
        }
        return null;
    }

    private static PsiReference getRequireReference(@NotNull PsiElement context, @NotNull JSCallExpression expression) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/modules/diagramm/JSModuleDependencyData", "getRequireReference"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/modules/diagramm/JSModuleDependencyData", "getRequireReference"));
        }
        JSExpression[] arguments = expression.getArguments();
        if (arguments.length == 1) {
            JSExpression argument = arguments[0];
            return JSModuleDependencyData.findReference(context, argument);
        }
        return null;
    }

    private static PsiReference findReference(PsiElement context, JSExpression argument) {
        int offset = argument.getTextRange().isEmpty() ? argument.getTextRange().getStartOffset() : argument.getTextRange().getEndOffset() - 1;
        return context.findReferenceAt(offset);
    }

    private void es6Detection(PsiElement context) {
        Collection declarations = PsiTreeUtil.findChildrenOfType((PsiElement)context, ES6ImportDeclaration.class);
        for (ES6ImportDeclaration declaration : declarations) {
            ES6ImportSpecifier[] specifiers;
            PsiElement fromReference;
            ES6ModuleDataNode node;
            ES6FromClause fromClause = declaration.getFromClause();
            if (fromClause == null) {
                PsiReference[] references;
                boolean registered = false;
                for (PsiReference reference : references = declaration.getReferences()) {
                    PsiElement resolve = reference.resolve();
                    if (resolve == null || !resolve.isValid() || !(resolve instanceof PsiFile)) continue;
                    PsiFile targetFile = (PsiFile)resolve;
                    ES6ModuleDataNode eS6ModuleDataNode = this.getNode((PsiElement)targetFile);
                    node = this.getNode(context);
                    node.dependsOn((SmartPsiElementPointer<PsiElement>)this.mySpm.createSmartPsiElementPointer((PsiElement)declaration), new ImportedData(targetFile.getName(), targetFile.getName(), (SmartPsiElementPointer<PsiElement>)this.mySpm.createSmartPsiElementPointer(resolve), eS6ModuleDataNode));
                    registered = true;
                    break;
                }
                if (registered || declaration.getReference() == null) continue;
                String text = StringUtil.unquoteString((String)declaration.getReference().getCanonicalText());
                this.getNode(context).dependsOn((SmartPsiElementPointer<PsiElement>)this.mySpm.createSmartPsiElementPointer((PsiElement)declaration), new ImportedData(text, text, null, this.getFictiveNode(text)));
                continue;
            }
            Collection items = fromClause.resolveReferencedElements();
            PsiElement psiElement = fromReference = items.size() == 1 ? (PsiElement)ContainerUtil.getFirstItem((Collection)items) : null;
            PsiFile fromFile = fromReference == null ? null : (fromReference instanceof PsiFile ? (PsiFile)fromReference : fromReference.getContainingFile());
            ES6ImportedBinding[] bindings = declaration.getImportedBindings();
            for (ES6ImportSpecifier eS6ImportSpecifier : specifiers = declaration.getImportSpecifiers()) {
                String name;
                if (!(eS6ImportSpecifier.getReference() instanceof PsiElement)) continue;
                PsiElement resolve = eS6ImportSpecifier.getReference().resolve();
                boolean resolveInvalid = !(resolve instanceof JSNamedElement) || !resolve.isValid();
                ES6ModuleDataNode node2 = this.getNode(context);
                ES6ModuleDataNode target = resolveInvalid && fromFile == null ? this.getFictiveNode(fromClause.getReferenceText()) : this.getNode((PsiElement)(resolve != null ? resolve.getContainingFile() : fromFile));
                String string = name = eS6ImportSpecifier.getAlias() != null ? eS6ImportSpecifier.getAlias().getName() : eS6ImportSpecifier.getReferenceName();
                assert (name != null);
                String targetName = resolveInvalid ? StringUtil.unquoteString((String)StringUtil.notNullize((String)eS6ImportSpecifier.getReferenceName())) : StringUtil.notNullize((String)((JSNamedElement)resolve).getName());
                node2.dependsOn((SmartPsiElementPointer<PsiElement>)this.mySpm.createSmartPsiElementPointer((PsiElement)eS6ImportSpecifier), new ImportedData(name, targetName, resolveInvalid ? null : this.mySpm.createSmartPsiElementPointer(resolve), target));
            }
            for (ES6ImportSpecifier eS6ImportSpecifier : bindings) {
                if (eS6ImportSpecifier.getName() == null) continue;
                node = this.getNode(context);
                Collection referencedElements = eS6ImportSpecifier.findReferencedElements();
                if (!referencedElements.isEmpty()) {
                    for (PsiElement element : referencedElements) {
                        PsiFile file;
                        PsiFile psiFile = file = element instanceof PsiFile ? (PsiFile)element : element.getContainingFile();
                        if (file == null) continue;
                        ES6ModuleDataNode target = this.getNode((PsiElement)file);
                        node.dependsOn((SmartPsiElementPointer<PsiElement>)this.mySpm.createSmartPsiElementPointer((PsiElement)eS6ImportSpecifier), new ImportedData(eS6ImportSpecifier.getName(), file.getName(), null, target));
                    }
                    continue;
                }
                ES6ModuleDataNode target = fromFile == null ? this.getFictiveNode(fromClause.getReferenceText()) : this.getNode((PsiElement)fromFile);
                node.dependsOn((SmartPsiElementPointer<PsiElement>)this.mySpm.createSmartPsiElementPointer((PsiElement)eS6ImportSpecifier), new ImportedData(eS6ImportSpecifier.getName(), target.getName(), null, target));
            }
        }
    }

    public Pair<List<JSStructuralUiNode>, List<JSStructuralUiEdge>> getNodesAndEdges(@NotNull JSModulesDiagramProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/lang/javascript/modules/diagramm/JSModuleDependencyData", "getNodesAndEdges"));
        }
        if (this.myNodes.isEmpty() && this.myNotResolvedNodes.isEmpty()) {
            return Pair.create(Collections.emptyList(), Collections.emptyList());
        }
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>(this.myNodes.keySet());
        Collections.sort(files, Comparator.comparing(VirtualFile::getName));
        SmartPointerManager spm = SmartPointerManager.getInstance((Project)this.myProject);
        HashMap<PsiFile, JSStructuralUiNode> createdNodes = new HashMap<PsiFile, JSStructuralUiNode>();
        ArrayList<JSStructuralUiNode> nodes = new ArrayList<JSStructuralUiNode>();
        HashMap<JSStructuralUiEdge, JSStructuralUiEdge> edges = new HashMap<JSStructuralUiEdge, JSStructuralUiEdge>();
        for (VirtualFile file : files) {
            ES6ModuleDataNode node = this.myNodes.get(file);
            assert (node.getFilePointer() != null);
            PsiFile psiFile = node.getFilePointer().getContainingFile();
            if (psiFile == null) continue;
            String name = JSModulesDiagramUtils.startsWithHttpProtocol(node.getName()) ? node.getName() : JSModulesDiagramUtils.getFileNamePart(psiFile);
            JSStructuralDiagramItem item = new JSStructuralDiagramItem((SmartPsiElementPointer<PsiElement>)spm.createSmartPsiElementPointer((PsiElement)psiFile), name, true).setInScope(node.isInScope());
            JSStructuralUiNode uiNode = new JSStructuralUiNode(item, (DiagramProvider<JSStructuralDiagramItem>)provider);
            nodes.add(uiNode);
            createdNodes.put(psiFile, uiNode);
        }
        ArrayList<String> notResolved = new ArrayList<String>(this.myNotResolvedNodes.keySet());
        Collections.sort(notResolved, Comparator.comparing(String::toString));
        HashMap<String, JSStructuralUiNode> createdNotResolvedNodes = new HashMap<String, JSStructuralUiNode>();
        for (String name : notResolved) {
            JSStructuralDiagramItem item = new JSStructuralDiagramItem(null, name, true);
            JSStructuralUiNode uiNode = new JSStructuralUiNode(item, (DiagramProvider<JSStructuralDiagramItem>)provider);
            nodes.add(uiNode);
            createdNotResolvedNodes.put(name, uiNode);
        }
        for (VirtualFile file : files) {
            ES6ModuleDataNode node = this.myNodes.get(file);
            assert (node.getFilePointer() != null);
            PsiFile psiFile = node.getFilePointer().getContainingFile();
            if (psiFile == null) continue;
            for (Map.Entry entry : node.getDependsMap().entrySet()) {
                PsiFile sourceFile = ((SmartPsiElementPointer)entry.getKey()).getContainingFile();
                JSStructuralUiNode source = (JSStructuralUiNode)((Object)createdNodes.get(sourceFile));
                if (source == null) continue;
                for (ImportedData importedData : (Collection)entry.getValue()) {
                    PsiElement element;
                    JSStructuralUiNode target;
                    ES6ModuleDataNode targetNode = importedData.getTargetNode();
                    JSStructuralUiNode jSStructuralUiNode = target = targetNode.getFilePointer() != null ? (JSStructuralUiNode)((Object)createdNodes.get(targetNode.getFilePointer().getContainingFile())) : (JSStructuralUiNode)((Object)createdNotResolvedNodes.get(targetNode.getName()));
                    if (target == null) continue;
                    JSStructuralUiEdge edge = new JSStructuralUiEdge((DiagramNode<JSStructuralDiagramItem>)source, (DiagramNode<JSStructuralDiagramItem>)target);
                    Icon icon = null;
                    if (importedData.getProvider() != null) {
                        edge.setProviderName(importedData.getProvider().getName());
                        edge.setColor(importedData.getProvider().getEdgeColor());
                        icon = importedData.getIcon();
                    }
                    if (edges.containsKey((Object)edge)) {
                        edge = (JSStructuralUiEdge)((Object)edges.get((Object)edge));
                    } else {
                        edges.put(edge, edge);
                    }
                    PsiElement psiElement = element = importedData.getTargetMemberPointer() == null ? null : importedData.getTargetMemberPointer().getElement();
                    if (element == null && !importedData.getTargetNode().getName().equals(importedData.getTargetName()) || element != null && element.isValid() && (targetNode.getFilePointer() == null || !Comparing.equal((Object)element, (Object)targetNode.getFilePointer().getElement()))) {
                        JSStructuralDiagramItem targetDetail = new JSStructuralDiagramItem(importedData.getTargetMemberPointer(), importedData.getTargetName(), false);
                        if (icon != null) {
                            targetDetail.setIcon(icon);
                        }
                        target.getIdentifyingElement().addImportedOrExported(targetDetail, true);
                    }
                    edge.links(importedData.getSourceName(), importedData.getTargetName());
                    if (sourceFile == null || !importedData.isLogicalImport()) continue;
                    JSStructuralDiagramItem sourceDetail = new JSStructuralDiagramItem((SmartPsiElementPointer<PsiElement>)((SmartPsiElementPointer)entry.getKey()), importedData.getSourceName(), false);
                    if (icon != null) {
                        sourceDetail.setIcon(icon);
                    }
                    source.getIdentifyingElement().addImportedOrExported(sourceDetail, false);
                }
            }
            for (JSStructuralUiNode uiNode : nodes) {
                uiNode.getIdentifyingElement().sortExported();
            }
        }
        return Pair.create(nodes, new ArrayList(edges.values()));
    }

    private ES6ModuleDataNode getNode(PsiElement context) {
        PsiFile psiFile = context.getContainingFile();
        ES6ModuleDataNode node = this.myNodes.get(psiFile.getVirtualFile());
        if (node == null) {
            node = new ES6ModuleDataNode((SmartPsiElementPointer<PsiFile>)this.mySpm.createSmartPsiElementPointer((PsiElement)psiFile));
            this.myNodes.put(psiFile.getVirtualFile(), node);
        }
        return node;
    }

    private ES6ModuleDataNode getFictiveNode(String fromText) {
        String key = StringUtil.unquoteString((String)StringUtil.notNullize((String)fromText).trim());
        ES6ModuleDataNode node = this.myNotResolvedNodes.get(key);
        if (node == null) {
            node = new ES6ModuleDataNode(key);
            this.myNotResolvedNodes.put(key, node);
        }
        return node;
    }
}

