/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.psi.JSDestructuringArray;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.impl.JSArrayLiteralExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSDestructuringArrayStubImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveState;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class JSDestructuringArrayImpl
extends JSStubElementImpl<JSDestructuringArrayStubImpl>
implements JSDestructuringArray,
StubBasedPsiElement<JSDestructuringArrayStubImpl> {
    public JSDestructuringArrayImpl(ASTNode node) {
        super(node);
    }

    public JSDestructuringArrayImpl(JSDestructuringArrayStubImpl stub) {
        super(stub, (IStubElementType)JSStubElementTypes.DESTRUCTURING_ARRAY);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/javascript/psi/impl/JSDestructuringArrayImpl", "accept"));
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSDestructuringArray((JSDestructuringArray)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/impl/JSDestructuringArrayImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/psi/impl/JSDestructuringArrayImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/psi/impl/JSDestructuringArrayImpl", "processDeclarations"));
        }
        JSExpression[] declaredElements = (JSExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)this, JSExpression.class);
        if (declaredElements != null) {
            for (JSExpression child : declaredElements) {
                processor.execute((PsiElement)child, state);
            }
        }
        return true;
    }

    @NotNull
    public JSInitializerOwner[] getElements() {
        JSDestructuringArrayStubImpl stub = (JSDestructuringArrayStubImpl)this.getGreenStub();
        if (stub != null) {
            JSInitializerOwner[] children = (JSInitializerOwner[])this.getStubOrPsiChildren(JSExtendedLanguagesTokenSetProvider.INITIALIZER_OWNERS, (PsiElement[])JSInitializerOwner.EMPTY_ARRAY);
            boolean hasEmpty = stub.hasEmptyPositions();
            if (!hasEmpty) {
                if (children == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSDestructuringArrayImpl", "getElements"));
                }
                return children;
            }
            JSInitializerOwner[] result = new JSInitializerOwner[stub.getSize()];
            Set collect = Arrays.stream(stub.getEmptyPositions()).boxed().collect(Collectors.toSet());
            int currentIndexInChildrenArray = 0;
            for (int i = 0; i < result.length; ++i) {
                result[i] = collect.contains(i) || children.length < currentIndexInChildrenArray ? null : children[currentIndexInChildrenArray++];
            }
            if (result == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSDestructuringArrayImpl", "getElements"));
            }
            return result;
        }
        JSInitializerOwner[] jSInitializerOwnerArray = (JSInitializerOwner[])JSArrayLiteralExpressionImpl.getExpressionsWithSkippedElements((PsiElement)this, (TokenSet)JSExtendedLanguagesTokenSetProvider.INITIALIZER_OWNERS, JSInitializerOwner[]::new);
        if (jSInitializerOwnerArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSDestructuringArrayImpl", "getElements"));
        }
        return jSInitializerOwnerArray;
    }
}

