/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLetStatement;
import com.intellij.lang.javascript.psi.impl.JSStatementImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class JSLetStatementImpl
extends JSStatementImpl
implements JSLetStatement {
    public JSLetStatementImpl(ASTNode node) {
        super(node);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/javascript/psi/impl/JSLetStatementImpl", "accept"));
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSLetStatement((JSLetStatement)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public JSExpression[] getExpressions() {
        ASTNode[] children = this.getNode().getChildren(JSElementTypes.EXPRESSIONS);
        if (children.length == 0) {
            return JSExpression.EMPTY_ARRAY;
        }
        JSExpression[] result = new JSExpression[children.length];
        for (int i = 0; i < children.length; ++i) {
            result[i] = (JSExpression)children[i].getPsi();
        }
        return result;
    }

    public JSBlockStatement getBody() {
        ASTNode child = this.getNode().findChildByType((IElementType)JSElementTypes.BLOCK_STATEMENT);
        if (child == null) {
            return null;
        }
        return (JSBlockStatement)child.getPsi();
    }
}

