/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSDestructuringParameter;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.javascript.psi.stubs.JSParameterListStub;
import com.intellij.lang.javascript.psi.util.JSDestructuringVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class JSParameterListImpl
extends JSStubElementImpl<JSParameterListStub>
implements JSParameterList {
    private volatile JSParameter[] myParameters;
    private volatile JSParameterListElement[] myCallParameters;
    private static final TokenSet SIMPLE_PARAMETERS = TokenSet.andNot((TokenSet)JSExtendedLanguagesTokenSetProvider.PARAMETERS, (TokenSet)TokenSet.create((IElementType[])new IElementType[]{JSStubElementTypes.DESTRUCTURING_PARAMETER}));

    public JSParameterListImpl(ASTNode node) {
        super(node);
    }

    public JSParameterListImpl(JSParameterListStub stub) {
        this(stub, (IStubElementType)JSStubElementTypes.PARAMETER_LIST);
    }

    protected JSParameterListImpl(JSParameterListStub stub, IStubElementType type) {
        super(stub, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public JSParameter[] getParameterVariables() {
        JSParameter[] parameters = this.myParameters;
        if (parameters == null) {
            JSParameterListImpl jSParameterListImpl = this;
            synchronized (jSParameterListImpl) {
                parameters = this.myParameters;
                if (parameters == null) {
                    this.myParameters = parameters = this.calcParameters();
                }
            }
        }
        if (parameters == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSParameterListImpl", "getParameterVariables"));
        }
        return parameters;
    }

    @NotNull
    protected JSParameter[] calcParameters() {
        JSParameter[] parameters = this.getRawParameters();
        JSDestructuringContainer[] destructuringContainers = (JSDestructuringContainer[])this.getStubOrPsiChildren(JSElementTypes.DESTRUCTURING_CONTAINERS, (PsiElement[])JSDestructuringContainer.EMPTY_ARRAY);
        if (destructuringContainers.length != 0) {
            final ArrayList destrParameters = new ArrayList();
            JSDestructuringVisitor visitor = new JSDestructuringVisitor(){

                @Override
                public void visitJSParameter(JSParameter node) {
                    destrParameters.add(node);
                }

                @Override
                public void visitJSVariable(JSVariable node) {
                }
            };
            visitor.visitJSParameterList(this);
            parameters = new JSParameter[destrParameters.size()];
            destrParameters.toArray(parameters);
        }
        if (parameters == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSParameterListImpl", "calcParameters"));
        }
        return parameters;
    }

    @NotNull
    protected JSParameter[] getRawParameters() {
        JSParameter[] jSParameterArray = (JSParameter[])this.getStubOrPsiChildren(SIMPLE_PARAMETERS, (PsiElement[])JSParameter.EMPTY_ARRAY);
        if (jSParameterArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSParameterListImpl", "getRawParameters"));
        }
        return jSParameterArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public JSParameterListElement[] getParameters() {
        JSParameterListElement[] parameters = this.myCallParameters;
        if (parameters != null) {
            if (parameters != null) return parameters;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSParameterListImpl", "getParameters"));
        }
        JSParameterListImpl jSParameterListImpl = this;
        // MONITORENTER : jSParameterListImpl
        parameters = this.myCallParameters;
        if (parameters == null) {
            this.myCallParameters = parameters = this.calcCallParameters();
        }
        // MONITOREXIT : jSParameterListImpl
        if (parameters != null) return parameters;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSParameterListImpl", "getParameters"));
    }

    protected JSParameterListElement[] calcCallParameters() {
        DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)this);
        if (holder == null || !holder.hasFeature(JSLanguageFeature.DESTRUCTURING_PARAMETERS)) {
            return this.getParameterVariables();
        }
        PsiElement[] children = this.getStubOrPsiChildren(JSExtendedLanguagesTokenSetProvider.PARAMETERS, PsiElement.ARRAY_FACTORY);
        ArrayList result = ContainerUtil.newArrayList();
        for (PsiElement child : children) {
            if (child instanceof JSParameter) {
                result.add((JSParameter)child);
                continue;
            }
            if (!(child instanceof JSDestructuringParameter)) continue;
            result.add((JSDestructuringParameter)child);
        }
        return result.toArray(JSParameterListElement.EMPTY_ARRAY);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/javascript/psi/impl/JSParameterListImpl", "accept"));
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSParameterList((JSParameterList)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    public void clearCaches() {
        this.myParameters = null;
        this.myCallParameters = null;
        super.clearCaches();
    }
}

