/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.LanguageExtension;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveScopeProvider;
import com.intellij.psi.impl.ResolveScopeManager;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public abstract class JSElementResolveScopeProvider
extends ResolveScopeProvider {
    public static final LanguageExtension<JSElementResolveScopeProvider> EP_NAME = new LanguageExtension("JavaScript.elementScopeProvider");
    private static final Key<Map<Class, GlobalSearchScope>> PROJECT_SCOPE_WITH_LANGUAGE_SPECIFIC_PREDEFINED_KEY = Key.create((String)"js.project.scope.with.predefined.language.specific");

    @NotNull
    public GlobalSearchScope getElementResolveScope(@NotNull PsiElement element) {
        VirtualFile virtualFile;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/JSElementResolveScopeProvider", "getElementResolveScope"));
        }
        Project project = element.getProject();
        PsiFile psiFile = element.getContainingFile();
        if (psiFile != null && (virtualFile = psiFile.getOriginalFile().getVirtualFile()) != null) {
            GlobalSearchScope globalSearchScope = ResolveScopeManager.getInstance((Project)project).getDefaultResolveScope(virtualFile);
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSElementResolveScopeProvider", "getElementResolveScope"));
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = this.getProjectScopeIncludingPredefines(project);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSElementResolveScopeProvider", "getElementResolveScope"));
        }
        return globalSearchScope;
    }

    protected final GlobalSearchScope getProjectScopeIncludingPredefines(@NotNull Project project) {
        Class<?> aClass;
        GlobalSearchScope scope;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/psi/resolve/JSElementResolveScopeProvider", "getProjectScopeIncludingPredefines"));
        }
        HashMap scopes = (HashMap)project.getUserData(PROJECT_SCOPE_WITH_LANGUAGE_SPECIFIC_PREDEFINED_KEY);
        if (scopes == null) {
            scopes = new HashMap();
            project.putUserData(PROJECT_SCOPE_WITH_LANGUAGE_SPECIFIC_PREDEFINED_KEY, scopes);
        }
        if ((scope = (GlobalSearchScope)scopes.get(aClass = ((Object)((Object)this)).getClass())) == null) {
            List predefinedFiles = JSResolveUtil.JS_INDEXED_ROOT_PROVIDER.getLibraryFiles(project).stream().filter(this::isApplicable).collect(Collectors.toList());
            scope = GlobalSearchScope.filesScope((Project)project, predefinedFiles).uniteWith(GlobalSearchScope.allScope((Project)project));
            scopes.put(aClass, scope);
        }
        return scope;
    }

    protected abstract boolean isApplicable(@NotNull VirtualFile var1);
}

