/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSymbolNamespace;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeEvaluationResult;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSEvaluationResultContext;
import com.intellij.lang.javascript.psi.resolve.JSTypeProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSSimpleTypeProcessor
extends ResolveProcessor
implements JSTypeProcessor {
    @Nullable
    private JSTypeEvaluationResult myResult;
    @Nullable
    private PsiElement source;
    @Nullable
    private final PsiElement myTarget;

    public JSSimpleTypeProcessor() {
        this((PsiElement)null);
    }

    public JSSimpleTypeProcessor(@Nullable PsiElement target) {
        super((String)null);
        this.myTarget = target;
    }

    @Override
    public void process(@NotNull JSType type, @NotNull JSEvaluateContext evaluateContext, PsiElement _source) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/resolve/JSSimpleTypeProcessor", "process"));
        }
        if (evaluateContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluateContext", "com/intellij/lang/javascript/psi/resolve/JSSimpleTypeProcessor", "process"));
        }
        if (this.myTarget instanceof JSDefinitionExpression && _source instanceof JSReferenceExpression && ((JSDefinitionExpression)this.myTarget).getExpression() != _source) {
            return;
        }
        this.addPossibleOption(type, _source, evaluateContext);
        this.source = _source;
    }

    @Override
    public void processNamespace(@NotNull JSSymbolNamespace namespace, @NotNull JSEvaluateContext evaluateContext, PsiElement source) {
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/lang/javascript/psi/resolve/JSSimpleTypeProcessor", "processNamespace"));
        }
        if (evaluateContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluateContext", "com/intellij/lang/javascript/psi/resolve/JSSimpleTypeProcessor", "processNamespace"));
        }
        this.processTypeEvaluationResultElement(null, namespace, source, evaluateContext);
    }

    @Override
    public void processResolvedElement(@NotNull PsiElement element, @NotNull JSEvaluationResultContext evaluateContext) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/JSSimpleTypeProcessor", "processResolvedElement"));
        }
        if (evaluateContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluateContext", "com/intellij/lang/javascript/psi/resolve/JSSimpleTypeProcessor", "processResolvedElement"));
        }
        this.processTypeEvaluationResultElement(null, null, element, evaluateContext);
    }

    @Override
    @Nullable
    public PsiElement getTarget() {
        return this.myTarget;
    }

    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/JSSimpleTypeProcessor", "execute"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/psi/resolve/JSSimpleTypeProcessor", "execute"));
        }
        return true;
    }

    @Override
    public final void setUnknownElement(@NotNull PsiElement _element) {
        if (_element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_element", "com/intellij/lang/javascript/psi/resolve/JSSimpleTypeProcessor", "setUnknownElement"));
        }
        this.addPossibleOption(JSAnyType.get(_element, false), null, null);
        this.source = _element;
    }

    @Contract(value="null, null, null, _ -> fail")
    private void processTypeEvaluationResultElement(@Nullable JSType type, @Nullable JSSymbolNamespace namespace, @Nullable PsiElement element, @NotNull JSEvaluationResultContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/psi/resolve/JSSimpleTypeProcessor", "processTypeEvaluationResultElement"));
        }
        if (this.myResult == null) {
            this.myResult = new JSTypeEvaluationResult();
        }
        this.myResult.addResultElement(type, namespace, element, JSEvaluationResultContext.JSEvaluationResultContextImpl.copyFrom(context));
    }

    private void addPossibleOption(@NotNull JSType option, @Nullable PsiElement source, @Nullable JSEvaluationResultContext context) {
        if (option == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "option", "com/intellij/lang/javascript/psi/resolve/JSSimpleTypeProcessor", "addPossibleOption"));
        }
        if (this.myResult == null) {
            this.myResult = new JSTypeEvaluationResult();
        }
        this.myResult.addResultElement(option, null, source, JSEvaluationResultContext.JSEvaluationResultContextImpl.copyFrom(context));
    }

    @Nullable
    public final JSType getType() {
        return this.myResult != null ? this.myResult.getType() : null;
    }

    @Nullable
    public PsiElement getSource() {
        return this.source;
    }

    @Nullable
    public JSTypeEvaluationResult getResult() {
        return this.myResult;
    }
}

