/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve.accessibility;

import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.resolve.AccessibilityProcessingHandler;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSAccessibilityChecker {
    @Nullable
    protected String checkImpl(@Nullable PsiElement place, @NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/accessibility/JSAccessibilityChecker", "checkImpl"));
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    protected Collection<Class<? extends JSElement>> getSuitableClasses() {
        throw new UnsupportedOperationException();
    }

    public abstract boolean isAvailable(AccessibilityProcessingHandler var1, SinkResolveProcessor var2);

    private boolean isClassSuitable(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/accessibility/JSAccessibilityChecker", "isClassSuitable"));
        }
        for (Class<? extends JSElement> aClass : this.getSuitableClasses()) {
            if (!aClass.isInstance(element)) continue;
            return true;
        }
        return false;
    }

    public String check(@Nullable PsiElement place, @NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/accessibility/JSAccessibilityChecker", "check"));
        }
        if (this.isClassSuitable(element)) {
            return this.checkImpl(place, element);
        }
        return null;
    }
}

