/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptTypeOperatorJSTypeImpl
extends JSTypeBaseImpl
implements JSType.CompositeStructure {
    @NotNull
    private final JSType myReferencedType;

    public TypeScriptTypeOperatorJSTypeImpl(@NotNull JSType referencedType, @NotNull JSTypeSource source) {
        if (referencedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referencedType", "com/intellij/lang/javascript/psi/types/TypeScriptTypeOperatorJSTypeImpl", "<init>"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/types/TypeScriptTypeOperatorJSTypeImpl", "<init>"));
        }
        super(source);
        this.myReferencedType = referencedType;
    }

    @NotNull
    public String getTypeText(JSType.TypeTextFormat format) {
        if (format == JSType.TypeTextFormat.SERIALIZED) {
            String string = "#keyof(" + this.myReferencedType.getTypeText(format) + ")";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptTypeOperatorJSTypeImpl", "getTypeText"));
            }
            return string;
        }
        String string = "keyof " + this.myReferencedType.getTypeText(format);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptTypeOperatorJSTypeImpl", "getTypeText"));
        }
        return string;
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/lang/javascript/psi/types/TypeScriptTypeOperatorJSTypeImpl", "isDirectlyAssignableTypeImpl"));
        }
        JSType substitute = this.substitute();
        if (substitute != this && substitute.isDirectlyAssignableType(elementType, processingContext)) {
            return true;
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    @Override
    @NotNull
    protected JSType copyTypeHierarchy(@NotNull Function<JSType, JSType> childTransform) {
        if (childTransform == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childTransform", "com/intellij/lang/javascript/psi/types/TypeScriptTypeOperatorJSTypeImpl", "copyTypeHierarchy"));
        }
        JSType newType = JSTypeUtils.transformTypeHierarchySafe(this.myReferencedType, childTransform);
        if (this.myReferencedType == newType) {
            TypeScriptTypeOperatorJSTypeImpl typeScriptTypeOperatorJSTypeImpl = this;
            if (typeScriptTypeOperatorJSTypeImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptTypeOperatorJSTypeImpl", "copyTypeHierarchy"));
            }
            return typeScriptTypeOperatorJSTypeImpl;
        }
        TypeScriptTypeOperatorJSTypeImpl typeScriptTypeOperatorJSTypeImpl = new TypeScriptTypeOperatorJSTypeImpl(newType, this.getSource());
        if (typeScriptTypeOperatorJSTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptTypeOperatorJSTypeImpl", "copyTypeHierarchy"));
        }
        return typeScriptTypeOperatorJSTypeImpl;
    }

    @Override
    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/types/TypeScriptTypeOperatorJSTypeImpl", "copyWithNewSource"));
        }
        TypeScriptTypeOperatorJSTypeImpl typeScriptTypeOperatorJSTypeImpl = new TypeScriptTypeOperatorJSTypeImpl(this.myReferencedType, source);
        if (typeScriptTypeOperatorJSTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptTypeOperatorJSTypeImpl", "copyWithNewSource"));
        }
        return typeScriptTypeOperatorJSTypeImpl;
    }

    @Override
    protected boolean isEquivalentToImpl(@NotNull JSType type, ProcessingContext context, boolean allowResolve) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/types/TypeScriptTypeOperatorJSTypeImpl", "isEquivalentToImpl"));
        }
        if (type instanceof TypeScriptTypeOperatorJSTypeImpl) {
            return this.myReferencedType.isEquivalentTo(((TypeScriptTypeOperatorJSTypeImpl)type).getReferencedType(), context, allowResolve);
        }
        return false;
    }

    @Override
    @NotNull
    public JSType substitute() {
        JSType type = this.getReferencedType();
        JSType valuableType = JSTypeUtils.getValuableType(type);
        if (valuableType instanceof JSAnyType) {
            JSType jSType = valuableType;
            if (jSType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptTypeOperatorJSTypeImpl", "substitute"));
            }
            return jSType;
        }
        JSRecordType recordType = valuableType.asRecordType();
        ArrayList resultTypes = ContainerUtil.newArrayList();
        JSTypeSource typeSource = this.getSource();
        for (JSRecordType.TypeMember member : recordType.getTypeMembers()) {
            if (!(member instanceof JSRecordType.PropertySignature)) continue;
            PsiElement psiElement = member.getSource();
            JSTypeSource source = psiElement == null ? typeSource : JSTypeSourceFactory.createTypeSource(psiElement, typeSource.isExplicitlyDeclared());
            resultTypes.add(new JSStringLiteralTypeImpl(((JSRecordType.PropertySignature)member).getMemberName(), true, source));
        }
        JSCompositeTypeImpl jSCompositeTypeImpl = resultTypes.size() == 1 ? (JSType)resultTypes.get(0) : new JSCompositeTypeImpl(typeSource, resultTypes);
        if (jSCompositeTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptTypeOperatorJSTypeImpl", "substitute"));
        }
        return jSCompositeTypeImpl;
    }

    @NotNull
    public JSType getReferencedType() {
        JSType jSType = this.myReferencedType;
        if (jSType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptTypeOperatorJSTypeImpl", "getReferencedType"));
        }
        return jSType;
    }

    @Override
    public void acceptChildren(JSRecursiveTypeVisitor visitor) {
        this.myReferencedType.accept(visitor);
    }
}

