/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.introduceConstant;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.flex.ImportUtils;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.refactoring.BaseJSRefactoringHandler;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseInplaceIntroducer;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseIntroduceHandler;
import com.intellij.lang.javascript.refactoring.introduceConstant.JSIntroduceConstantDialog;
import com.intellij.lang.javascript.refactoring.introduceConstant.JSIntroduceConstantSettings;
import com.intellij.lang.javascript.refactoring.introduceVariable.InplaceSettings;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.introduce.inplace.OccurrencesChooser;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.IncorrectOperationException;

public class JSIntroduceConstantHandler
extends JSBaseIntroduceHandler<JSElement, JSIntroduceConstantSettings, JSIntroduceConstantDialog> {
    private boolean myIntroducingInTheSameClass;
    private boolean myShortRefIsAmbigousOrUnequal;

    @Override
    protected String getRefactoringName() {
        return JSBundle.message((String)"javascript.introduce.constant.title", (Object[])new Object[0]);
    }

    @Override
    protected String getCannotIntroduceMessagePropertyKey() {
        return "javascript.introduce.constant.error.no.expression.selected";
    }

    @Override
    protected String getCannotIntroduceVoidExpressionTypeMessagePropertyKey() {
        return "javascript.introduce.constant.error.expression.has.void.type";
    }

    @Override
    protected JSIntroduceConstantDialog createDialog(Project project, JSExpression expression, JSExpression[] occurrences, PsiElement scope) {
        return new JSIntroduceConstantDialog(project, occurrences, expression, scope);
    }

    @Override
    protected String getDeclText(JSBaseIntroduceHandler.BaseIntroduceContext<JSIntroduceConstantSettings> baseIntroduceContext, JSElement anchor) {
        String baseDeclText = "static const " + ((JSIntroduceConstantSettings)baseIntroduceContext.settings).getVariableName();
        return JSIntroduceConstantHandler.prependAccessModifier(baseIntroduceContext, baseDeclText);
    }

    @Override
    protected JSElement findAnchor(JSBaseIntroduceHandler.BaseIntroduceContext<JSIntroduceConstantSettings> context, boolean replaceAllOccurences) {
        JSElement element = JSIntroduceConstantHandler.findClassAnchor((PsiElement)context.expressionDescriptor.first);
        String className = ((JSIntroduceConstantSettings)context.settings).getClassName();
        if (!StringUtil.isEmpty((String)className)) {
            PsiElement qName = JSResolveUtil.findType(className, (PsiElement)context.expressionDescriptor.first, true);
            assert (qName instanceof JSClass);
            if (element != null && qName == JSResolveUtil.findParent((PsiElement)element)) {
                this.myIntroducingInTheSameClass = true;
            }
            return (JSElement)qName;
        }
        return element;
    }

    @Override
    protected Pair<JSVarStatement, Boolean> prepareDeclaration(String varDeclText, JSBaseIntroduceHandler.BaseIntroduceContext<JSIntroduceConstantSettings> context, Project project, JSLanguageDialect languageDialect, JSElement anchorStatement, Editor editor, JSExpression introducedExpression) throws IncorrectOperationException {
        String qName = ((JSIntroduceConstantSettings)context.settings).getClassName();
        if (!StringUtil.isEmpty((String)qName) && !this.myIntroducingInTheSameClass && StringUtil.getPackageName((String)qName).length() > 0) {
            this.myShortRefIsAmbigousOrUnequal = JSResolveUtil.shortReferenceIsAmbiguousOrUnequal(JSResolveUtil.getShortTypeName(qName, true), (PsiElement)context.expressionDescriptor.first, qName, true);
            if (!this.myShortRefIsAmbigousOrUnequal) {
                ImportUtils.doImport((PsiElement)context.expressionDescriptor.first, qName, false);
            }
        }
        return super.prepareDeclaration(varDeclText, context, project, languageDialect, anchorStatement, editor, introducedExpression);
    }

    @Override
    protected JSExpression createRefExpr(Project project, JSIntroduceConstantSettings settings, JSLanguageDialect languageDialect) {
        String qName = settings.getClassName();
        if (!StringUtil.isEmpty((String)qName) && !this.myIntroducingInTheSameClass) {
            String className = this.myShortRefIsAmbigousOrUnequal ? qName : JSResolveUtil.getShortTypeName(qName, true);
            return (JSExpression)JSChangeUtil.createExpressionFromText(project, className + "." + settings.getVariableName(), languageDialect).getPsi();
        }
        return super.createRefExpr(project, settings, languageDialect);
    }

    @Override
    protected JSVariable addStatementBefore(JSElement anchor, JSVarStatement declaration) throws IncorrectOperationException {
        return JSIntroduceConstantHandler.addToClassAnchor(anchor, declaration);
    }

    @Override
    protected Pair<JSExpression, TextRange> findIntroducedExpression(PsiFile file, int start, int end, Editor editor, DataContext dataContext) {
        if (!BaseJSRefactoringHandler.checkEcma((PsiElement)file, editor, this.getRefactoringName())) {
            return null;
        }
        Pair<JSExpression, TextRange> expressionDescriptor = super.findIntroducedExpression(file, start, end, editor, dataContext);
        if (expressionDescriptor == null) {
            return null;
        }
        final Ref hasAccesibilityProblem = new Ref();
        ((JSExpression)expressionDescriptor.first).accept((PsiElementVisitor)new JSElementVisitor(){

            public void visitJSReferenceExpression(JSReferenceExpression node) {
                if (node.getQualifier() == null) {
                    PsiElement element = node.resolve();
                    if (element instanceof JSAttributeListOwner && !(element instanceof JSClass) && !JSResolveUtil.isConstructorFunction(element)) {
                        JSAttributeList attributeList = ((JSAttributeListOwner)element).getAttributeList();
                        if (attributeList == null || !attributeList.hasModifier(JSAttributeList.ModifierType.STATIC)) {
                            hasAccesibilityProblem.set((Object)Boolean.TRUE);
                        }
                    } else if (element == null) {
                        hasAccesibilityProblem.set((Object)Boolean.TRUE);
                    }
                }
                super.visitJSReferenceExpression(node);
            }

            public void visitJSElement(JSElement node) {
                node.acceptChildren((PsiElementVisitor)this);
            }
        });
        if (Boolean.TRUE.equals(hasAccesibilityProblem.get())) {
            CommonRefactoringUtil.showErrorHint((Project)file.getProject(), (Editor)editor, (String)JSBundle.message((String)"javascript.introduce.constant.error.not.constant.expression.selected", (Object[])new Object[0]), (String)this.getRefactoringName(), null);
            return null;
        }
        return expressionDescriptor;
    }

    @Override
    protected InplaceSettings<JSIntroduceConstantSettings> getInplaceSettings(Pair<JSExpression, TextRange> expr, JSExpression[] occurrences, PsiElement scope, OccurrencesChooser.ReplaceChoice choice) {
        return null;
    }

    @Override
    protected JSBaseInplaceIntroducer createInplaceIntroducer(JSBaseIntroduceHandler.BaseIntroduceContext<JSIntroduceConstantSettings> context, JSElement scope, Editor editor, Project project, JSExpression[] occurences) {
        return null;
    }
}

