/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.moveMembers;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.moveMembers.JSMoveMembersDialog;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.MoveHandlerDelegate;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import java.util.HashSet;
import org.jetbrains.annotations.Nullable;

public class JSMoveMembersHandler
extends MoveHandlerDelegate {
    public static final String REFACTORING_NAME = JSBundle.message((String)"move.members.refactoring.name", (Object[])new Object[0]);

    public boolean tryToMove(PsiElement element, Project project, DataContext dataContext, @Nullable PsiReference reference, Editor editor) {
        if (JSMoveMembersHandler.isStaticMethodOrField(element)) {
            if (!JSRefactoringUtil.checkReadOnlyStatus(element, editor, REFACTORING_NAME)) {
                return true;
            }
            this.doMove(project, new PsiElement[]{element}, null, null);
            return true;
        }
        return false;
    }

    public void doMove(Project project, PsiElement[] elements, @Nullable PsiElement targetContainer, @Nullable MoveCallback callback) {
        if (elements.length == 0) {
            return;
        }
        JSClass sourceClass = JSUtils.getMemberContainingClass(elements[0]);
        if (sourceClass == null) {
            return;
        }
        HashSet<JSElement> preselectMembers = new HashSet<JSElement>();
        for (PsiElement element : elements) {
            if (element instanceof JSFunction && !sourceClass.equals(JSUtils.getMemberContainingClass(element))) {
                String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"members.to.be.moved.should.belong.to.the.same.class"));
                CommonRefactoringUtil.showErrorMessage((String)REFACTORING_NAME, (String)message, null, (Project)project);
                return;
            }
            if (element instanceof JSVariable) {
                JSVariable field = (JSVariable)element;
                if (field.getAttributeList() == null || !field.getAttributeList().hasModifier(JSAttributeList.ModifierType.STATIC)) {
                    String fieldName = field.getName();
                    String message = RefactoringBundle.message((String)"field.0.is.not.static", (Object[])new Object[]{fieldName, REFACTORING_NAME});
                    CommonRefactoringUtil.showErrorMessage((String)REFACTORING_NAME, (String)message, null, (Project)project);
                    return;
                }
                preselectMembers.add((JSElement)field);
                continue;
            }
            if (!(element instanceof JSFunction)) continue;
            JSFunction method = (JSFunction)element;
            String methodName = method.getName();
            if (method.isConstructor()) {
                String message = RefactoringBundle.message((String)"0.refactoring.cannot.be.applied.to.constructors", (Object[])new Object[]{REFACTORING_NAME});
                CommonRefactoringUtil.showErrorMessage((String)REFACTORING_NAME, (String)message, null, (Project)project);
                return;
            }
            if (method.getAttributeList() == null || !method.getAttributeList().hasModifier(JSAttributeList.ModifierType.STATIC)) {
                String message = RefactoringBundle.message((String)"method.0.is.not.static", (Object[])new Object[]{methodName, REFACTORING_NAME});
                CommonRefactoringUtil.showErrorMessage((String)REFACTORING_NAME, (String)message, null, (Project)project);
                return;
            }
            preselectMembers.add((JSElement)method);
        }
        if (!JSRefactoringUtil.checkReadOnlyStatus((PsiElement)sourceClass, null, REFACTORING_NAME)) {
            return;
        }
        JSClass initialTargerClass = targetContainer instanceof JSClass ? (JSClass)targetContainer : null;
        JSMoveMembersDialog dialog = new JSMoveMembersDialog(project, sourceClass, initialTargerClass, preselectMembers, callback);
        dialog.show();
    }

    public boolean isValidTarget(PsiElement psiElement, PsiElement[] sources) {
        return psiElement instanceof JSClass;
    }

    public boolean canMove(PsiElement[] elements, @Nullable PsiElement targetContainer) {
        for (PsiElement element : elements) {
            if (JSMoveMembersHandler.isStaticMethodOrField(element)) continue;
            return false;
        }
        return super.canMove(elements, targetContainer);
    }

    private static boolean isStaticMethodOrField(PsiElement element) {
        JSClass clazz = JSUtils.getMemberContainingClass(element);
        if (clazz == null || clazz.isInterface()) {
            return false;
        }
        JSAttributeList attributeList = ((JSAttributeListOwner)element).getAttributeList();
        return attributeList != null && attributeList.hasModifier(JSAttributeList.ModifierType.STATIC);
    }
}

