/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation;

import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6FunctionProperty;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6NamespaceImportExport;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.highlighting.JSHighlighter;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSGeneratorExpression;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;

public class JSKeywordHighlighterVisitor
extends JSRecursiveWalkingElementVisitor {
    protected final AnnotationHolder myHolder;

    public JSKeywordHighlighterVisitor(AnnotationHolder holder) {
        this.myHolder = holder;
    }

    public void visitJSGeneratorExpression(JSGeneratorExpression element) {
        this.highlightChildKeywordOfType((PsiElement)element, JSTokenTypes.EACH_KEYWORD);
        super.visitJSGeneratorExpression(element);
    }

    public void visitJSForInStatement(JSForInStatement element) {
        this.highlightChildKeywordOfType((PsiElement)element, JSTokenTypes.EACH_KEYWORD);
        super.visitJSForInStatement(element);
    }

    public void visitJSFunctionExpression(@NotNull JSFunctionExpression function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/validation/JSKeywordHighlighterVisitor", "visitJSFunctionExpression"));
        }
        this.highlightKeywordGetterAndSetter((JSFunction)function);
        super.visitJSFunctionExpression(function);
    }

    public void visitES6FunctionProperty(ES6FunctionProperty function) {
        this.highlightKeywordGetterAndSetter((JSFunction)function);
        super.visitES6FunctionProperty(function);
    }

    public void visitJSFunctionDeclaration(@NotNull JSFunction function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/validation/JSKeywordHighlighterVisitor", "visitJSFunctionDeclaration"));
        }
        this.highlightKeywordGetterAndSetter(function);
        super.visitJSFunctionDeclaration(function);
    }

    public void visitES6FromClause(ES6FromClause element) {
        this.highlightChildKeywordOfType((PsiElement)element, JSTokenTypes.FROM_KEYWORD);
        super.visitES6FromClause(element);
    }

    public void visitES6NamespaceImportExport(ES6NamespaceImportExport element) {
        this.highlightChildKeywordOfType((PsiElement)element, JSTokenTypes.AS_KEYWORD);
        super.visitES6NamespaceImportExport(element);
    }

    public void visitES6ImportSpecifierAlias(ES6ImportSpecifierAlias specifierAlias) {
        this.highlightChildKeywordOfType((PsiElement)specifierAlias, JSTokenTypes.AS_KEYWORD);
        super.visitES6ImportSpecifierAlias(specifierAlias);
    }

    protected void highlightKeywordGetterAndSetter(@NotNull JSFunction function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/validation/JSKeywordHighlighterVisitor", "highlightKeywordGetterAndSetter"));
        }
        PsiElement nameIdentifier = function.getNameIdentifier();
        if (nameIdentifier == null) {
            return;
        }
        ASTNode accessNode = function.getNode().findChildByType(JSTokenTypes.GET_SET);
        if (accessNode != null && accessNode != nameIdentifier.getNode()) {
            JSKeywordHighlighterVisitor.highlightKeyword(accessNode, this.myHolder);
        }
    }

    protected static void highlightKeyword(@NotNull ASTNode keyword, @NotNull AnnotationHolder holder) {
        if (keyword == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyword", "com/intellij/lang/javascript/validation/JSKeywordHighlighterVisitor", "highlightKeyword"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/javascript/validation/JSKeywordHighlighterVisitor", "highlightKeyword"));
        }
        Annotation anno = holder.createAnnotation(HighlightInfoType.SYMBOL_TYPE_SEVERITY, keyword.getTextRange(), null);
        anno.setTextAttributes(JSHighlighter.JS_KEYWORD);
    }

    protected void highlightChildKeywordOfTypes(@NotNull PsiElement parent, @NotNull TokenSet types) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/lang/javascript/validation/JSKeywordHighlighterVisitor", "highlightChildKeywordOfTypes"));
        }
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/intellij/lang/javascript/validation/JSKeywordHighlighterVisitor", "highlightChildKeywordOfTypes"));
        }
        ASTNode keyword = parent.getNode().findChildByType(types);
        if (keyword != null) {
            JSKeywordHighlighterVisitor.highlightKeyword(keyword, this.myHolder);
        }
    }

    protected void highlightChildKeywordOfType(@NotNull PsiElement parent, @NotNull IElementType type) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/lang/javascript/validation/JSKeywordHighlighterVisitor", "highlightChildKeywordOfType"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/validation/JSKeywordHighlighterVisitor", "highlightChildKeywordOfType"));
        }
        ASTNode keyword = parent.getNode().findChildByType(type);
        if (keyword != null) {
            JSKeywordHighlighterVisitor.highlightKeyword(keyword, this.myHolder);
        }
    }
}

