/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.control;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.InspectionJSFix;
import com.sixrr.inspectjs.JSGroupNames;
import com.sixrr.inspectjs.JavaScriptInspection;
import com.sixrr.inspectjs.utils.EquivalenceChecker;
import org.jetbrains.annotations.NotNull;

public class ConditionalExpressionWithIdenticalBranchesJSInspection
extends JavaScriptInspection
implements CleanupLocalInspectionTool {
    private final InspectionJSFix fix = new CollapseConditional();

    @NotNull
    public String getDisplayName() {
        String string = InspectionJSBundle.message("conditional.expression.with.identical.branches.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/control/ConditionalExpressionWithIdenticalBranchesJSInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = JSGroupNames.CONTROL_FLOW_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/control/ConditionalExpressionWithIdenticalBranchesJSInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Override
    public String buildErrorString(Object ... args) {
        return InspectionJSBundle.message("conditional.expression.with.identical.branches.error.string", new Object[0]);
    }

    @Override
    public InspectionJSFix buildFix(PsiElement location) {
        return this.fix;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ConditionalExpressionWithIdenticalBranchesVisitor();
    }

    private static class ConditionalExpressionWithIdenticalBranchesVisitor
    extends BaseInspectionVisitor {
        private ConditionalExpressionWithIdenticalBranchesVisitor() {
        }

        public void visitJSConditionalExpression(JSConditionalExpression expression) {
            super.visitJSConditionalExpression(expression);
            JSExpression thenExpression = expression.getThen();
            JSExpression elseExpression = expression.getElse();
            if (EquivalenceChecker.expressionsAreEquivalent(thenExpression, elseExpression)) {
                this.registerError((PsiElement)expression);
            }
        }
    }

    private static class CollapseConditional
    extends InspectionJSFix {
        private CollapseConditional() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionJSBundle.message("collapse.conditional.expression.fix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/control/ConditionalExpressionWithIdenticalBranchesJSInspection$CollapseConditional", "getFamilyName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            JSConditionalExpression expression = (JSConditionalExpression)descriptor.getPsiElement();
            JSExpression thenExpression = expression.getThen();
            assert (thenExpression != null);
            String bodyText = thenExpression.getText();
            CollapseConditional.replaceExpression((JSExpression)expression, bodyText);
        }
    }
}

