/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.control;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCommonTypeNames;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.InspectionJSFix;
import com.sixrr.inspectjs.JSGroupNames;
import com.sixrr.inspectjs.JavaScriptInspection;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTypeOfValuesInspection
extends JavaScriptInspection {
    private static Set<String> typeofValuesSet = ContainerUtil.newHashSet((Object[])JSCommonTypeNames.TYPEOF_VALUES);

    @NotNull
    public String getDisplayName() {
        String string = InspectionJSBundle.message("typeof.using.incorrect.case.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/control/JSTypeOfValuesInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = JSGroupNames.BUGS_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/control/JSTypeOfValuesInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new BaseInspectionVisitor(){

            public void visitJSBinaryExpression(JSBinaryExpression node) {
                super.visitJSBinaryExpression(node);
                if (!JSTypeOfValuesInspection.isComparingOperation(node)) {
                    return;
                }
                boolean acceptedType = true;
                JSLiteralExpression literal = null;
                if (node.getLOperand() instanceof JSPrefixExpression && node.getROperand() instanceof JSLiteralExpression) {
                    literal = (JSLiteralExpression)node.getROperand();
                    acceptedType = JSTypeOfValuesInspection.isAcceptedType((JSPrefixExpression)node.getLOperand(), (JSLiteralExpression)node.getROperand());
                } else if (node.getLOperand() instanceof JSLiteralExpression && node.getROperand() instanceof JSPrefixExpression) {
                    literal = (JSLiteralExpression)node.getLOperand();
                    acceptedType = JSTypeOfValuesInspection.isAcceptedType((JSPrefixExpression)node.getROperand(), (JSLiteralExpression)node.getLOperand());
                }
                if (!acceptedType) {
                    this.registerError((PsiElement)literal);
                }
            }
        };
    }

    private static boolean isComparingOperation(JSBinaryExpression node) {
        return node.getOperationSign() == JSTokenTypes.EQEQ || node.getOperationSign() == JSTokenTypes.EQEQEQ || node.getOperationSign() == JSTokenTypes.NEQEQ || node.getOperationSign() == JSTokenTypes.NE;
    }

    @Override
    protected String buildErrorString(Object ... args) {
        return InspectionJSBundle.message("typeof.using.incorrect.case.error", new Object[0]);
    }

    private static boolean isAcceptedType(JSPrefixExpression pref, JSLiteralExpression expr) {
        if (pref.getOperationSign() != JSTokenTypes.TYPEOF_KEYWORD || !expr.isQuotedLiteral()) {
            return true;
        }
        Object value = expr.getValue();
        if (!(value instanceof String)) {
            return true;
        }
        String stringValue = (String)value;
        return typeofValuesSet.contains(stringValue);
    }

    @Override
    @Nullable
    protected InspectionJSFix buildFix(final PsiElement location) {
        final JSLiteralExpression literalExpression = (JSLiteralExpression)location;
        String text = literalExpression.getText();
        if (StringUtil.isEmpty((String)text)) {
            return null;
        }
        Object value = literalExpression.getValue();
        if (!(value instanceof String)) {
            return null;
        }
        char quote = text.charAt(0);
        String stringValue = StringUtil.toLowerCase((String)((String)value));
        if (!typeofValuesSet.contains(stringValue)) {
            return null;
        }
        final String quotedValue = quote + stringValue + quote;
        return new InspectionJSFix(){

            @Nls
            @NotNull
            public String getName() {
                String string = InspectionJSBundle.message("typeof.using.incorrect.convert", quotedValue);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/control/JSTypeOfValuesInspection$2", "getName"));
                }
                return string;
            }

            @Nls
            @NotNull
            public String getFamilyName() {
                if ("Convert to standard value" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/control/JSTypeOfValuesInspection$2", "getFamilyName"));
                }
                return "Convert to standard value";
            }

            @Override
            protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
                JSExpression newExpr = (JSExpression)JSChangeUtil.createExpressionFromText(location.getProject(), quotedValue).getPsi();
                JSChangeUtil.replaceExpression((JSExpression)literalExpression, newExpr);
            }
        };
    }
}

