/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.ClassFilter;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Splitter;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;

public class NullableNotNullDialog
extends DialogWrapper {
    private final Project myProject;
    private AnnotationsPanel myNullablePanel;
    private AnnotationsPanel myNotNullPanel;

    public NullableNotNullDialog(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/NullableNotNullDialog", "<init>"));
        }
        super(project, true);
        this.myProject = project;
        this.init();
        this.setTitle("Nullable/NotNull configuration");
    }

    public static JButton createConfigureAnnotationsButton(Component context) {
        JButton button = new JButton(InspectionsBundle.message("configure.annotations.option", new Object[0]));
        button.addActionListener(NullableNotNullDialog.createActionListener(context));
        return button;
    }

    public static ActionListener createActionListener(final Component context) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Project project = CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext(context));
                if (project == null) {
                    project = ProjectManager.getInstance().getDefaultProject();
                }
                new NullableNotNullDialog(project).show();
            }
        };
    }

    @Override
    protected JComponent createCenterPanel() {
        NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)this.myProject);
        Splitter splitter = new Splitter(true);
        this.myNullablePanel = new AnnotationsPanel("Nullable", manager.getDefaultNullable(), manager.getNullables(), NullableNotNullManager.DEFAULT_NULLABLES);
        splitter.setFirstComponent(this.myNullablePanel.getComponent());
        this.myNotNullPanel = new AnnotationsPanel("NotNull", manager.getDefaultNotNull(), manager.getNotNulls(), ArrayUtil.toStringArray((Collection)manager.getPredefinedNotNulls()));
        splitter.setSecondComponent(this.myNotNullPanel.getComponent());
        splitter.setHonorComponentsMinimumSize(true);
        splitter.setPreferredSize((Dimension)JBUI.size((int)300, (int)400));
        return splitter;
    }

    @Override
    protected void doOKAction() {
        NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)this.myProject);
        manager.setNotNulls(this.myNotNullPanel.getAnnotations());
        manager.setDefaultNotNull(this.myNotNullPanel.getDefaultAnnotation());
        manager.setNullables(this.myNullablePanel.getAnnotations());
        manager.setDefaultNullable(this.myNullablePanel.getDefaultAnnotation());
        super.doOKAction();
    }

    private class AnnotationsPanel {
        private String myDefaultAnnotation;
        private final Set<String> myDefaultAnnotations;
        private final JBList myList;
        private final JPanel myComponent;

        private AnnotationsPanel(final String name, String defaultAnnotation, Collection<String> annotations, String[] defaultAnnotations) {
            this.myDefaultAnnotation = defaultAnnotation;
            this.myDefaultAnnotations = new HashSet<String>(Arrays.asList(defaultAnnotations));
            this.myList = new JBList<String>(annotations);
            this.myList.setCellRenderer(new ColoredListCellRenderer(){

                protected void customizeCellRenderer(@NotNull JList list, Object value, int index, boolean selected, boolean hasFocus) {
                    if (list == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/codeInsight/NullableNotNullDialog$AnnotationsPanel$1", "customizeCellRenderer"));
                    }
                    this.append((String)value, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    if (value.equals(AnnotationsPanel.this.myDefaultAnnotation)) {
                        this.setIcon(AllIcons.Diff.CurrentLine);
                    } else {
                        this.setIcon(EmptyIcon.ICON_16);
                    }
                }
            });
            AnActionButton selectButton = new AnActionButton("Select annotation used for code generation", AllIcons.Actions.Checked){

                @Override
                public void actionPerformed(AnActionEvent e) {
                    String selectedValue = (String)AnnotationsPanel.this.myList.getSelectedValue();
                    if (selectedValue == null) {
                        return;
                    }
                    AnnotationsPanel.this.myDefaultAnnotation = selectedValue;
                    DefaultListModel model = (DefaultListModel)AnnotationsPanel.this.myList.getModel();
                    model.setElementAt(AnnotationsPanel.this.myList.getSelectedValue(), AnnotationsPanel.this.myList.getSelectedIndex());
                }

                @Override
                public void updateButton(AnActionEvent e) {
                    boolean enabled;
                    String selectedValue = (String)AnnotationsPanel.this.myList.getSelectedValue();
                    boolean bl = enabled = selectedValue != null && !selectedValue.equals(AnnotationsPanel.this.myDefaultAnnotation);
                    if (!enabled) {
                        e.getPresentation().setEnabled(enabled);
                    }
                }
            };
            ToolbarDecorator toolbarDecorator = ToolbarDecorator.createDecorator(this.myList).disableUpDownActions().setAddAction(new AnActionButtonRunnable(){

                public void run(AnActionButton anActionButton) {
                    AnnotationsPanel.this.chooseAnnotation(name, AnnotationsPanel.this.myList);
                }
            }).setRemoveAction(new AnActionButtonRunnable(){

                public void run(AnActionButton anActionButton) {
                    String selectedValue = (String)AnnotationsPanel.this.myList.getSelectedValue();
                    if (selectedValue == null) {
                        return;
                    }
                    if (AnnotationsPanel.this.myDefaultAnnotation.equals(selectedValue)) {
                        AnnotationsPanel.this.myDefaultAnnotation = (String)AnnotationsPanel.this.myList.getModel().getElementAt(0);
                    }
                    ((DefaultListModel)AnnotationsPanel.this.myList.getModel()).removeElement(selectedValue);
                }
            }).addExtraAction(selectButton);
            JPanel panel = toolbarDecorator.createPanel();
            this.myComponent = new JPanel(new BorderLayout());
            this.myComponent.setBorder(IdeBorderFactory.createTitledBorder(name + " annotations", false, new Insets(10, 0, 0, 0)));
            this.myComponent.add(panel);
            final AnActionButton removeButton = ToolbarDecorator.findRemoveButton(this.myComponent);
            this.myList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (e.getValueIsAdjusting()) {
                        return;
                    }
                    String selectedValue = (String)AnnotationsPanel.this.myList.getSelectedValue();
                    if (AnnotationsPanel.this.myDefaultAnnotations.contains(selectedValue)) {
                        SwingUtilities.invokeLater(() -> removeButton.setEnabled(false));
                    }
                }
            });
            this.myList.setSelectionMode(0);
            this.myList.setSelectedValue(this.myDefaultAnnotation, true);
        }

        private void chooseAnnotation(String title, JBList list) {
            TreeClassChooser chooser = TreeClassChooserFactory.getInstance(NullableNotNullDialog.this.myProject).createNoInnerClassesScopeChooser("Choose " + title + " annotation", GlobalSearchScope.allScope(NullableNotNullDialog.this.myProject), new ClassFilter(){

                public boolean isAccepted(PsiClass aClass) {
                    return aClass.isAnnotationType();
                }
            }, null);
            chooser.showDialog();
            PsiClass selected = chooser.getSelected();
            if (selected == null) {
                return;
            }
            String qualifiedName = selected.getQualifiedName();
            DefaultListModel model = (DefaultListModel)list.getModel();
            int index = model.indexOf(qualifiedName);
            if (index < 0) {
                model.addElement(qualifiedName);
            } else {
                this.myList.setSelectedIndex(index);
            }
        }

        public JComponent getComponent() {
            return this.myComponent;
        }

        public String getDefaultAnnotation() {
            return this.myDefaultAnnotation;
        }

        public String[] getAnnotations() {
            ListModel model = this.myList.getModel();
            int size = model.getSize();
            String[] result = new String[size];
            for (int i2 = 0; i2 < size; ++i2) {
                result[i2] = (String)model.getElementAt(i2);
            }
            return result;
        }
    }
}

