/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.util.text.DateFormatUtil;
import java.util.Comparator;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ChangeListColumn<T extends ChangeList> {
    public static final ChangeListColumn<CommittedChangeList> DATE = new ChangeListColumn<CommittedChangeList>(){

        @Override
        @NotNull
        public String getTitle() {
            String string = VcsBundle.message("column.name.revision.list.date", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ChangeListColumn$1", "getTitle"));
            }
            return string;
        }

        @Override
        @NotNull
        public Object getValue(@NotNull CommittedChangeList changeList) {
            if (changeList == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeList", "com/intellij/openapi/vcs/ChangeListColumn$1", "getValue"));
            }
            String string = DateFormatUtil.formatPrettyDateTime((Date)changeList.getCommitDate());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ChangeListColumn$1", "getValue"));
            }
            return string;
        }

        @Override
        @NotNull
        public Comparator<CommittedChangeList> getComparator() {
            Comparator<CommittedChangeList> comparator = Comparator.comparing(CommittedChangeList::getCommitDate);
            if (comparator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ChangeListColumn$1", "getComparator"));
            }
            return comparator;
        }
    };
    public static final ChangeListColumn<CommittedChangeList> NAME = new ChangeListColumn<CommittedChangeList>(){

        @Override
        @NotNull
        public String getTitle() {
            String string = VcsBundle.message("column.name.revision.list.committer", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ChangeListColumn$2", "getTitle"));
            }
            return string;
        }

        @Override
        public Object getValue(@NotNull CommittedChangeList changeList) {
            if (changeList == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeList", "com/intellij/openapi/vcs/ChangeListColumn$2", "getValue"));
            }
            return changeList.getCommitterName();
        }

        @Override
        @NotNull
        public Comparator<CommittedChangeList> getComparator() {
            Comparator comparator = (changeList1, changeList2) -> Comparing.compare((Comparable)((Object)changeList1.getCommitterName()), (Comparable)((Object)changeList2.getCommitterName()));
            if (comparator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ChangeListColumn$2", "getComparator"));
            }
            return comparator;
        }
    };
    public static final ChangeListColumn<CommittedChangeList> NUMBER = new ChangeListNumberColumn(VcsBundle.message("column.name.revision.list.number", new Object[0]));
    public static final ChangeListColumn<CommittedChangeList> DESCRIPTION = new ChangeListColumn<CommittedChangeList>(){

        @Override
        @NotNull
        public String getTitle() {
            String string = VcsBundle.message("column.name.revision.list.description", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ChangeListColumn$3", "getTitle"));
            }
            return string;
        }

        @Override
        @NotNull
        public Object getValue(@NotNull CommittedChangeList changeList) {
            if (changeList == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeList", "com/intellij/openapi/vcs/ChangeListColumn$3", "getValue"));
            }
            String string = changeList.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ChangeListColumn$3", "getValue"));
            }
            return string;
        }

        @Override
        @NotNull
        public Comparator<CommittedChangeList> getComparator() {
            Comparator<CommittedChangeList> comparator = Comparator.comparing(ChangeList::getName);
            if (comparator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ChangeListColumn$3", "getComparator"));
            }
            return comparator;
        }
    };

    public abstract String getTitle();

    public abstract Object getValue(T var1);

    @Nullable
    public Comparator<T> getComparator() {
        return null;
    }

    public static boolean isCustom(@NotNull ChangeListColumn column) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/openapi/vcs/ChangeListColumn", "isCustom"));
        }
        return column != DATE && column != DESCRIPTION && column != NAME && !(column instanceof ChangeListNumberColumn);
    }

    public static class ChangeListNumberColumn
    extends ChangeListColumn<CommittedChangeList> {
        private final String myTitle;

        public ChangeListNumberColumn(String title) {
            this.myTitle = title;
        }

        @Override
        public String getTitle() {
            return this.myTitle;
        }

        @Override
        @NotNull
        public Object getValue(@NotNull CommittedChangeList changeList) {
            if (changeList == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeList", "com/intellij/openapi/vcs/ChangeListColumn$ChangeListNumberColumn", "getValue"));
            }
            Long l = changeList.getNumber();
            if (l == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ChangeListColumn$ChangeListNumberColumn", "getValue"));
            }
            return l;
        }

        @Override
        @NotNull
        public Comparator<CommittedChangeList> getComparator() {
            Comparator<CommittedChangeList> comparator = Comparator.comparingLong(CommittedChangeList::getNumber);
            if (comparator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ChangeListColumn$ChangeListNumberColumn", "getComparator"));
            }
            return comparator;
        }
    }
}

