/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.application.ModalityState;
import com.intellij.ui.SearchTextFieldWithStoredHistory;
import com.intellij.util.Alarm;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NonNls;

public abstract class FilterComponent
extends JPanel {
    private final SearchTextFieldWithStoredHistory myFilter;
    private final Alarm myUpdateAlarm = new Alarm();
    private final boolean myOnTheFly;

    public FilterComponent(@NonNls String propertyName, int historySize) {
        this(propertyName, historySize, true);
    }

    public FilterComponent(@NonNls String propertyName, int historySize, boolean onTheFlyUpdate) {
        super(new BorderLayout());
        this.myOnTheFly = onTheFlyUpdate;
        this.myFilter = new SearchTextFieldWithStoredHistory(propertyName){

            @Override
            protected Runnable createItemChosenCallback(JList list) {
                Runnable callback = super.createItemChosenCallback(list);
                return () -> {
                    callback.run();
                    FilterComponent.this.filter();
                };
            }

            @Override
            protected Component getPopupLocationComponent() {
                return FilterComponent.this.getPopupLocationComponent();
            }

            @Override
            protected void onFocusLost() {
                this.addCurrentTextToHistory();
                super.onFocusLost();
            }
        };
        this.myFilter.getTextEditor().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    e.consume();
                    FilterComponent.this.myFilter.addCurrentTextToHistory();
                    FilterComponent.this.filter();
                } else if (e.getKeyCode() == 27) {
                    FilterComponent.this.onEscape(e);
                }
            }
        });
        this.myFilter.addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                FilterComponent.this.onChange();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                FilterComponent.this.onChange();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                FilterComponent.this.onChange();
            }
        });
        this.myFilter.setHistorySize(historySize);
        this.add((Component)this.myFilter, "Center");
    }

    protected JComponent getPopupLocationComponent() {
        return this.myFilter;
    }

    public JTextField getTextEditor() {
        return this.myFilter.getTextEditor();
    }

    private void onChange() {
        if (this.myOnTheFly) {
            this.myUpdateAlarm.cancelAllRequests();
            this.myUpdateAlarm.addRequest(() -> this.onlineFilter(), 100, ModalityState.stateForComponent(this.myFilter));
        }
    }

    public void setHistorySize(int historySize) {
        this.myFilter.setHistorySize(historySize);
    }

    public void reset() {
        this.myFilter.reset();
    }

    protected void onEscape(KeyEvent e) {
    }

    public String getFilter() {
        return this.myFilter.getText();
    }

    public void setSelectedItem(String filter) {
        this.myFilter.setSelectedItem(filter);
    }

    public void setFilter(String filter) {
        this.myFilter.setText(filter);
    }

    public void selectText() {
        this.myFilter.selectText();
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.myFilter.requestFocusInWindow();
    }

    public abstract void filter();

    protected void onlineFilter() {
        this.filter();
    }

    public void dispose() {
        this.myUpdateAlarm.cancelAllRequests();
    }

    protected void setHistory(List<String> strings) {
        this.myFilter.setHistory(strings);
    }
}

