/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.ClassUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DomJavaUtil {
    private DomJavaUtil() {
    }

    @Nullable
    public static PsiClass findClass(@Nullable String name, @NotNull PsiFile file, @Nullable Module module, @Nullable GlobalSearchScope searchScope) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/xml/DomJavaUtil", "findClass"));
        }
        return DomJavaUtil.findClass(name, file, module, searchScope, false);
    }

    @Nullable
    public static PsiClass findClass(@Nullable String name, @NotNull PsiFile file, @Nullable Module module, @Nullable GlobalSearchScope searchScope, boolean searchAnonymous) {
        PsiClass aClass;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/xml/DomJavaUtil", "findClass"));
        }
        if (name == null) {
            return null;
        }
        GlobalSearchScope globalSearchScope = searchScope = searchScope != null ? searchScope : DomJavaUtil.calcScope(file, module);
        if (searchAnonymous) {
            aClass = ClassUtil.findPsiClass((PsiManager)file.getManager(), (String)name, null, (boolean)false, (GlobalSearchScope)searchScope);
        } else {
            String fqn = name.indexOf(36) >= 0 ? name.replace('$', '.') : name;
            aClass = JavaPsiFacade.getInstance((Project)file.getProject()).findClass(fqn, searchScope);
        }
        if (aClass != null) assert (aClass.isValid()) : name;
        return aClass;
    }

    @Nullable
    public static PsiClass findClass(@Nullable String name, @NotNull DomElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/xml/DomJavaUtil", "findClass"));
        }
        return DomJavaUtil.findClass(name, element, false);
    }

    @Nullable
    public static PsiClass findClass(@Nullable String name, @NotNull DomElement element, boolean searchAnonymous) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/xml/DomJavaUtil", "findClass"));
        }
        assert (element.isValid());
        if (DomUtil.hasXml(element)) {
            return DomJavaUtil.findClass(name, DomUtil.getFile(element), element.getModule(), element.getResolveScope(), searchAnonymous);
        }
        return null;
    }

    @NotNull
    private static GlobalSearchScope calcScope(@NotNull PsiFile file, @Nullable Module module) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/xml/DomJavaUtil", "calcScope"));
        }
        if (module == null) {
            GlobalSearchScope globalSearchScope = file.getResolveScope();
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/DomJavaUtil", "calcScope"));
            }
            return globalSearchScope;
        }
        VirtualFile virtualFile2 = (file = file.getOriginalFile()).getVirtualFile();
        if (virtualFile2 == null) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.moduleRuntimeScope(module, true);
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/DomJavaUtil", "calcScope"));
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = module.getModuleRuntimeScope(TestSourcesFilter.isTestSources(virtualFile2, file.getProject()));
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/DomJavaUtil", "calcScope"));
        }
        return globalSearchScope;
    }
}

