/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.common.artifact;

import com.microsoft.alm.common.artifact.ArtifactID;
import com.microsoft.alm.common.exceptions.MalformedArtifactIDException;
import com.microsoft.alm.common.exceptions.MalformedURIException;
import org.apache.commons.lang.StringUtils;

public class GitRefArtifactID
extends ArtifactID {
    private static final String GIT_TOOL = "Git";
    private static final String REF_ARTIFACT_TYPE = "Ref";
    private static final String GIT_BRANCH_IDENTIFIER = "GB";
    private String projectId;
    private String repoId;
    private String refName;

    public GitRefArtifactID(String uri) {
        super(uri);
        this.decodeGitRefToolSpecifiedId(this.toolSpecificId);
    }

    public GitRefArtifactID(String projectId, String repoId, String refName) {
        super(GIT_TOOL, REF_ARTIFACT_TYPE, projectId + "/" + repoId + "/" + GIT_BRANCH_IDENTIFIER + refName);
        this.projectId = projectId;
        this.repoId = repoId;
        this.refName = refName;
    }

    private void decodeGitRefToolSpecifiedId(String toolSpecifiedId) {
        if (StringUtils.isEmpty((String)toolSpecifiedId)) {
            throw new MalformedArtifactIDException(this);
        }
        String[] components = toolSpecifiedId.split("/");
        if (components.length < 3) {
            throw new MalformedURIException(String.format("The toolSpecifiedId was not able to be decoded: %s", toolSpecifiedId));
        }
        this.projectId = components[0];
        this.repoId = components[1];
        this.refName = components[2];
        if (components.length > 3) {
            for (int index = 3; index < components.length; ++index) {
                this.refName = this.refName + "/" + components[index];
            }
        }
        this.refName = this.decodeRefName(this.refName);
    }

    private String decodeRefName(String refName) {
        return refName.substring(2);
    }

    public String getRefName() {
        return this.refName;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getRepoId() {
        return this.repoId;
    }
}

