/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.common.utils;

import com.sun.jna.Platform;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.io.comparator.PathFileComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemHelper {
    private static Logger logger = LoggerFactory.getLogger(SystemHelper.class);
    private static final String COMPUTER_NAME = "computername";

    public static String getComputerName() {
        try {
            InetAddress localMachine = InetAddress.getLocalHost();
            return localMachine.getHostName();
        }
        catch (UnknownHostException e) {
            logger.warn("getComputerName failed", (Throwable)e);
            return System.getenv(COMPUTER_NAME);
        }
    }

    public static String getEnvironmentVariable(String name) {
        return System.getenv(name);
    }

    public static String getUnixPath(String path) {
        if (Platform.isWindows()) {
            return path.replace("\\", "/");
        }
        return path;
    }

    public static boolean areFilePathsSame(String path1, String path2) {
        return PathFileComparator.PATH_SYSTEM_COMPARATOR.compare(new File(path1), new File(path2)) == 0;
    }

    public static int toInt(String value, int defaultValue) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            logger.warn("Could not convert '" + value + "' into an integer.", (Throwable)e);
            return defaultValue;
        }
    }
}

