/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.common.utils;

import com.microsoft.alm.common.artifact.GitRefArtifactID;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlHelper {
    private static final Logger logger = LoggerFactory.getLogger(UrlHelper.class);
    public static final String URL_SEPARATOR = "/";
    public static final String SHORT_HTTP_LINK_FORMATTER = "<html><body><a href=\"%s\">%s</a></body></html>";
    public static final String HOST_VSO = "visualstudio.com";
    public static final String HOST_TFS_ALL_IN = "tfsallin.net";
    public static final String DEFAULT_COLLECTION = "DefaultCollection";
    private static final String URL_GIT_PATH_SEGMENT = "_git";
    private static final String URL_BUILD_PATH_SEGMENT = "_build";
    private static final String URL_BUILD_SPECIFIC_ITEM_PATH_SEGMENT = "?buildid=%d&_a=summary";
    private static final String URL_BUILD_ASPX_SEGMENT = "web/build.aspx?pcguid=%s";
    private static final String URL_BUILD_TEAM_PROJECT_SEGMENT = "&projectname=%s";
    private static final String URL_BUILD_DEFINITION_ID_SEGMENT = "&definitionid=%d";
    private static final String URL_BUILD_QUEUE_ACTION = "&action=queuebuild";
    private static final String URL_WIT_PATH_SEGMENT = "_workitems";
    private static final String URL_WIT_REF_SEGMENT = "_apis/wit/workItems";
    private static final String URL_OPTIMIZED_REF_PATH_SEGMENT = "_optimized";
    private static final String URL_FULL_REF_PATH_SEGMENT = "_full";
    private static final String URL_WIT_SPECIFIC_ITEM_PATH_SEGMENT = "?id=%d&_a=edit";
    private static final String URL_BRANCH_SEGMENT = "?path=%2F&_a=contents&version=GB";
    private static final String URL_COMMIT_SEGMENT = "commit";
    protected static final String URL_PATH_SEGMENT = "#path=";
    protected static final String URL_GIT_VERSION_SEGMENT = "&version=GB";
    protected static final String URL_TFVC_PATH_SEGMENT = "_versionControl";
    protected static final String URL_TFVC_CHANGESET_SEGMENT = "changeset";
    private static final String HTTP_PROTOCOL = "http";
    private static final String HTTPS_PROTOCOL = "https";
    private static final String DEFAULT_TEAM_SERVICES_LINK = "https://www.visualstudio.com/team-services/";

    public static URI createUri(String url) {
        return URI.create(UrlHelper.getCmdLineFriendlyUrl(url));
    }

    public static boolean isValidUrl(String serverUrl) {
        try {
            new URL(serverUrl);
            return true;
        }
        catch (MalformedURLException e) {
            logger.warn(serverUrl, (Throwable)e);
            return false;
        }
    }

    public static String asString(URI uri) {
        if (uri != null) {
            return uri.toString();
        }
        return null;
    }

    public static String trimTrailingSeparators(String uri) {
        if (StringUtils.isNotEmpty((String)uri)) {
            int lastIndex;
            for (lastIndex = uri.length(); lastIndex > 0 && uri.charAt(lastIndex - 1) == URL_SEPARATOR.charAt(0); --lastIndex) {
            }
            if (lastIndex >= 0) {
                return uri.substring(0, lastIndex);
            }
        }
        return uri;
    }

    public static String trimLeadingAndTrailingSeparators(String uri) {
        if (StringUtils.isNotEmpty((String)uri)) {
            int lastIndex;
            int startingIndex;
            for (startingIndex = 0; startingIndex < uri.length() && uri.charAt(startingIndex) == URL_SEPARATOR.charAt(0); ++startingIndex) {
            }
            for (lastIndex = uri.length(); lastIndex > 0 && uri.charAt(lastIndex - 1) == URL_SEPARATOR.charAt(0); --lastIndex) {
            }
            if (startingIndex < uri.length() && lastIndex >= 0 && startingIndex < lastIndex) {
                return uri.substring(startingIndex, lastIndex);
            }
            return "";
        }
        return uri;
    }

    public static boolean isVSO(URI uri) {
        String host;
        return uri != null && uri.getHost() != null && (StringUtils.endsWith((String)(host = uri.getHost().toLowerCase()), (String)HOST_VSO) || StringUtils.endsWith((String)host, (String)HOST_TFS_ALL_IN));
    }

    public static boolean isTeamServicesUrl(String url) {
        return StringUtils.containsIgnoreCase((String)url, (String)HOST_VSO) || StringUtils.containsIgnoreCase((String)url, (String)HOST_TFS_ALL_IN);
    }

    public static boolean isGitRemoteUrl(String gitRemoteUrl) {
        return StringUtils.contains((String)gitRemoteUrl, (String)"/_git/");
    }

    public static boolean isSshGitRemoteUrl(String gitRemoteUrl) {
        if (UrlHelper.isGitRemoteUrl(gitRemoteUrl) && UrlHelper.isTeamServicesUrl(gitRemoteUrl)) {
            if (StringUtils.startsWithIgnoreCase((String)gitRemoteUrl, (String)"https://") || StringUtils.startsWithIgnoreCase((String)gitRemoteUrl, (String)"http://")) {
                return false;
            }
            if (StringUtils.startsWithIgnoreCase((String)gitRemoteUrl, (String)"ssh://")) {
                return true;
            }
            if (StringUtils.contains((String)gitRemoteUrl, (String)"@")) {
                return true;
            }
        }
        return false;
    }

    public static String getHttpsUrlFromHttpUrl(String httpUrl) {
        URI uri = UrlHelper.createUri(httpUrl);
        String httpsUrl = httpUrl;
        if (uri != null && StringUtils.equalsIgnoreCase((String)uri.getScheme(), (String)HTTP_PROTOCOL)) {
            URI httpsUri = UrlHelper.createUri("https://" + uri.getAuthority() + uri.getPath());
            httpsUrl = httpsUri.toString();
        }
        if (StringUtils.startsWithIgnoreCase((String)httpsUrl, (String)"https://")) {
            return httpsUrl;
        }
        return null;
    }

    public static String getHttpsGitUrlFromSshUrl(String sshGitRemoteUrl) {
        if (UrlHelper.isSshGitRemoteUrl(sshGitRemoteUrl)) {
            URI sshUrl = !StringUtils.startsWithIgnoreCase((String)sshGitRemoteUrl, (String)"ssh://") ? UrlHelper.createUri("ssh://" + sshGitRemoteUrl) : UrlHelper.createUri(sshGitRemoteUrl);
            String host = sshUrl.getHost();
            String path = sshUrl.getPath();
            URI httpsUrl = UrlHelper.createUri("https://" + host + path);
            return httpsUrl.toString();
        }
        if (StringUtils.startsWithIgnoreCase((String)sshGitRemoteUrl, (String)HTTP_PROTOCOL) || StringUtils.startsWithIgnoreCase((String)sshGitRemoteUrl, (String)HTTPS_PROTOCOL)) {
            return sshGitRemoteUrl;
        }
        logger.warn("getHttpsGitUrlFromSshUrl: can't determine https url from " + sshGitRemoteUrl);
        return null;
    }

    public static String getCmdLineFriendlyUrl(String url) {
        return StringUtils.replace((String)url, (String)" ", (String)"%20");
    }

    public static URI getVSOAccountURI(String accountName) {
        return UrlHelper.createUri("https://" + accountName + "." + HOST_VSO);
    }

    public static URI getCollectionURI(URI serverUri, String collectionName) {
        if (UrlHelper.isVSO(serverUri) && UrlHelper.getVSOAccountURI(collectionName).equals(serverUri)) {
            return serverUri;
        }
        return UrlHelper.createUri(UrlHelper.combine(serverUri.toString(), collectionName));
    }

    public static URI getTeamProjectURI(URI serverUri, String collectionName, String teamProjectName) {
        return UrlHelper.createUri(UrlHelper.combine(UrlHelper.getCollectionURI(serverUri, collectionName).toString(), teamProjectName));
    }

    public static URI getBuildsPageURI(URI projectUri) {
        return UrlHelper.createUri(UrlHelper.combine(projectUri.toString(), URL_BUILD_PATH_SEGMENT));
    }

    public static URI getBuildURI(URI projectUri, int buildId) {
        return UrlHelper.createUri(UrlHelper.combine(projectUri.toString(), URL_BUILD_PATH_SEGMENT).concat(String.format(URL_BUILD_SPECIFIC_ITEM_PATH_SEGMENT, buildId)));
    }

    public static URI getQueueBuildURI(URI serverUri, String collectionId, String projectName, int buildDefinitionId) {
        return UrlHelper.createUri(UrlHelper.combine(serverUri.toString(), String.format(URL_BUILD_ASPX_SEGMENT, collectionId)).concat(String.format(URL_BUILD_TEAM_PROJECT_SEGMENT, UrlHelper.encode(projectName))).concat(String.format(URL_BUILD_DEFINITION_ID_SEGMENT, buildDefinitionId)).concat(URL_BUILD_QUEUE_ACTION));
    }

    public static URI getCreateWorkItemURI(URI projectUri) {
        return UrlHelper.createUri(UrlHelper.combine(projectUri.toString(), URL_WIT_PATH_SEGMENT));
    }

    public static URI getSpecificWorkItemURI(URI projectUri, int workItemId) {
        return UrlHelper.createUri(UrlHelper.combine(projectUri.toString(), URL_WIT_PATH_SEGMENT).concat(String.format(URL_WIT_SPECIFIC_ITEM_PATH_SEGMENT, workItemId)));
    }

    public static URI getWorkItemRefURI(URI teamProjectUri, String workItemId) {
        return UrlHelper.createUri(UrlHelper.combine(teamProjectUri.toString(), URL_WIT_REF_SEGMENT, workItemId));
    }

    public static URI getMyWorkItemsURI(URI projectUri) {
        return UrlHelper.createUri(UrlHelper.combine(projectUri.toString(), URL_WIT_PATH_SEGMENT));
    }

    public static URI getBranchURI(URI repoUri, String branchName) {
        return UrlHelper.createUri(repoUri.toString().concat(URL_BRANCH_SEGMENT).concat(UrlHelper.encode(branchName)));
    }

    public static URI getCommitURI(String remoteUrl, String commitId) {
        return UrlHelper.createUri(UrlHelper.combine(UrlHelper.getHttpsGitUrlFromSshUrl(remoteUrl), URL_COMMIT_SEGMENT, commitId));
    }

    public static URI getFileURI(String remoteUrl, String filePath, String gitRemoteBranchName) {
        String uri = UrlHelper.getHttpsGitUrlFromSshUrl(remoteUrl).concat(URL_PATH_SEGMENT).concat(filePath);
        if (uri == null) {
            return UrlHelper.createUri(DEFAULT_TEAM_SERVICES_LINK);
        }
        if (StringUtils.isNotEmpty((String)gitRemoteBranchName)) {
            uri = uri.concat(URL_GIT_VERSION_SEGMENT).concat(gitRemoteBranchName);
        }
        return UrlHelper.createUri(uri);
    }

    public static URI getTfvcChangesetURI(String remoteUrl, String changesetNumber) {
        return UrlHelper.createUri(UrlHelper.combine(UrlHelper.getHttpsGitUrlFromSshUrl(remoteUrl), URL_TFVC_PATH_SEGMENT, URL_TFVC_CHANGESET_SEGMENT, changesetNumber));
    }

    public static boolean haveSameAuthority(URI remoteUrl1, URI remoteUrl2) {
        if (remoteUrl1 != null && remoteUrl2 != null) {
            return StringUtils.equalsIgnoreCase((String)remoteUrl1.getAuthority(), (String)remoteUrl2.getAuthority());
        }
        return false;
    }

    public static String encode(String urlParameter) {
        try {
            return URLEncoder.encode(urlParameter, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String decode(String urlParameter) {
        try {
            return URLDecoder.decode(urlParameter, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String combine(String ... urlParts) {
        StringBuilder sb = new StringBuilder();
        if (urlParts != null) {
            for (String part : urlParts) {
                if (StringUtils.isEmpty((String)part)) continue;
                if (sb.length() > 0) {
                    sb.append(URL_SEPARATOR);
                }
                sb.append(UrlHelper.trimLeadingAndTrailingSeparators(part));
            }
        }
        return sb.toString();
    }

    public static String parseUriForBranch(String uri) {
        if (!StringUtils.isEmpty((String)uri)) {
            GitRefArtifactID artifactID = new GitRefArtifactID(uri);
            return artifactID.getRefName();
        }
        return "";
    }

    public static String getVSOAccountName(URI vsoUri) {
        String[] hostParts = vsoUri.getHost().split("\\.");
        String accountName = hostParts.length > 0 ? hostParts[0] : "";
        return accountName;
    }

    public static URI resolveEndpointUri(URI baseUri, String endpointPath) {
        if (!baseUri.getPath().endsWith(URL_SEPARATOR)) {
            baseUri = UrlHelper.createUri(baseUri.toString() + URL_SEPARATOR);
        }
        if (endpointPath.startsWith(URL_SEPARATOR)) {
            endpointPath = endpointPath.substring(1);
        }
        return baseUri.resolve(endpointPath);
    }

    public static ParseResult tryParse(String gitUrl, ParseResultValidator validator) {
        URI gitUri;
        if (StringUtils.isEmpty((String)gitUrl)) {
            return ParseResult.FAILED;
        }
        try {
            gitUri = UrlHelper.createUri(gitUrl);
        }
        catch (Throwable t) {
            logger.warn("tryParse: creating Uri failed for Git url: {}", (Object)gitUrl, (Object)t);
            return ParseResult.FAILED;
        }
        try {
            String scheme;
            String string = scheme = gitUri.getScheme() != null ? gitUri.getScheme().toLowerCase() : null;
            if (HTTPS_PROTOCOL.equals(scheme) || HTTP_PROTOCOL.equals(scheme)) {
                return HttpGitUrlParser.tryParse(gitUri, validator);
            }
        }
        catch (Throwable t) {
            logger.error("tryParse: unexpected error for gitUrl = " + gitUrl);
            logger.warn("tryParse", t);
        }
        return ParseResult.FAILED;
    }

    public static interface ParseResultValidator {
        public boolean validate(ParseResult var1);
    }

    private static class HttpGitUrlParser {
        private HttpGitUrlParser() {
        }

        private static ParseResult tryParse(URI gitUri, ParseResultValidator validator) {
            if (!UrlHelper.isValidUrl(gitUri.toString())) {
                return ParseResult.FAILED;
            }
            String[] pathSegments = HttpGitUrlParser.getPathSegments(gitUri);
            if (!HttpGitUrlParser.isPathSegmentValid(pathSegments)) {
                return ParseResult.FAILED;
            }
            ParseResult result = HttpGitUrlParser.buildParseResult(gitUri, pathSegments, false);
            if (validator.validate(result)) {
                return result;
            }
            ParseResult alternateResult = HttpGitUrlParser.buildParseResult(gitUri, pathSegments, true);
            if (validator.validate(alternateResult)) {
                return alternateResult;
            }
            return ParseResult.FAILED;
        }

        private static String[] getPathSegments(URI gitUri) {
            String gitUrlPath = gitUri.normalize().getPath().replaceAll("/$", "").replaceAll("^/", "");
            return gitUrlPath.split(UrlHelper.URL_SEPARATOR);
        }

        private static boolean isPathSegmentValid(String[] segments) {
            if (segments == null || segments.length < 3) {
                return false;
            }
            String secondToLastSegment = segments[segments.length - 2];
            if (UrlHelper.URL_GIT_PATH_SEGMENT.equals(secondToLastSegment)) {
                return true;
            }
            String thirdToLastSegment = segments[segments.length - 3];
            return UrlHelper.URL_GIT_PATH_SEGMENT.equals(thirdToLastSegment) && (UrlHelper.URL_OPTIMIZED_REF_PATH_SEGMENT.equals(secondToLastSegment) || UrlHelper.URL_FULL_REF_PATH_SEGMENT.equals(secondToLastSegment));
        }

        private static int getGitPathSegmentPosition(String[] segments) {
            String secondToLastSegment = segments[segments.length - 2];
            if (UrlHelper.URL_GIT_PATH_SEGMENT.equals(secondToLastSegment)) {
                return segments.length - 2;
            }
            String thirdToLastSegment = segments[segments.length - 3];
            if (UrlHelper.URL_GIT_PATH_SEGMENT.equals(thirdToLastSegment)) {
                return segments.length - 3;
            }
            return -1;
        }

        private static ParseResult buildParseResult(URI gitUri, String[] pathSegments, boolean explicitProjectName) {
            String accountName = UrlHelper.getVSOAccountName(gitUri);
            StringBuilder urlBuilder = new StringBuilder(gitUri.getScheme()).append("://").append(gitUri.getAuthority()).append(UrlHelper.URL_SEPARATOR);
            int gitSegmentPos = HttpGitUrlParser.getGitPathSegmentPosition(pathSegments);
            int collectionSegmentPos = explicitProjectName ? gitSegmentPos - 2 : gitSegmentPos - 1;
            for (int i = 0; i < collectionSegmentPos; ++i) {
                urlBuilder.append(pathSegments[i]).append(UrlHelper.URL_SEPARATOR);
            }
            String serverUrl = urlBuilder.toString();
            String collectionName = pathSegments[collectionSegmentPos];
            urlBuilder.append(collectionName).append(UrlHelper.URL_SEPARATOR);
            String collectionUrl = urlBuilder.toString();
            int size = pathSegments.length;
            String repositoryName = pathSegments[size - 1];
            String projectName = explicitProjectName ? pathSegments[collectionSegmentPos + 1] : repositoryName;
            return new ParseResult(serverUrl, collectionUrl, collectionName, projectName, repositoryName, accountName);
        }
    }

    public static class ParseResult {
        public static final ParseResult FAILED = new ParseResult(null, null, null, null, null, null);
        private final String accountName;
        private final String serverUrl;
        private final String collectionUrl;
        private final String collectionName;
        private final String projectName;
        private final String repoName;

        public ParseResult(String serverUrl, String collectionUrl, String collectionName, String projectName, String repoName, String accountName) {
            this.serverUrl = serverUrl;
            this.collectionUrl = collectionUrl;
            this.collectionName = collectionName;
            this.projectName = projectName;
            this.repoName = repoName;
            this.accountName = accountName;
        }

        public boolean isSuccess() {
            return this != FAILED;
        }

        public boolean isVSO() {
            return UrlHelper.isVSO(UrlHelper.createUri(this.serverUrl));
        }

        public String getServerUrl() {
            return this.serverUrl;
        }

        public String getCollectionUrl() {
            return this.collectionUrl;
        }

        public String getCollectionName() {
            return this.collectionName;
        }

        public String getProjectName() {
            return this.projectName;
        }

        public String getRepoName() {
            return this.repoName;
        }

        public String getAccountName() {
            return this.accountName;
        }

        public String toString() {
            return "ServerUrl = " + this.serverUrl + " " + "CollectionUrl = " + this.collectionUrl + " " + "CollectionName = " + this.collectionName + " " + "ProjectName = " + this.projectName + " " + "RepoName = " + this.repoName + " " + "AccountName = " + this.accountName;
        }
    }
}

