/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework.util;

import com.intellij.javascript.testFramework.jasmine.JasmineFileStructure;
import com.intellij.javascript.testFramework.jasmine.JasmineFileStructureBuilder;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSTestFileType;
import com.intellij.psi.PsiElement;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsTestFqn {
    private final JSTestFileType myType;
    private final List<String> myNames;

    public JsTestFqn(@NotNull JSTestFileType type, @NotNull List<String> names) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/javascript/testFramework/util/JsTestFqn", "<init>"));
        }
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/javascript/testFramework/util/JsTestFqn", "<init>"));
        }
        this.myType = type;
        this.myNames = names;
    }

    @NotNull
    public String getPresentableName() {
        String string = JsTestFqn.getPresentableName(this.myNames);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/util/JsTestFqn", "getPresentableName"));
        }
        return string;
    }

    @Nullable
    public PsiElement findNavigationElement(@NotNull JSFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javascript/testFramework/util/JsTestFqn", "findNavigationElement"));
        }
        if (this.myType == JSTestFileType.JASMINE) {
            JasmineFileStructure jasmineFileStructure = JasmineFileStructureBuilder.getInstance().buildTestFileStructure(file);
            return jasmineFileStructure.findPsiElement(this.myNames, null);
        }
        return null;
    }

    @NotNull
    public JSTestFileType getType() {
        JSTestFileType jSTestFileType = this.myType;
        if (jSTestFileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/util/JsTestFqn", "getType"));
        }
        return jSTestFileType;
    }

    @NotNull
    public List<String> getNames() {
        List<String> list = this.myNames;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/util/JsTestFqn", "getNames"));
        }
        return list;
    }

    @NotNull
    public static String getPresentableName(@NotNull List<String> names) {
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/javascript/testFramework/util/JsTestFqn", "getPresentableName"));
        }
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (String name : names) {
            if (!first && !name.startsWith(".")) {
                result.append(".");
            }
            first = false;
            result.append(name);
        }
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/util/JsTestFqn", "getPresentableName"));
        }
        return string;
    }
}

