/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.debugger.wip;

import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.javascript.debugger.ConsoleMessage;
import com.intellij.javascript.debugger.ConsolePrinter;
import com.jetbrains.debugger.wip.WipConsoleAPICalledKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.wip.protocol.runtime.CallFrameValue;
import org.jetbrains.wip.protocol.runtime.ExceptionDetailsValue;
import org.jetbrains.wip.protocol.runtime.ExceptionThrownEventData;
import org.jetbrains.wip.protocol.runtime.StackTraceValue;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lcom/jetbrains/debugger/wip/WipExceptionThrown;", "Lcom/intellij/javascript/debugger/ConsoleMessage;", "message", "Lorg/jetbrains/wip/protocol/runtime/ExceptionThrownEventData;", "(Lorg/jetbrains/wip/protocol/runtime/ExceptionThrownEventData;)V", "getMessage", "()Lorg/jetbrains/wip/protocol/runtime/ExceptionThrownEventData;", "print", "", "consoleView", "Lcom/intellij/execution/ui/ConsoleView;", "printer", "Lcom/intellij/javascript/debugger/ConsolePrinter;", "ChromeConnector"})
public final class WipExceptionThrown
implements ConsoleMessage {
    @NotNull
    private final ExceptionThrownEventData message;

    public void print(@NotNull ConsoleView consoleView, @NotNull ConsolePrinter printer) {
        Intrinsics.checkParameterIsNotNull((Object)consoleView, (String)"consoleView");
        Intrinsics.checkParameterIsNotNull((Object)printer, (String)"printer");
        ExceptionDetailsValue details = this.message.exceptionDetails();
        String string = details.text();
        ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.ERROR_OUTPUT;
        Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType, (String)"ConsoleViewContentType.ERROR_OUTPUT");
        printer.append(string, consoleViewContentType);
        Object object = details.getException();
        if (object != null && (object = object.getDescription()) != null) {
            String string2;
            Object object2 = object;
            String it = (String)object2;
            int newLinePos = StringsKt.indexOf$default((CharSequence)it, (char)'\n', (int)0, (boolean)false, (int)6, null);
            if (newLinePos == -1) {
                string2 = it;
            } else {
                String string3 = it;
                int n = 0;
                String string4 = string3;
                if (string4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string5 = string4.substring(n, newLinePos);
                string2 = string5;
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            }
            String errorText = string2;
            char c = ' ';
            ConsolePrinter consolePrinter = printer;
            String string6 = String.valueOf(c) + errorText;
            ConsoleViewContentType consoleViewContentType2 = ConsoleViewContentType.ERROR_OUTPUT;
            Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType2, (String)"ConsoleViewContentType.ERROR_OUTPUT");
            consolePrinter.append(string6, consoleViewContentType2);
        }
        StackTraceValue stackTraceValue = details.getStackTrace();
        List<CallFrameValue> callFrames = stackTraceValue != null ? stackTraceValue.callFrames() : null;
        String url = details.getUrl();
        if (url != null) {
            List<CallFrameValue> list = callFrames;
            CallFrameValue callFrame = list != null ? (CallFrameValue)CollectionsKt.firstOrNull(list) : null;
            CallFrameValue callFrameValue = callFrame;
            printer.addFileLink(url, details.getLineNumber(), details.getColumnNumber(), callFrameValue != null ? callFrameValue.functionName() : null, true);
        }
        printer.newLine();
        ConsoleViewContentType consoleViewContentType3 = ConsoleViewContentType.ERROR_OUTPUT;
        Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType3, (String)"ConsoleViewContentType.ERROR_OUTPUT");
        WipConsoleAPICalledKt.printStackTrace(consoleView, printer, consoleViewContentType3, callFrames);
    }

    @NotNull
    public final ExceptionThrownEventData getMessage() {
        return this.message;
    }

    public WipExceptionThrown(@NotNull ExceptionThrownEventData message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        this.message = message;
    }
}

