/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.debugger.wip;

import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.javascript.debugger.ConsoleMessage;
import com.intellij.javascript.debugger.ConsolePrinter;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.debugger.wip.WipConsoleAPICalledKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.wip.RequestInfo;
import org.jetbrains.wip.protocol.log.LogEntryValue;
import org.jetbrains.wip.protocol.network.InitiatorValue;
import org.jetbrains.wip.protocol.runtime.CallFrameValue;
import org.jetbrains.wip.protocol.runtime.StackTraceValue;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/debugger/wip/WipLogEntry;", "Lcom/intellij/javascript/debugger/ConsoleMessage;", "message", "Lorg/jetbrains/wip/protocol/log/LogEntryValue;", "request", "Lorg/jetbrains/wip/RequestInfo;", "(Lorg/jetbrains/wip/protocol/log/LogEntryValue;Lorg/jetbrains/wip/RequestInfo;)V", "print", "", "consoleView", "Lcom/intellij/execution/ui/ConsoleView;", "printer", "Lcom/intellij/javascript/debugger/ConsolePrinter;", "printFailedNetworkRequestMessage", "ChromeConnector"})
public final class WipLogEntry
implements ConsoleMessage {
    private final LogEntryValue message;
    private final RequestInfo request;

    public void print(@NotNull ConsoleView consoleView, @NotNull ConsolePrinter printer) {
        Intrinsics.checkParameterIsNotNull((Object)consoleView, (String)"consoleView");
        Intrinsics.checkParameterIsNotNull((Object)printer, (String)"printer");
        String url = this.message.getUrl();
        int line = this.message.getLineNumber();
        StackTraceValue stackTraceValue = this.message.getStackTrace();
        List<CallFrameValue> stackTrace = stackTraceValue != null ? stackTraceValue.callFrames() : null;
        boolean isFromNetwork = Intrinsics.areEqual((Object)((Object)this.message.source()), (Object)((Object)LogEntryValue.Source.NETWORK));
        if (isFromNetwork) {
            if (this.request == null) {
                ConsolePrinter.append$default((ConsolePrinter)printer, (String)this.message.text(), null, (int)2, null);
                String string = this.message.getUrl();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                printer.addFileLink(string, -1, -1, null, false);
            } else {
                if (this.request.getInitiator() != null) {
                    InitiatorValue initiatorValue = this.request.getInitiator();
                    if (initiatorValue == null) {
                        Intrinsics.throwNpe();
                    }
                    StackTraceValue stackTraceValue2 = initiatorValue.getStack();
                    stackTrace = stackTraceValue2 != null ? stackTraceValue2.callFrames() : null;
                    InitiatorValue initiatorValue2 = this.request.getInitiator();
                    if (initiatorValue2 == null) {
                        Intrinsics.throwNpe();
                    }
                    if (!StringUtil.isEmpty((String)initiatorValue2.getUrl())) {
                        InitiatorValue initiatorValue3 = this.request.getInitiator();
                        if (initiatorValue3 == null) {
                            Intrinsics.throwNpe();
                        }
                        url = initiatorValue3.getUrl();
                        InitiatorValue initiatorValue4 = this.request.getInitiator();
                        if (initiatorValue4 == null) {
                            Intrinsics.throwNpe();
                        }
                        line = (int)initiatorValue4.getLineNumber();
                    }
                }
                if (Intrinsics.areEqual((Object)((Object)this.message.level()), (Object)((Object)LogEntryValue.Level.ERROR))) {
                    this.printFailedNetworkRequestMessage(printer);
                } else {
                    ConsolePrinter.append$default((ConsolePrinter)printer, (String)this.message.text(), null, (int)2, null);
                }
            }
        } else {
            ConsolePrinter.append$default((ConsolePrinter)printer, (String)this.message.text(), null, (int)2, null);
        }
        if (!isFromNetwork || this.request != null) {
            CharSequence charSequence;
            CallFrameValue callFrame;
            List<CallFrameValue> list = stackTrace;
            CallFrameValue callFrameValue = callFrame = list != null ? (CallFrameValue)CollectionsKt.firstOrNull(list) : null;
            if (callFrame != null && !((charSequence = (CharSequence)callFrame.url()) == null || charSequence.length() == 0) && Intrinsics.areEqual((Object)callFrame.url(), (Object)"undefined") ^ true) {
                printer.addFileLink(callFrame.url(), callFrame.getLineNumber(), callFrame.getColumnNumber(), callFrame.functionName(), !isFromNetwork);
            } else {
                charSequence = url;
                if (!(charSequence == null || charSequence.length() == 0) && Intrinsics.areEqual((Object)url, (Object)"undefined") ^ true) {
                    String string = url;
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    printer.addFileLink(string, line - 1, 0, null, !isFromNetwork);
                }
            }
        }
        printer.newLine();
        if (isFromNetwork || Intrinsics.areEqual((Object)((Object)this.message.level()), (Object)((Object)LogEntryValue.Level.ERROR))) {
            ConsoleViewContentType contentType;
            ConsoleViewContentType consoleViewContentType = contentType = Intrinsics.areEqual((Object)((Object)this.message.level()), (Object)((Object)LogEntryValue.Level.ERROR)) ? ConsoleViewContentType.ERROR_OUTPUT : ConsoleViewContentType.NORMAL_OUTPUT;
            Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType, (String)"contentType");
            WipConsoleAPICalledKt.printStackTrace(consoleView, printer, consoleViewContentType, stackTrace);
        }
    }

    private final void printFailedNetworkRequestMessage(ConsolePrinter printer) {
        RequestInfo requestInfo = this.request;
        if (requestInfo == null) {
            Intrinsics.throwNpe();
        }
        printer.appendError(requestInfo.getValue().method());
        printer.appendError(" ");
        printer.printBrowserLink(this.request.getValue().url());
        printer.appendError(" ");
        if (this.request.isFailed()) {
            String string = this.request.getFailDescription();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            printer.appendError(string);
        } else {
            printer.appendError(String.valueOf(this.request.getStatusCode()));
            if (!StringUtil.isEmpty((String)this.request.getStatusText())) {
                printer.appendError(" (");
                String string = this.request.getStatusText();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                printer.appendError(string);
                printer.appendError(")");
            }
        }
    }

    public WipLogEntry(@NotNull LogEntryValue message, @Nullable RequestInfo request) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        this.message = message;
        this.request = request;
    }
}

