/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.reactnative;

import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configuration.EnvironmentVariablesTextFieldWithBrowseButton;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageField;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.textCompletion.TextCompletionProvider;
import com.intellij.util.textCompletion.TextFieldWithCompletion;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.RadioButtonEnumModel;
import com.jetbrains.plugins.reactnative.ReactNativeConfigurationEditorKt;
import com.jetbrains.plugins.reactnative.ReactNativePlatform;
import com.jetbrains.plugins.reactnative.ReactNativeRunConfiguration;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0002H\u0014J\b\u0010\u001a\u001a\u00020\u001bH\u0014J\u0010\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0002H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/plugins/reactnative/ReactNativeConfigurationEditor;", "Lcom/intellij/openapi/options/SettingsEditor;", "Lcom/jetbrains/plugins/reactnative/ReactNativeRunConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "envVarsComponent", "Lcom/intellij/execution/configuration/EnvironmentVariablesTextFieldWithBrowseButton;", "nodeInterpreterField", "Lcom/intellij/javascript/nodejs/interpreter/NodeJsInterpreterField;", "onlyStartPackager", "Lcom/intellij/ui/components/JBCheckBox;", "platformModel", "Lcom/intellij/util/ui/RadioButtonEnumModel;", "Lcom/jetbrains/plugins/reactnative/ReactNativePlatform;", "platformPanel", "Ljavax/swing/JPanel;", "reactNativeField", "Lcom/intellij/javascript/nodejs/util/NodePackageField;", "runArgumentsField", "Lcom/intellij/util/textCompletion/TextFieldWithCompletion;", "workingDirField", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "applyEditorTo", "", "s", "createEditor", "Ljavax/swing/JComponent;", "resetEditorFrom", "ChromeConnector"})
public final class ReactNativeConfigurationEditor
extends SettingsEditor<ReactNativeRunConfiguration> {
    private final NodePackageField reactNativeField;
    private final NodeJsInterpreterField nodeInterpreterField;
    private final TextFieldWithBrowseButton workingDirField;
    private final JBCheckBox onlyStartPackager;
    private final JPanel platformPanel;
    private final RadioButtonEnumModel<ReactNativePlatform> platformModel;
    private final TextFieldWithCompletion runArgumentsField;
    private final EnvironmentVariablesTextFieldWithBrowseButton envVarsComponent;

    protected void resetEditorFrom(@NotNull ReactNativeRunConfiguration s) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)s), (String)"s");
        this.nodeInterpreterField.setInterpreterRef(s.getNodePath());
        NodePackage sPackage = s.getReactNativePackage();
        if (sPackage != null) {
            this.reactNativeField.setSelected(sPackage);
        } else {
            NodePackage defaultPackage = NodePackage.findDefaultPackage((Project)s.getProject(), (String)ReactNativeConfigurationEditorKt.access$getREACT_NATIVE_PACKAGE_NAME$p(), (NodeJsInterpreter)this.nodeInterpreterField.getInterpreter());
            if (defaultPackage != null) {
                this.reactNativeField.setSelected(defaultPackage);
            }
        }
        this.workingDirField.setText(s.getEffectiveWorkingDirectory());
        this.onlyStartPackager.setSelected(s.getOnlyStartPackager());
        this.platformModel.setSelected((Enum)s.getPlatform());
        this.runArgumentsField.setText(s.getRunArguments());
        this.envVarsComponent.setData(s.getEnvData());
    }

    protected void applyEditorTo(@NotNull ReactNativeRunConfiguration s) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)((Object)s), (String)"s");
        s.setReactNativePackage(this.reactNativeField.getSelected());
        NodeJsInterpreterRef nodeJsInterpreterRef = this.nodeInterpreterField.getInterpreterRef();
        Intrinsics.checkExpressionValueIsNotNull((Object)nodeJsInterpreterRef, (String)"nodeInterpreterField.interpreterRef");
        s.setNodePath(nodeJsInterpreterRef);
        if (Intrinsics.areEqual((Object)this.workingDirField.getText(), (Object)s.findWorkingDirectory())) {
            string = "";
        } else {
            String string2 = this.workingDirField.getText();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"workingDirField.text");
        }
        s.setWorkingDirectory(string);
        s.setOnlyStartPackager(this.onlyStartPackager.isSelected());
        Enum enum_ = this.platformModel.getSelected();
        Intrinsics.checkExpressionValueIsNotNull((Object)enum_, (String)"platformModel.selected");
        s.setPlatform((ReactNativePlatform)enum_);
        String string3 = this.runArgumentsField.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"runArgumentsField.text");
        s.setRunArguments(string3);
        EnvironmentVariablesData environmentVariablesData = this.envVarsComponent.getData();
        Intrinsics.checkExpressionValueIsNotNull((Object)environmentVariablesData, (String)"envVarsComponent.data");
        s.setEnvData(environmentVariablesData);
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = FormBuilder.createFormBuilder().addLabeledComponent("Node &interpreter:", (JComponent)this.nodeInterpreterField).addLabeledComponent("&React Native package:", (JComponent)this.reactNativeField).addLabeledComponent("&Working directory:", (JComponent)this.workingDirField).addComponent((JComponent)this.onlyStartPackager).addLabeledComponent("Target platform:", (JComponent)this.platformPanel).addLabeledComponent("Run arguments:", (JComponent)this.runArgumentsField).addLabeledComponent("Environment:", (JComponent)this.envVarsComponent).getPanel();
        Intrinsics.checkExpressionValueIsNotNull((Object)jPanel, (String)"FormBuilder.createFormBu\u2026Component)\n        .panel");
        return jPanel;
    }

    /*
     * WARNING - void declaration
     */
    public ReactNativeConfigurationEditor(@NotNull Project project) {
        void $receiver$iv$iv;
        Object[] $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.nodeInterpreterField = new NodeJsInterpreterField(project, false);
        this.workingDirField = new TextFieldWithBrowseButton();
        this.onlyStartPackager = new JBCheckBox("Only start packager");
        this.platformPanel = new JPanel(new FlowLayout(3, 0, 0));
        this.envVarsComponent = new EnvironmentVariablesTextFieldWithBrowseButton();
        this.reactNativeField = new NodePackageField(project, ReactNativeConfigurationEditorKt.access$getREACT_NATIVE_PACKAGE_NAME$p(), (Supplier)new Supplier<NodeJsInterpreter>(){

            @Override
            @Nullable
            public final NodeJsInterpreter get() {
                return nodeInterpreterField.getInterpreter();
            }
        });
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        this.workingDirField.addBrowseFolderListener(null, null, project, descriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
        FileChooserFactory.getInstance().installFileCompletion(this.workingDirField.getTextField(), descriptor, false, (Disposable)this.workingDirField);
        Object[] objectArray = $receiver$iv = (Object[])ReactNativePlatform.values();
        Collection destination$iv$iv = new ArrayList($receiver$iv.length);
        for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
            void it;
            void item$iv$iv = $receiver$iv$iv[i];
            ReactNativePlatform reactNativePlatform = (ReactNativePlatform)item$iv$iv;
            Collection collection = destination$iv$iv;
            JRadioButton button = new JRadioButton(it.getReadableName());
            button.setMargin(new Insets(0, 0, 0, 20));
            JRadioButton jRadioButton = button;
            collection.add(jRadioButton);
        }
        List buttons = (List)destination$iv$iv;
        ButtonGroup buttonGroup = new ButtonGroup();
        Iterable $receiver$iv2 = buttons;
        for (Object element$iv : $receiver$iv2) {
            JRadioButton it = (JRadioButton)element$iv;
            buttonGroup.add(it);
            this.platformPanel.add(it);
        }
        RadioButtonEnumModel radioButtonEnumModel = RadioButtonEnumModel.bindEnum(ReactNativePlatform.class, (ButtonGroup)buttonGroup);
        Intrinsics.checkExpressionValueIsNotNull((Object)radioButtonEnumModel, (String)"RadioButtonEnumModel.bin\u2026:class.java, buttonGroup)");
        this.platformModel = radioButtonEnumModel;
        final TextFieldWithAutoCompletion.StringsCompletionProvider provider = new TextFieldWithAutoCompletion.StringsCompletionProvider((Collection)ReactNativePlatform.values()[0].getPossibleArguments(), null);
        this.runArgumentsField = new TextFieldWithCompletion(project, (TextCompletionProvider)provider, "", true, false, false);
        this.platformModel.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent e) {
                provider.setItems((Collection)((ReactNativePlatform)platformModel.getSelected()).getPossibleArguments());
            }
        });
    }
}

