/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.v8;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.io.PathKt;
import io.netty.buffer.ByteBuf;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.DebugEventListener;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.EvaluateResult;
import org.jetbrains.debugger.ExceptionCatchMode;
import org.jetbrains.debugger.ValueModifier;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.VmBase;
import org.jetbrains.debugger.values.ValueType;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.rpc.CommandProcessorKt;
import org.jetbrains.v8.BreakEventHandlerKt;
import org.jetbrains.v8.EventMap;
import org.jetbrains.v8.V8BreakpointManager;
import org.jetbrains.v8.V8CommandProcessor;
import org.jetbrains.v8.V8EvaluateContext;
import org.jetbrains.v8.V8ScriptManager;
import org.jetbrains.v8.V8SuspendContextManager;
import org.jetbrains.v8.V8VersionFeatures;
import org.jetbrains.v8.V8Vm;
import org.jetbrains.v8.V8VmKt;
import org.jetbrains.v8.protocol.FrameInfo;
import org.jetbrains.v8.protocol.GetFramesResult;
import org.jetbrains.v8.protocol.GetScriptsResult;
import org.jetbrains.v8.protocol.IncomingMessage;
import org.jetbrains.v8.protocol.OriginalProtocolKt;
import org.jetbrains.v8.protocol.ProtocolKt;
import org.jetbrains.v8.protocol.ScriptDescriptor;
import org.jetbrains.v8.protocol.ScriptHandle;
import org.jetbrains.v8.protocol.ScriptsMessageKt;
import org.jetbrains.v8.protocol.SomeHandle;
import org.jetbrains.v8.value.V8ValueManager;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010?\u001a\u0004\u0018\u00010@2\u0006\u0010A\u001a\u00020@J\n\u0010B\u001a\u0004\u0018\u00010CH\u0004J\u0012\u0010D\u001a\u0006\u0012\u0002\b\u00030E2\u0006\u0010F\u001a\u00020GJ\u0018\u0010H\u001a\u00020I2\u000e\u0010J\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00000)H\u0014J\u0010\u0010K\u001a\u00020\u00072\u0006\u0010L\u001a\u00020MH$R&\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00078\u0006@@X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u00020\u00148\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0015\u0010\u0010\u001a\u0004\b\u0016\u0010\u0017R \u0010\u0018\u001a\u0004\u0018\u00010\u00198\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR&\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00078\u0006@BX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\n\"\u0004\b \u0010\fR\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R&\u0010&\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00078\u0006@BX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\n\"\u0004\b'\u0010\fR\u0019\u0010(\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010*0)\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u001c\u0010-\u001a\u0004\u0018\u00010\u0019X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010\u001b\"\u0004\b/\u0010\u001dR\u001c\u00100\u001a\u0002018\u0016X\u0097\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b2\u0010\u0010\u001a\u0004\b3\u00104R\u001c\u00105\u001a\u0002068\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b7\u0010\u0010\u001a\u0004\b8\u00109R\u000e\u0010:\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010<\u001a\u0004\u0018\u00010\u00192\b\u0010;\u001a\u0004\u0018\u00010\u00198\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010\u001b\"\u0004\b>\u0010\u001d\u00a8\u0006N"}, d2={"Lorg/jetbrains/v8/V8Vm;", "Lorg/jetbrains/debugger/VmBase;", "Lorg/jetbrains/debugger/Vm;", "debugEventListener", "Lorg/jetbrains/debugger/DebugEventListener;", "(Lorg/jetbrains/debugger/DebugEventListener;)V", "<set-?>", "", "bootstrapped", "getBootstrapped", "()Z", "setBootstrapped$v8_backend", "(Z)V", "breakpointManager", "Lorg/jetbrains/v8/V8BreakpointManager;", "breakpointManager$annotations", "()V", "getBreakpointManager", "()Lorg/jetbrains/v8/V8BreakpointManager;", "commandProcessor", "Lorg/jetbrains/v8/V8CommandProcessor;", "commandProcessor$annotations", "getCommandProcessor", "()Lorg/jetbrains/v8/V8CommandProcessor;", "embeddingHost", "", "getEmbeddingHost", "()Ljava/lang/String;", "setEmbeddingHost", "(Ljava/lang/String;)V", "hasJbDebuggerSupport", "getHasJbDebuggerSupport", "setHasJbDebuggerSupport", "initialBreakEvent", "Ljava/util/concurrent/atomic/AtomicReference;", "Lorg/jetbrains/v8/protocol/IncomingMessage;", "getInitialBreakEvent$v8_backend", "()Ljava/util/concurrent/atomic/AtomicReference;", "isAbleToReportSourceMapUrl", "setAbleToReportSourceMapUrl", "jbDebuggerSupportInstalled", "Lorg/jetbrains/concurrency/AsyncPromise;", "", "getJbDebuggerSupportInstalled", "()Lorg/jetbrains/concurrency/AsyncPromise;", "name", "getName", "setName", "scriptManager", "Lorg/jetbrains/v8/V8ScriptManager;", "scriptManager$annotations", "getScriptManager", "()Lorg/jetbrains/v8/V8ScriptManager;", "suspendContextManager", "Lorg/jetbrains/v8/V8SuspendContextManager;", "suspendContextManager$annotations", "getSuspendContextManager", "()Lorg/jetbrains/v8/V8SuspendContextManager;", "valueModificationSupported", "value", "vmVersion", "getVmVersion", "setVmVersion", "checkValueModifier", "Lorg/jetbrains/debugger/ValueModifier;", "valueModifier", "computeEvaluateContext", "Lorg/jetbrains/debugger/EvaluateContext;", "setBreakOnException", "Lorg/jetbrains/concurrency/Promise;", "catchMode", "Lorg/jetbrains/debugger/ExceptionCatchMode;", "startCommunication", "", "vmResult", "write", "content", "Lio/netty/buffer/ByteBuf;", "v8-backend"})
public abstract class V8Vm
extends VmBase
implements Vm {
    @Nullable
    private String name;
    @NotNull
    private final V8ScriptManager scriptManager;
    @NotNull
    private final V8CommandProcessor commandProcessor;
    @NotNull
    private final V8SuspendContextManager suspendContextManager;
    @NotNull
    private final V8BreakpointManager breakpointManager;
    @Nullable
    private volatile String vmVersion;
    @Nullable
    private volatile String embeddingHost;
    private boolean valueModificationSupported;
    private volatile boolean hasJbDebuggerSupport;
    private volatile boolean bootstrapped;
    private volatile boolean isAbleToReportSourceMapUrl;
    @NotNull
    private final AsyncPromise<Object> jbDebuggerSupportInstalled;
    @NotNull
    private final AtomicReference<IncomingMessage> initialBreakEvent;

    @Nullable
    public String getName() {
        return this.name;
    }

    public void setName(@Nullable String string) {
        this.name = string;
    }

    private static /* synthetic */ void scriptManager$annotations() {
    }

    @NotNull
    public V8ScriptManager getScriptManager() {
        return this.scriptManager;
    }

    private static /* synthetic */ void commandProcessor$annotations() {
    }

    @NotNull
    public final V8CommandProcessor getCommandProcessor() {
        return this.commandProcessor;
    }

    private static /* synthetic */ void suspendContextManager$annotations() {
    }

    @NotNull
    public final V8SuspendContextManager getSuspendContextManager() {
        return this.suspendContextManager;
    }

    private static /* synthetic */ void breakpointManager$annotations() {
    }

    @NotNull
    public final V8BreakpointManager getBreakpointManager() {
        return this.breakpointManager;
    }

    @Nullable
    public final String getVmVersion() {
        return this.vmVersion;
    }

    public final void setVmVersion(@Nullable String value) {
        this.vmVersion = value;
        this.valueModificationSupported = StringUtil.compareVersionNumbers((String)this.vmVersion, (String)"3.16") >= 0;
        this.breakpointManager.setRegExpBreakpointSupported(V8VersionFeatures.isRegExpBreakpointSupported(this.vmVersion));
    }

    @Nullable
    public final String getEmbeddingHost() {
        return this.embeddingHost;
    }

    public final void setEmbeddingHost(@Nullable String string) {
        this.embeddingHost = string;
    }

    public final boolean getHasJbDebuggerSupport() {
        return this.hasJbDebuggerSupport;
    }

    private final void setHasJbDebuggerSupport(boolean bl) {
        this.hasJbDebuggerSupport = bl;
    }

    public final boolean getBootstrapped() {
        return this.bootstrapped;
    }

    public final void setBootstrapped$v8_backend(boolean bl) {
        this.bootstrapped = bl;
    }

    public final boolean isAbleToReportSourceMapUrl() {
        return this.isAbleToReportSourceMapUrl;
    }

    private final void setAbleToReportSourceMapUrl(boolean bl) {
        this.isAbleToReportSourceMapUrl = bl;
    }

    @NotNull
    public final AsyncPromise<Object> getJbDebuggerSupportInstalled() {
        return this.jbDebuggerSupportInstalled;
    }

    protected abstract boolean write(@NotNull ByteBuf var1);

    @NotNull
    public final Promise<?> setBreakOnException(@NotNull ExceptionCatchMode catchMode) {
        Intrinsics.checkParameterIsNotNull((Object)catchMode, (String)"catchMode");
        return this.breakpointManager.setBreakOnException(catchMode);
    }

    @NotNull
    public final AtomicReference<IncomingMessage> getInitialBreakEvent$v8_backend() {
        return this.initialBreakEvent;
    }

    protected void startCommunication(@NotNull AsyncPromise<? super V8Vm> vmResult) {
        Intrinsics.checkParameterIsNotNull(vmResult, (String)"vmResult");
        if (Intrinsics.areEqual((Object)this.embeddingHost, (Object)"Electron") ^ true && Registry.is((String)"nodejs.debugger.use.jb.support", (boolean)true)) {
            String debuggerSupport;
            if (Intrinsics.areEqual((Object)"jar", (Object)V8Vm.class.getResource("").getProtocol())) {
                String string = V8VmKt.access$getSCRIPT_DEBUGGER_SUPPORT_SOURCE$p();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"SCRIPT_DEBUGGER_SUPPORT_SOURCE");
                debuggerSupport = string;
            } else {
                debuggerSupport = PathKt.readText((Path)Paths.get(PathManager.getPreInstalledPluginsPath(), "JavaScriptDebugger/sdk/v8/backend/src/debuggerSupport.js"));
                debuggerSupport = "try {" + debuggerSupport + "} catch (e) {throw new Error(e.stack)}";
            }
            EvaluateContext evaluateContext2 = this.getEvaluateContext();
            if (evaluateContext2 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)EvaluateContext.DefaultImpls.evaluate$default((EvaluateContext)evaluateContext2, (String)debuggerSupport, null, (boolean)false, (int)6, null).done((Consumer)new Consumer<EvaluateResult>(this, vmResult){
                final /* synthetic */ V8Vm this$0;
                final /* synthetic */ AsyncPromise $vmResult;

                public final void consume(EvaluateResult it) {
                    AsyncPromise<Object> $receiver$iv = this.this$0.getJbDebuggerSupportInstalled();
                    try {
                        if (it.getWasThrown()) {
                            StringBuilder stringBuilder = new StringBuilder().append("Cannot install our debugger support: ");
                            String string = it.getValue().getValueString();
                            if (string == null) {
                                string = it;
                            }
                            String message = stringBuilder.append((Object)string).toString();
                            CommandProcessorKt.getLOG().info(message);
                            this.$vmResult.setResult((Object)((Object)this.this$0));
                            this.this$0.getJbDebuggerSupportInstalled().setError(message);
                        } else {
                            Object object;
                            V8Vm.access$setHasJbDebuggerSupport$p(this.this$0, true);
                            if (Intrinsics.areEqual((Object)it.getValue().getType(), (Object)ValueType.STRING) && (object = it.getValue().getValueString()) != null && (object = StringsKt.split$default((CharSequence)((CharSequence)object), (char[])new char[]{'|'}, (boolean)false, (int)0, (int)6, null)) != null) {
                                Object object2 = object;
                                List it2 = (List)object2;
                                V8Vm.access$setAbleToReportSourceMapUrl$p(this.this$0, Intrinsics.areEqual((Object)((String)CollectionsKt.getOrNull((List)it2, (int)0)), (Object)"true"));
                                this.this$0.setName(V8VmKt.computeName(it2, 1));
                            }
                            this.$vmResult.setResult((Object)((Object)this.this$0));
                            this.this$0.getJbDebuggerSupportInstalled().setResult(null);
                        }
                    }
                    catch (Throwable e$iv) {
                        $receiver$iv.setError(e$iv);
                    }
                }
                {
                    this.this$0 = v8Vm;
                    this.$vmResult = asyncPromise;
                }
            }).rejected((Consumer)new Consumer<Throwable>(this, vmResult){
                final /* synthetic */ V8Vm this$0;
                final /* synthetic */ AsyncPromise $vmResult;

                public final void consume(Throwable it) {
                    CommandProcessorKt.getLOG().info("Cannot install our debugger support", it);
                    this.$vmResult.setResult((Object)((Object)this.this$0));
                    AsyncPromise<Object> asyncPromise = this.this$0.getJbDebuggerSupportInstalled();
                    Throwable throwable = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"it");
                    asyncPromise.setError(throwable);
                }
                {
                    this.this$0 = v8Vm;
                    this.$vmResult = asyncPromise;
                }
            }), (String)"evaluateContext!!.evalua\u2026ed.setError(it)\n        }");
        } else {
            vmResult.setResult((Object)this);
            this.jbDebuggerSupportInstalled.setResult(null);
        }
        this.jbDebuggerSupportInstalled.processed((Consumer)new Consumer<Object>(this){
            final /* synthetic */ V8Vm this$0;

            public final void consume(@Nullable Object it) {
                Promise promise2 = this.this$0.getHasJbDebuggerSupport() ? this.this$0.getCommandProcessor().send((Request)ProtocolKt.GetScripts$default(null, 1, null)).then((Function)new Function<T, SUB_RESULT>(this){
                    final /* synthetic */ startCommunication.3 this$0;

                    public final void fun(GetScriptsResult it) {
                        Iterable $receiver$iv = it.scripts();
                        for (T element$iv : $receiver$iv) {
                            ScriptDescriptor it2 = (ScriptDescriptor)element$iv;
                            this.this$0.this$0.getScriptManager().addScript(it2);
                        }
                    }
                    {
                        this.this$0 = var1_1;
                    }
                }) : this.this$0.getCommandProcessor().send((Request)ScriptsMessageKt.ScriptsMessage$default(false, 0, 0, null, null, 31, null)).then((Function)new Function<T, SUB_RESULT>(this){
                    final /* synthetic */ startCommunication.3 this$0;

                    public final void fun(List<? extends ScriptHandle> it) {
                        List<SomeHandle> refs = ((IncomingMessage)this.this$0.this$0.getCommandProcessor().lastSuccessResponse().getBase()).refs();
                        for (ScriptHandle scriptHandle : it) {
                            this.this$0.this$0.getScriptManager().addScript(scriptHandle, refs);
                        }
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
                promise2.done((Consumer)new Consumer<Unit>(this){
                    final /* synthetic */ startCommunication.3 this$0;

                    public final void consume(Unit it) {
                        IncomingMessage breakEvent = this.this$0.this$0.getInitialBreakEvent$v8_backend().getAndSet(null);
                        this.this$0.this$0.setBootstrapped$v8_backend(true);
                        if (breakEvent != null) {
                            BreakEventHandlerKt.processBreak(breakEvent, this.this$0.this$0);
                        } else if (V8VersionFeatures.isRunningAccurate(this.this$0.this$0.getVmVersion()) && !this.this$0.this$0.getCommandProcessor().lastSuccessResponse().running() && this.this$0.this$0.getSuspendContextManager().getContext() == null) {
                            if (this.this$0.this$0.getHasJbDebuggerSupport()) {
                                Intrinsics.checkExpressionValueIsNotNull((Object)this.this$0.this$0.getCommandProcessor().send((Request)ProtocolKt.GetFrames(0, 1)).done((Consumer)new Consumer<GetFramesResult>(this){
                                    final /* synthetic */ startCommunication.1 this$0;

                                    public final void consume(GetFramesResult it) {
                                        if (this.this$0.this$0.this$0.getSuspendContextManager().getContext() == null) {
                                            V8SuspendContextManager v8SuspendContextManager = this.this$0.this$0.this$0.getSuspendContextManager();
                                            GetFramesResult getFramesResult = it;
                                            Intrinsics.checkExpressionValueIsNotNull((Object)getFramesResult, (String)"it");
                                            v8SuspendContextManager.createAndSetContextIfNotExists(getFramesResult, false);
                                        }
                                    }
                                    {
                                        this.this$0 = var1_1;
                                    }
                                }), (String)"commandProcessor.send(Ge\u2026      }\n                }");
                            } else {
                                Intrinsics.checkExpressionValueIsNotNull((Object)this.this$0.this$0.getCommandProcessor().send((Request)OriginalProtocolKt.FrameMessage()).done((Consumer)new Consumer<FrameInfo>(this){
                                    final /* synthetic */ startCommunication.1 this$0;

                                    public final void consume(FrameInfo it) {
                                        if (this.this$0.this$0.this$0.getSuspendContextManager().getContext() == null) {
                                            V8SuspendContextManager v8SuspendContextManager = this.this$0.this$0.this$0.getSuspendContextManager();
                                            FrameInfo frameInfo = it;
                                            Intrinsics.checkExpressionValueIsNotNull((Object)frameInfo, (String)"it");
                                            v8SuspendContextManager.createAndSetContextIfNotExists(frameInfo, false);
                                        }
                                    }
                                    {
                                        this.this$0 = var1_1;
                                    }
                                }), (String)"commandProcessor.send(Fr\u2026      }\n                }");
                            }
                        }
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = v8Vm;
            }
        });
    }

    @Nullable
    public final ValueModifier checkValueModifier(@NotNull ValueModifier valueModifier) {
        Intrinsics.checkParameterIsNotNull((Object)valueModifier, (String)"valueModifier");
        return this.valueModificationSupported ? valueModifier : null;
    }

    @Nullable
    protected final EvaluateContext computeEvaluateContext() {
        return (EvaluateContext)new V8EvaluateContext(this, new V8ValueManager(this)){
            private final int frameIndex = -1;
            final /* synthetic */ V8Vm this$0;

            protected int getFrameIndex() {
                return this.frameIndex;
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1);
                this.frameIndex = -1;
            }
        };
    }

    public V8Vm(@NotNull DebugEventListener debugEventListener) {
        Intrinsics.checkParameterIsNotNull((Object)debugEventListener, (String)"debugEventListener");
        super(debugEventListener);
        this.scriptManager = new V8ScriptManager(this);
        this.commandProcessor = new V8CommandProcessor((Function1<? super ByteBuf, Boolean>)((Function1)new Function1<ByteBuf, Boolean>(this){
            final /* synthetic */ V8Vm this$0;

            public final boolean invoke(@NotNull ByteBuf it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return this.this$0.write(it);
            }
            {
                this.this$0 = v8Vm;
                super(1);
            }
        }), new EventMap(this));
        this.suspendContextManager = new V8SuspendContextManager(this);
        this.breakpointManager = new V8BreakpointManager(this);
        this.jbDebuggerSupportInstalled = new AsyncPromise();
        this.initialBreakEvent = new AtomicReference();
    }

    public static final /* synthetic */ boolean access$getHasJbDebuggerSupport$p(V8Vm $this) {
        return $this.hasJbDebuggerSupport;
    }

    public static final /* synthetic */ void access$setHasJbDebuggerSupport$p(V8Vm $this, boolean bl) {
        $this.hasJbDebuggerSupport = bl;
    }

    public static final /* synthetic */ boolean access$isAbleToReportSourceMapUrl$p(V8Vm $this) {
        return $this.isAbleToReportSourceMapUrl;
    }

    public static final /* synthetic */ void access$setAbleToReportSourceMapUrl$p(V8Vm $this, boolean bl) {
        $this.isAbleToReportSourceMapUrl = bl;
    }
}

