/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.authentication;

import com.google.common.util.concurrent.SettableFuture;
import com.microsoft.alm.client.model.VssServiceResponseException;
import com.microsoft.alm.common.utils.SystemHelper;
import com.microsoft.alm.plugin.authentication.AuthTypes;
import com.microsoft.alm.plugin.authentication.AuthenticationInfo;
import com.microsoft.alm.plugin.authentication.AuthenticationListener;
import com.microsoft.alm.plugin.authentication.AuthenticationProvider;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.services.PluginServiceProvider;
import java.util.Date;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.ws.rs.NotAuthorizedException;
import org.apache.commons.lang.StringUtils;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthHelper {
    private static final Logger logger = LoggerFactory.getLogger(AuthHelper.class);
    private static String DEVICE_FLOW_PROPERTY = "userAgentProvider";
    private static String ENABLE_DEVICE_FLOW_VALUE = "none";
    private static final String TOKEN_DESCRIPTION_FORMATTER = "VSTS IntelliJ Plugin: %s from: %s on: %s";

    public static AuthenticationInfo createAuthenticationInfo(String serverUri, Credentials credentials, AuthenticationInfo.CredsType type) {
        return new AuthenticationInfo(credentials.getUserPrincipal().getName(), credentials.getPassword(), serverUri, credentials.getUserPrincipal().getName(), type, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AuthenticationInfo getAuthenticationInfoSynchronously(AuthenticationProvider provider, String gitRemoteUrl) {
        logger.info("getAuthenticationInfoSynchronously calling authenticateAsync on " + gitRemoteUrl);
        final SettableFuture future = SettableFuture.create();
        provider.authenticateAsync(gitRemoteUrl, new AuthenticationListener(){

            @Override
            public void authenticating() {
            }

            @Override
            public void authenticated(AuthenticationInfo authenticationInfo, Throwable throwable) {
                if (throwable != null) {
                    future.setException(throwable);
                } else {
                    future.set((Object)authenticationInfo);
                }
            }
        });
        Exception t = null;
        try {
            AuthenticationInfo authenticationInfo = (AuthenticationInfo)future.get(15L, TimeUnit.MINUTES);
            return authenticationInfo;
        }
        catch (InterruptedException ie) {
            t = ie;
        }
        catch (ExecutionException ee) {
            t = ee;
        }
        catch (TimeoutException te) {
            t = te;
        }
        finally {
            if (t != null) {
                logger.error("getAuthenticationInfoSynchronously: failed to get authentication info from user");
                logger.warn("getAuthenticationInfoSynchronously", (Throwable)t);
            }
        }
        return null;
    }

    public static Credentials getCredentials(ServerContext.Type type, AuthenticationInfo authenticationInfo) {
        if (type == ServerContext.Type.TFS) {
            return AuthHelper.getNTCredentials(authenticationInfo.getUserName(), authenticationInfo.getPassword());
        }
        return new UsernamePasswordCredentials(authenticationInfo.getUserName(), authenticationInfo.getPassword());
    }

    public static NTCredentials getNTCredentials(String userName, String password) {
        String[] parts;
        assert (userName != null);
        assert (password != null);
        String user = userName;
        String domain = "";
        String workstation = SystemHelper.getComputerName();
        if (userName.contains("\\")) {
            String[] parts2 = userName.split("[\\\\]");
            if (parts2.length == 2) {
                domain = parts2[0];
                user = parts2[1];
            }
        } else if (userName.contains("/")) {
            String[] parts3 = userName.split("[/]");
            if (parts3.length == 2) {
                domain = parts3[0];
                user = parts3[1];
            }
        } else if (userName.contains("@") && (parts = userName.split("[@]")).length == 2) {
            user = parts[0];
            domain = parts[1];
        }
        return new NTCredentials(user, password, workstation, domain);
    }

    public static String getTokenDescription(String emailAddress) {
        String tokenDescription = String.format(TOKEN_DESCRIPTION_FORMATTER, emailAddress, SystemHelper.getComputerName(), new Date().toString());
        return tokenDescription;
    }

    public static boolean isNotAuthorizedError(Throwable throwable) {
        if (throwable != null && (throwable instanceof NotAuthorizedException || throwable instanceof VssServiceResponseException && StringUtils.containsIgnoreCase((String)throwable.getMessage(), (String)"unauthorized"))) {
            return true;
        }
        return throwable != null && throwable.getCause() != null && (throwable.getCause() instanceof NotAuthorizedException || throwable.getCause() instanceof VssServiceResponseException && StringUtils.containsIgnoreCase((String)throwable.getMessage(), (String)"unauthorized"));
    }

    public static void setDeviceFlowEnvFromSettingsFile() {
        String savedAuthMethod = AuthHelper.getAuthTypeInSettingsFile();
        if (StringUtils.isEmpty((String)savedAuthMethod)) {
            return;
        }
        if (AuthTypes.DEVICE_FLOW == AuthTypes.getEnum(savedAuthMethod.toUpperCase())) {
            AuthHelper.setDeviceFlowEnvVariableTrue();
        } else {
            AuthHelper.setDeviceFlowEnvVariableFalse();
        }
    }

    public static boolean isAuthTypeFromSettingsFileSet() {
        return StringUtils.isNotEmpty((String)AuthHelper.getAuthTypeInSettingsFile());
    }

    public static String getAuthTypeInSettingsFile() {
        return PluginServiceProvider.getInstance().getPropertyService().getProperty("authType");
    }

    public static void setAuthTypeInSettingsFile(AuthTypes authType) {
        if (authType != null) {
            PluginServiceProvider.getInstance().getPropertyService().setProperty("authType", authType.name().toUpperCase());
        }
    }

    public static void setDeviceFlowEnvVariableTrue() {
        AuthHelper.setDeviceFlowEnvVariable(ENABLE_DEVICE_FLOW_VALUE);
    }

    public static void setDeviceFlowEnvVariableFalse() {
        AuthHelper.setDeviceFlowEnvVariable("");
    }

    private static void setDeviceFlowEnvVariable(String value) {
        System.setProperty(DEVICE_FLOW_PROPERTY, value);
    }

    public static boolean isDeviceFlowEnvSetTrue() {
        String property = System.getProperty(DEVICE_FLOW_PROPERTY, "");
        return StringUtils.isNotEmpty((String)property) && StringUtils.equals((String)ENABLE_DEVICE_FLOW_VALUE, (String)property);
    }
}

