/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.authentication;

import com.microsoft.alm.plugin.authentication.AuthHelper;
import com.microsoft.alm.plugin.authentication.AuthenticationInfo;
import com.microsoft.alm.plugin.authentication.AuthenticationListener;
import com.microsoft.alm.plugin.authentication.AuthenticationProvider;
import com.microsoft.alm.plugin.context.ServerContextManager;
import com.microsoft.alm.plugin.context.rest.VstsHttpClient;
import com.microsoft.alm.plugin.services.CredentialsPrompt;
import com.microsoft.alm.plugin.services.PluginServiceProvider;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.impl.auth.win.CurrentWindowsCredentials;
import org.apache.http.impl.client.WinHttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TfsAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger logger = LoggerFactory.getLogger(TfsAuthenticationProvider.class);
    private static final String USER_NAME = "user.name";
    public static final String TFS_LAST_USED_URL = "http://_TFS_LAST_USED_URL_";

    private TfsAuthenticationProvider() {
    }

    public static TfsAuthenticationProvider getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public AuthenticationInfo getAuthenticationInfo(String ignored) {
        return ServerContextManager.getInstance().getBestAuthenticationInfo(TFS_LAST_USED_URL, false);
    }

    @Override
    public void authenticateAsync(String serverUrl, AuthenticationListener listener) {
        logger.info("starting TfsAuthenticator");
        TfsAuthenticator authenticator = new TfsAuthenticator(serverUrl, listener);
        authenticator.start();
    }

    @Override
    public void clearAuthenticationDetails(String ignored) {
        ServerContextManager.getInstance().remove(TFS_LAST_USED_URL);
    }

    @Override
    public boolean isAuthenticated(String serverUri) {
        return this.getAuthenticationInfo(serverUri) != null;
    }

    private static class TfsAuthenticator
    extends Thread {
        private final String serverUrl;
        private final AuthenticationListener listener;

        public TfsAuthenticator(String serverUrl, AuthenticationListener listener) {
            this.serverUrl = serverUrl;
            this.listener = listener;
        }

        @Override
        public void run() {
            logger.info("Async authentication starting");
            AuthenticationListener.Helper.authenticating(this.listener);
            try {
                URI uRI = new URI(this.serverUrl);
            }
            catch (URISyntaxException e) {
                AuthenticationListener.Helper.authenticated(this.listener, null, e);
                return;
            }
            AuthenticationInfo newAuthenticationInfo = null;
            boolean result = false;
            RuntimeException error = null;
            for (int retry = 0; retry < 4; ++retry) {
                Credentials credentials = this.getCredentials(this.serverUrl);
                if (credentials == null) {
                    result = false;
                    break;
                }
                try {
                    newAuthenticationInfo = AuthHelper.createAuthenticationInfo(this.serverUrl, credentials, AuthenticationInfo.CredsType.NTLM);
                    CredentialsPrompt prompt = PluginServiceProvider.getInstance().getCredentialsPrompt();
                    String authenticatedUrl = prompt.validateCredentials(this.serverUrl, newAuthenticationInfo);
                    newAuthenticationInfo = AuthHelper.createAuthenticationInfo(authenticatedUrl, credentials, AuthenticationInfo.CredsType.NTLM);
                    result = true;
                    break;
                }
                catch (RuntimeException ex) {
                    VstsHttpClient.VstsHttpClientException responseException;
                    if (ex.getCause() != null && ex.getCause() instanceof VstsHttpClient.VstsHttpClientException && (responseException = (VstsHttpClient.VstsHttpClientException)((Object)ex.getCause())).getStatusCode() == 401) continue;
                    error = ex;
                    result = false;
                    break;
                }
            }
            logger.info("Async authentication done - result: " + result);
            if (!result) {
                TfsAuthenticationProvider.getInstance().clearAuthenticationDetails(TfsAuthenticationProvider.TFS_LAST_USED_URL);
                AuthenticationListener.Helper.authenticated(this.listener, null, error);
            } else {
                AuthenticationListener.Helper.authenticated(this.listener, newAuthenticationInfo, null);
            }
        }

        private Credentials getCredentials(String serverUrl) {
            NTCredentials credentials;
            CredentialsPrompt prompt;
            String userName = System.getProperty(TfsAuthenticationProvider.USER_NAME);
            if (this.isNtlmEnabled()) {
                userName = CurrentWindowsCredentials.getCurrentUsername();
            }
            if ((prompt = PluginServiceProvider.getInstance().getCredentialsPrompt()).prompt(serverUrl, userName)) {
                userName = prompt.getUserName();
                String password = prompt.getPassword();
                credentials = AuthHelper.getNTCredentials(userName, password);
            } else {
                credentials = null;
            }
            return credentials;
        }

        private boolean isNtlmEnabled() {
            String propertyNtlmEnabled = System.getProperty("ntlmEnabled");
            boolean isNtlmEnabled = propertyNtlmEnabled == null || Boolean.parseBoolean(propertyNtlmEnabled);
            return isNtlmEnabled && WinHttpClients.isWinAuthAvailable();
        }
    }

    private static class Holder {
        private static final TfsAuthenticationProvider INSTANCE = new TfsAuthenticationProvider();

        private Holder() {
        }
    }
}

