/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.context;

public class RepositoryContext {
    private final String localRootFolder;
    private final Type type;
    private final String name;
    private final String branch;
    private final String url;
    private final String teamProjectName;

    public static RepositoryContext createGitContext(String localRootFolder, String repoName, String currentBranch, String remoteUrl) {
        return new RepositoryContext(localRootFolder, Type.GIT, repoName, currentBranch, remoteUrl, null);
    }

    public static RepositoryContext createTfvcContext(String localRootFolder, String workspaceName, String teamProjectName, String serverUrl) {
        return new RepositoryContext(localRootFolder, Type.TFVC, workspaceName, null, serverUrl, teamProjectName);
    }

    private RepositoryContext(String localRootFolder, Type type, String name, String branch, String url, String teamProjectName) {
        this.localRootFolder = localRootFolder;
        this.type = type;
        this.name = name;
        this.branch = branch;
        this.url = url;
        this.teamProjectName = teamProjectName;
    }

    public String getLocalRootFolder() {
        return this.localRootFolder;
    }

    public Type getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getBranch() {
        return this.branch;
    }

    public String getUrl() {
        return this.url;
    }

    public String getTeamProjectName() {
        return this.teamProjectName;
    }

    public static enum Type {
        GIT,
        TFVC;

    }
}

