/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.context;

import com.microsoft.alm.common.utils.ArgumentHelper;
import com.microsoft.alm.common.utils.UrlHelper;
import com.microsoft.alm.core.webapi.model.TeamProjectCollectionReference;
import com.microsoft.alm.core.webapi.model.TeamProjectReference;
import com.microsoft.alm.plugin.authentication.AuthenticationInfo;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.sourcecontrol.webapi.model.GitRepository;
import com.microsoft.visualstudio.services.account.Account;
import java.net.URI;
import java.util.UUID;
import javax.ws.rs.client.Client;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerContextBuilder {
    private static final Logger logger = LoggerFactory.getLogger(ServerContextBuilder.class);
    private ServerContext.Type type;
    private AuthenticationInfo authenticationInfo;
    private UUID userId;
    private URI uri;
    private URI serverUri;
    private TeamProjectCollectionReference teamProjectCollectionReference;
    private TeamProjectReference teamProjectReference;
    private GitRepository gitRepository;
    private Client client;

    public ServerContextBuilder() {
    }

    public ServerContextBuilder(ServerContext originalContext) {
        ArgumentHelper.checkNotNull((Object)originalContext, (String)"originalContext");
        this.type = originalContext.getType();
        this.uri = originalContext.getUri();
        this.serverUri = originalContext.getServerUri();
        this.teamProjectCollectionReference = originalContext.getTeamProjectCollectionReference();
        this.teamProject(originalContext.getTeamProjectReference());
        this.gitRepository = originalContext.getGitRepository();
        this.authenticationInfo = originalContext.getAuthenticationInfo();
        this.userId = originalContext.getUserId();
        this.client = originalContext.hasClient() ? originalContext.getClient() : null;
    }

    public ServerContextBuilder type(ServerContext.Type newType) {
        this.type = newType;
        return this;
    }

    public ServerContextBuilder uri(URI newUri) {
        this.uri = newUri;
        if (!UrlHelper.isGitRemoteUrl((String)newUri.toString())) {
            this.serverUri = this.uri;
        }
        return this;
    }

    public ServerContextBuilder uri(String newUri) {
        this.uri = UrlHelper.createUri((String)newUri);
        if (!UrlHelper.isGitRemoteUrl((String)newUri)) {
            this.serverUri = this.uri;
        }
        return this;
    }

    public ServerContextBuilder serverUri(String serverUri) {
        if (!StringUtils.isEmpty((String)serverUri)) {
            this.serverUri = UrlHelper.createUri((String)serverUri);
        }
        return this;
    }

    public ServerContextBuilder serverUri(URI serverUri) {
        this.serverUri = serverUri;
        return this;
    }

    public ServerContextBuilder accountUri(Account account) {
        this.serverUri = this.uri = UrlHelper.getVSOAccountURI((String)account.getAccountName());
        return this;
    }

    public ServerContextBuilder authentication(AuthenticationInfo authenticationInfo) {
        this.authenticationInfo = authenticationInfo;
        this.client = null;
        return this;
    }

    public ServerContextBuilder userId(UUID userId) {
        this.userId = userId;
        return this;
    }

    public ServerContextBuilder userId(String userId) {
        try {
            this.userId = UUID.fromString(userId);
        }
        catch (Throwable t) {
            logger.warn("userId: is an invalid UUID", t);
            this.userId = null;
        }
        return this;
    }

    public ServerContextBuilder collection(TeamProjectCollectionReference teamProjectCollection) {
        this.teamProjectCollectionReference = teamProjectCollection;
        return this;
    }

    public ServerContextBuilder teamProject(TeamProjectReference teamProject) {
        this.teamProjectReference = teamProject;
        return this;
    }

    public ServerContextBuilder teamProject(String teamProjectName) {
        this.teamProjectReference = new TeamProjectReference();
        this.teamProjectReference.setName(teamProjectName);
        return this;
    }

    public ServerContextBuilder repository(GitRepository repository) {
        this.gitRepository = repository;
        if (this.gitRepository != null && this.teamProjectReference == null) {
            this.teamProjectReference = this.gitRepository.getProjectReference();
        }
        return this;
    }

    public ServerContext build() {
        return this.buildWithClient(this.client);
    }

    protected ServerContext buildWithClient(Client client) {
        ServerContext serverContext = new ServerContext(this.type, this.authenticationInfo, this.userId, this.uri, this.serverUri, client, this.teamProjectCollectionReference, this.teamProjectReference, this.gitRepository);
        return serverContext;
    }
}

