/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.context.rest;

import com.microsoft.alm.client.model.VssException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VstsHttpClient {
    public static final Logger logger = LoggerFactory.getLogger(VstsHttpClient.class);

    public static <TResult> TResult sendRequest(Client client, String uri, Class<TResult> resultClass) {
        WebTarget t = client.target(uri);
        Invocation.Builder b = t.request();
        Response r = b.get();
        if (r.getStatus() == 200) {
            return (TResult)r.readEntity(resultClass);
        }
        logger.warn("sendRequest error: " + r.getStatus() + " : " + r.getStatusInfo().getReasonPhrase());
        throw new VstsHttpClientException(r.getStatus(), r.getStatusInfo().getReasonPhrase(), null);
    }

    public static class VstsHttpClientException
    extends VssException {
        final int statusCode;

        public VstsHttpClientException(int statusCode, String message, Exception innerException) {
            super(message, innerException);
            this.statusCode = statusCode;
        }

        public int getStatusCode() {
            return this.statusCode;
        }
    }
}

