/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.context.soap;

import com.microsoft.alm.client.model.VssServiceException;
import com.microsoft.alm.common.utils.ArgumentHelper;
import com.microsoft.alm.common.utils.UrlHelper;
import com.microsoft.alm.core.webapi.model.TeamProjectCollectionReference;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.context.soap.CatalogService;
import com.microsoft.alm.plugin.exceptions.TeamServicesException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.zip.GZIPInputStream;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatalogServiceImpl
implements CatalogService {
    private static final Logger logger = LoggerFactory.getLogger(CatalogServiceImpl.class);
    private final ServerContext context;
    private final URI endpointUri;
    private static final String SOAP = "http://www.w3.org/2003/05/soap-envelope";
    private static final String ENDPOINT_PATH = "/TeamFoundation/Administration/v3.0/CatalogService.asmx";
    private static final int QUERY_OPTIONS_NONE = 0;
    private static final int QUERY_OPTIONS_EXPAND_DEPENDENCIES = 1;
    private static final String SINGLE_RECURSE_STAR = "*";
    private static final String QUERY_NODE_RESPONSE = "QueryNodesResponse";
    public static final String ORGANIZATIONAL_ROOT = "69A51C5E-C093-447e-A177-A09E47A60974";
    public static final String TEAM_FOUNDATION_SERVER_INSTANCE = "b36f1bda-df2d-482b-993a-f194a31a1fa2";
    public static final String PROJECT_COLLECTION = "26338D9E-D437-44aa-91F2-55880A328B54";
    private static final XMLInputFactory XML_INPUT_FACTORY = XMLInputFactory.newInstance();

    public CatalogServiceImpl(ServerContext context) {
        ArgumentHelper.checkNotNull((Object)context, (String)"context");
        this.context = context;
        URI baseURI = context.getServerUri();
        this.endpointUri = UrlHelper.resolveEndpointUri((URI)baseURI, (String)ENDPOINT_PATH);
    }

    @Override
    public List<TeamProjectCollectionReference> getProjectCollections() {
        QueryData queryForOrganizationRoot = new QueryData(SINGLE_RECURSE_STAR, 0, ORGANIZATIONAL_ROOT);
        CatalogData catalogDataOrganizationRoot = this.getCatalogDataFromServer(queryForOrganizationRoot);
        if (catalogDataOrganizationRoot == null) {
            logger.warn("getProjectCollections catalogDataOrganizationRoot is null");
            throw new TeamServicesException(TeamServicesException.KEY_TFS_AUTH_FAILED);
        }
        CatalogResource organizationRoot = (CatalogResource)catalogDataOrganizationRoot.catalogResources.get(0);
        QueryData queryForFoundationServer = new QueryData(organizationRoot.nodeReferencePaths[0] + SINGLE_RECURSE_STAR, 1, TEAM_FOUNDATION_SERVER_INSTANCE);
        CatalogData catalogDataFoundationServer = this.getCatalogDataFromServer(queryForFoundationServer);
        CatalogResource foundationServer = (CatalogResource)catalogDataFoundationServer.catalogResources.get(0);
        QueryData queryForProjectCollections = new QueryData(foundationServer.nodeReferencePaths[0] + SINGLE_RECURSE_STAR, 1, PROJECT_COLLECTION);
        CatalogData catalogDataProjectCollections = this.getCatalogDataFromServer(queryForProjectCollections);
        ArrayList<TeamProjectCollectionReference> projectCollections = new ArrayList<TeamProjectCollectionReference>(catalogDataProjectCollections.catalogResources.size());
        for (CatalogResource catalogResource : catalogDataProjectCollections.catalogResources) {
            TeamProjectCollectionReference collectionReference = new TeamProjectCollectionReference();
            collectionReference.setId(UUID.fromString(catalogResource.instanceId));
            collectionReference.setName(catalogResource.displayName);
            String collectionPath = "_apis/projectCollections/" + catalogResource.instanceId;
            URI collectionUri = UrlHelper.resolveEndpointUri((URI)this.context.getUri(), (String)collectionPath);
            collectionReference.setUrl(collectionUri.toString());
            projectCollections.add(collectionReference);
        }
        return projectCollections;
    }

    @Override
    public TeamProjectCollectionReference getProjectCollection(String collectionName) {
        List<TeamProjectCollectionReference> collections = this.getProjectCollections();
        for (TeamProjectCollectionReference collection : collections) {
            if (!StringUtils.equalsIgnoreCase((String)collection.getName().replace(" ", "%20"), (String)collectionName)) continue;
            return collection;
        }
        throw new VssServiceException(TeamServicesException.KEY_OPERATION_ERRORS);
    }

    protected HttpResponse executeRequest(HttpPost httpPost) throws IOException {
        if (this.context.getHttpClient() == null) {
            logger.warn("context.getHttpClient() is null");
            throw new IllegalArgumentException("context");
        }
        return this.context.getHttpClient().execute((HttpUriRequest)httpPost);
    }

    private CatalogData getCatalogDataFromServer(QueryData queryData) {
        HttpPost httpPost = new HttpPost(this.endpointUri.toString());
        httpPost.setEntity((HttpEntity)CatalogServiceImpl.generateSoapQuery(queryData.pathSpecs, queryData.queryOptions));
        httpPost.addHeader((Header)new BasicHeader("Accept-Encoding", "gzip"));
        httpPost.addHeader((Header)new BasicHeader("Accept-Language", CatalogServiceImpl.localeToRFC5646LanguageTag(Locale.getDefault())));
        httpPost.addHeader((Header)new BasicHeader("Content-Type", "application/soap+xml; charset=utf-8"));
        try {
            HttpResponse httpResponse = this.executeRequest(httpPost);
            int responseStatusCode = httpResponse.getStatusLine().getStatusCode();
            if (responseStatusCode != 200) {
                throw new HttpResponseException(responseStatusCode, httpResponse.getStatusLine().toString());
            }
            CatalogData catalogData = new CatalogData(queryData.filterOnResourceType);
            this.readResponse(httpResponse, catalogData);
            CatalogData catalogData2 = catalogData;
            return catalogData2;
        }
        catch (ClientProtocolException e) {
            logger.warn("getCatalogDataFromServer", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            logger.warn("getCatalogDataFromServer", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            httpPost.releaseConnection();
        }
    }

    private static String localeToRFC5646LanguageTag(Locale locale) throws IllegalArgumentException {
        String result = locale.getLanguage();
        if (locale.getVariant().length() > 0) {
            result = result + "-" + locale.getVariant();
        }
        if (locale.getCountry().length() > 0) {
            result = result + "-" + locale.getCountry();
        }
        return result;
    }

    private void readResponse(HttpResponse httpResponse, ElementDeserializable readFromElement) {
        InputStream responseStream = null;
        try {
            Header encoding = httpResponse.getFirstHeader("Content-Encoding");
            responseStream = encoding != null && encoding.getValue().equalsIgnoreCase("gzip") ? new GZIPInputStream(httpResponse.getEntity().getContent()) : httpResponse.getEntity().getContent();
            XMLStreamReader reader = null;
            try {
                reader = XML_INPUT_FACTORY.createXMLStreamReader(responseStream);
                QName envelopeQName = new QName(SOAP, "Envelope", "soap");
                QName headerQName = new QName(SOAP, "Header", "soap");
                QName bodyQName = new QName(SOAP, "Body", "soap");
                if (reader.nextTag() == 1 && reader.getName().equals(envelopeQName)) {
                    while (reader.nextTag() == 1) {
                        if (reader.getName().equals(headerQName)) {
                            CatalogServiceImpl.readUntilElementEnd(reader);
                            continue;
                        }
                        if (!reader.getName().equals(bodyQName) || reader.nextTag() != 1 || !reader.getName().getLocalPart().equals(QUERY_NODE_RESPONSE)) continue;
                        readFromElement.readFromElement(reader);
                        return;
                    }
                }
            }
            catch (XMLStreamException e) {
                logger.warn("readResponse", (Throwable)e);
                throw new RuntimeException(e);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (XMLStreamException xMLStreamException) {}
                }
            }
        }
        catch (IOException e) {
            logger.warn("readResponse", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            if (responseStream != null) {
                try {
                    responseStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static void readUntilElementEnd(XMLStreamReader reader) throws XMLStreamException {
        int event = reader.getEventType();
        int elementDepth = 1;
        boolean firstTime = true;
        while (true) {
            switch (event) {
                case 1: {
                    if (firstTime) {
                        firstTime = false;
                        break;
                    }
                    ++elementDepth;
                    break;
                }
                case 2: {
                    if (--elementDepth >= 1) break;
                    return;
                }
            }
            event = reader.next();
        }
    }

    private static StringEntity generateSoapQuery(String pathSpecs, int queryOptions) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<?xml version='1.0' encoding='UTF-8'?>");
        stringBuilder.append("<soap:Envelope xmlns:soap=\"http://www.w3.org/2003/05/soap-envelope\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">");
        stringBuilder.append("<soap:Body xmlns=\"http://microsoft.com/webservices/\">");
        stringBuilder.append("<QueryNodes>");
        stringBuilder.append("<pathSpecs>");
        stringBuilder.append("<string>" + pathSpecs + "</string>");
        stringBuilder.append("</pathSpecs>");
        stringBuilder.append("<queryOptions>" + queryOptions + "</queryOptions>");
        stringBuilder.append("</QueryNodes>");
        stringBuilder.append("</soap:Body>");
        stringBuilder.append("</soap:Envelope>");
        StringEntity stringEntity = new StringEntity(stringBuilder.toString(), ContentType.create((String)"application/soap+xml", (String)"utf-8"));
        return stringEntity;
    }

    static {
        XML_INPUT_FACTORY.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
    }

    private class KeyValueOfStringString
    implements ElementDeserializable {
        String key;
        String value;

        KeyValueOfStringString() {
        }

        String getKey() {
            return this.key;
        }

        String getValue() {
            return this.value;
        }

        @Override
        public void readFromElement(XMLStreamReader reader) throws XMLStreamException {
            int event;
            do {
                if ((event = reader.next()) != 1) continue;
                String localName = reader.getLocalName();
                if (localName.equalsIgnoreCase("Key")) {
                    this.key = reader.getElementText();
                    continue;
                }
                if (localName.equalsIgnoreCase("Value")) {
                    this.value = reader.getElementText();
                    continue;
                }
                CatalogServiceImpl.readUntilElementEnd(reader);
            } while (event != 2);
        }
    }

    private class CatalogResource
    implements ElementDeserializable {
        String displayName;
        String resourceTypeIdentifier;
        boolean matchedQuery;
        String instanceId;
        String[] nodeReferencePaths;

        private CatalogResource() {
        }

        @Override
        public void readFromElement(XMLStreamReader reader) throws XMLStreamException {
            int event;
            String localName;
            int attributeCount = reader.getAttributeCount();
            for (int i = 0; i < attributeCount; ++i) {
                localName = reader.getAttributeLocalName(i);
                String attributeValue = reader.getAttributeValue(i);
                if (localName.equalsIgnoreCase("DisplayName")) {
                    this.displayName = attributeValue;
                    continue;
                }
                if (localName.equalsIgnoreCase("ResourceTypeIdentifier")) {
                    this.resourceTypeIdentifier = attributeValue;
                    continue;
                }
                if (!localName.equalsIgnoreCase("MatchedQuery")) continue;
                this.matchedQuery = Boolean.valueOf(attributeValue);
            }
            do {
                int event0;
                if ((event = reader.next()) != 1) continue;
                localName = reader.getLocalName();
                if (localName.equalsIgnoreCase("Properties")) {
                    do {
                        if ((event0 = reader.nextTag()) != 1) continue;
                        KeyValueOfStringString keyValueOfStringString = new KeyValueOfStringString();
                        keyValueOfStringString.readFromElement(reader);
                        if (!keyValueOfStringString.getKey().equalsIgnoreCase("InstanceId")) continue;
                        this.instanceId = keyValueOfStringString.getValue();
                    } while (event0 != 2);
                    continue;
                }
                if (localName.equalsIgnoreCase("NodeReferencePaths")) {
                    ArrayList<String> list0 = new ArrayList<String>();
                    do {
                        if ((event0 = reader.nextTag()) != 1) continue;
                        list0.add(reader.getElementText());
                    } while (event0 != 2);
                    this.nodeReferencePaths = list0.toArray(new String[list0.size()]);
                    continue;
                }
                CatalogServiceImpl.readUntilElementEnd(reader);
            } while (event != 2);
        }
    }

    private class CatalogData
    implements ElementDeserializable {
        private final String filterOnResourceType;
        private final List<CatalogResource> catalogResources = new ArrayList<CatalogResource>();

        private CatalogData(String filterOnResourceType) {
            this.filterOnResourceType = filterOnResourceType;
        }

        @Override
        public void readFromElement(XMLStreamReader reader) throws XMLStreamException {
            int event;
            do {
                if ((event = reader.next()) != 1) continue;
                String localName = reader.getLocalName();
                if (localName.equalsIgnoreCase("QueryNodesResult")) {
                    int event0;
                    do {
                        if ((event0 = reader.next()) != 1) continue;
                        String localName0 = reader.getLocalName();
                        if (localName0.equalsIgnoreCase("CatalogResources")) {
                            int event1;
                            do {
                                if ((event1 = reader.nextTag()) != 1) continue;
                                CatalogResource catalogResource = new CatalogResource();
                                catalogResource.readFromElement(reader);
                                if (!this.filterOnResourceType.equalsIgnoreCase(catalogResource.resourceTypeIdentifier)) continue;
                                this.catalogResources.add(catalogResource);
                            } while (event1 != 2);
                            continue;
                        }
                        CatalogServiceImpl.readUntilElementEnd(reader);
                    } while (event0 != 2);
                    continue;
                }
                CatalogServiceImpl.readUntilElementEnd(reader);
            } while (event != 2);
        }
    }

    private static interface ElementDeserializable {
        public void readFromElement(XMLStreamReader var1) throws XMLStreamException;
    }

    private class QueryData {
        final String pathSpecs;
        final int queryOptions;
        final String filterOnResourceType;

        QueryData(String pathSpecs, int queryOptions, String filterOnResourceType) {
            this.pathSpecs = pathSpecs;
            this.queryOptions = queryOptions;
            this.filterOnResourceType = filterOnResourceType;
        }
    }
}

