/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.external;

import com.google.common.util.concurrent.SettableFuture;
import com.microsoft.alm.common.utils.ArgumentHelper;
import com.microsoft.alm.plugin.external.utils.ProcessHelper;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToolRunner {
    private static final Logger logger = LoggerFactory.getLogger(ToolRunner.class);
    private Process toolProcess;
    private final String toolLocation;
    private final String workingDirectory;
    private StreamProcessor standardErrorProcessor;
    private StreamProcessor standardOutProcessor;
    private ProcessWaiter processWaiter;
    private ListenerProxy listenerProxy;

    public ToolRunner(String toolLocation, String workingDirectory) {
        this.toolLocation = toolLocation;
        this.workingDirectory = workingDirectory;
        this.listenerProxy = new ListenerProxy();
    }

    public void addListener(Listener listener) {
        this.listenerProxy.addListener(listener);
    }

    public Process start(ArgumentBuilder argumentBuilder) {
        logger.info("ToolRunner.start: toolLocation = " + this.toolLocation);
        logger.info("ToolRunner.start: workingDirectory = " + this.workingDirectory);
        ArgumentHelper.checkNotNull((Object)argumentBuilder, (String)"argumentBuilder");
        logger.info("arguments: " + argumentBuilder.toString());
        try {
            SettableFuture standardOutputFlushed = SettableFuture.create();
            SettableFuture standardErrorFlushed = SettableFuture.create();
            this.toolProcess = ProcessHelper.startProcess(this.workingDirectory, argumentBuilder.build(this.toolLocation));
            InputStream stderr = this.toolProcess.getErrorStream();
            InputStream stdout = this.toolProcess.getInputStream();
            this.standardErrorProcessor = new StreamProcessor(stderr, true, this.listenerProxy, (SettableFuture<Boolean>)standardErrorFlushed);
            this.standardErrorProcessor.start();
            this.standardOutProcessor = new StreamProcessor(stdout, false, this.listenerProxy, (SettableFuture<Boolean>)standardOutputFlushed);
            this.standardOutProcessor.start();
            this.processWaiter = new ProcessWaiter(this.toolProcess, this.listenerProxy, (SettableFuture<Boolean>)standardErrorFlushed, (SettableFuture<Boolean>)standardOutputFlushed);
            this.processWaiter.start();
            return this.toolProcess;
        }
        catch (IOException e) {
            logger.warn("Failed to start tool process or redirect output.", (Throwable)e);
            this.listenerProxy.processException(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Process sendArgsViaStandardInput(ArgumentBuilder argumentBuilder) {
        ArgumentHelper.checkNotNull((Object)this.toolProcess, (String)"toolProcess");
        ArgumentHelper.checkNotNull((Object)argumentBuilder, (String)"argumentBuilder");
        logger.info("sendArgsViaStandardInput: proceedWithArgs: " + argumentBuilder.toString());
        OutputStream stdin = this.toolProcess.getOutputStream();
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(stdin));
        try {
            for (String arg : argumentBuilder.build()) {
                String escapedArg = this.escapeArgument(arg);
                writer.write(escapedArg);
                writer.write(" ");
            }
            writer.write("\n");
            writer.flush();
        }
        catch (Throwable throwable) {
            logger.warn("Error sending args.", throwable);
            this.listenerProxy.processException(throwable);
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException e) {
                logger.warn("Unable to close the writer.", (Throwable)e);
            }
        }
        return this.toolProcess;
    }

    private String escapeArgument(String argument) {
        String escaped = StringUtils.replace((String)argument, (String)"\"", (String)"\"\"");
        if (StringUtils.contains((String)escaped, (String)" ")) {
            escaped = "\"" + escaped + "\"";
        }
        return escaped;
    }

    public void dispose() {
        try {
            if (this.processWaiter != null) {
                this.processWaiter.cleanUp();
                this.processWaiter = null;
            }
            if (this.standardErrorProcessor != null) {
                this.standardErrorProcessor.cleanUp();
                this.standardErrorProcessor = null;
            }
            if (this.standardOutProcessor != null) {
                this.standardOutProcessor.cleanUp();
                this.standardOutProcessor = null;
            }
        }
        catch (InterruptedException e) {
            logger.warn("Failed to dispose ToolRunner.", (Throwable)e);
        }
    }

    private static class StreamProcessor
    extends Thread {
        private final InputStream stream;
        private final boolean isStandardError;
        private final Listener listener;
        private final SettableFuture<Boolean> flushed;

        public StreamProcessor(InputStream stream, boolean isStandardError, Listener listener, SettableFuture<Boolean> flushed) {
            ArgumentHelper.checkNotNull((Object)stream, (String)"stream");
            ArgumentHelper.checkNotNull((Object)listener, (String)"listener");
            ArgumentHelper.checkNotNull(flushed, (String)"flushed");
            this.stream = stream;
            this.isStandardError = isStandardError;
            this.listener = listener;
            this.flushed = flushed;
        }

        @Override
        public void run() {
            BufferedReader bufferedReader = null;
            try {
                String line;
                bufferedReader = new BufferedReader(new InputStreamReader(this.stream));
                while ((line = bufferedReader.readLine()) != null) {
                    if (this.isStandardError) {
                        this.listener.processStandardError(line);
                        continue;
                    }
                    this.listener.processStandardOutput(line);
                }
            }
            catch (Throwable e) {
                logger.warn("Failed to process output.", e);
                this.listener.processException(e);
            }
            finally {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                    this.flushed.set((Object)true);
                }
                catch (Throwable e) {
                    logger.warn("Failed to close buffer.", e);
                    this.listener.processException(e);
                }
            }
        }

        public void cleanUp() throws InterruptedException {
            this.interrupt();
            this.join();
        }
    }

    private static class ProcessWaiter
    extends Thread {
        private boolean processRunning;
        private final Process process;
        private final Listener listener;
        private final SettableFuture<Boolean> errorsFlushed;
        private final SettableFuture<Boolean> outputFlushed;

        public ProcessWaiter(Process process, Listener listener, SettableFuture<Boolean> errorsFlushed, SettableFuture<Boolean> outputFlushed) {
            ArgumentHelper.checkNotNull((Object)process, (String)"process");
            ArgumentHelper.checkNotNull((Object)listener, (String)"listener");
            this.process = process;
            this.listener = listener;
            this.errorsFlushed = errorsFlushed;
            this.outputFlushed = outputFlushed;
        }

        @Override
        public void run() {
            try {
                this.processRunning = true;
                this.process.waitFor();
                this.errorsFlushed.get(30L, TimeUnit.SECONDS);
                this.outputFlushed.get(30L, TimeUnit.SECONDS);
                this.processRunning = false;
                this.listener.completed(this.process.exitValue());
            }
            catch (Throwable e) {
                logger.warn("Failed to wait for process exit.", e);
                this.listener.processException(e);
            }
        }

        public void cleanUp() throws InterruptedException {
            if (this.processRunning) {
                try {
                    this.process.destroy();
                }
                catch (Throwable t) {
                    logger.warn("Failed to destroy process.", t);
                }
            }
            this.interrupt();
            this.join();
        }
    }

    private static class ListenerProxy
    implements Listener {
        private final List<Listener> listeners = new ArrayList<Listener>(2);

        public void addListener(Listener listener) {
            this.listeners.add(listener);
        }

        @Override
        public void processStandardOutput(String line) {
            for (Listener l : this.listeners) {
                l.processStandardOutput(line);
            }
        }

        @Override
        public void processStandardError(String line) {
            for (Listener l : this.listeners) {
                l.processStandardError(line);
            }
        }

        @Override
        public void processException(Throwable throwable) {
            for (Listener l : this.listeners) {
                l.processException(throwable);
            }
        }

        @Override
        public void completed(int returnCode) {
            for (Listener l : this.listeners) {
                l.completed(returnCode);
            }
        }
    }

    public static class ArgumentBuilder {
        private static final String STARS = "********";
        private List<String> arguments = new ArrayList<String>(5);
        private Set<Integer> secretArgumentIndexes = new HashSet<Integer>(5);
        private String workingDirectory;

        public ArgumentBuilder setWorkingDirectory(String workingDirectory) {
            this.workingDirectory = workingDirectory;
            return this;
        }

        public String getWorkingDirectory() {
            return this.workingDirectory;
        }

        public ArgumentBuilder add(String argument) {
            this.arguments.add(argument);
            return this;
        }

        public ArgumentBuilder addSwitch(String switchName) {
            return this.addSwitch(switchName, null, false);
        }

        public ArgumentBuilder addSwitch(String switchName, String switchValue) {
            return this.addSwitch(switchName, switchValue, false);
        }

        public ArgumentBuilder addSwitch(String switchName, String switchValue, boolean isSecret) {
            ArgumentHelper.checkNotEmptyString((String)switchName, (String)"switchName");
            String arg = StringUtils.isEmpty((String)switchValue) ? "-" + switchName : "-" + switchName + ":" + switchValue;
            if (isSecret) {
                this.addSecret(arg);
            } else {
                this.add(arg);
            }
            return this;
        }

        public ArgumentBuilder addSecret(String argument) {
            this.add(argument);
            this.secretArgumentIndexes.add(this.arguments.size() - 1);
            return this;
        }

        public List<String> build() {
            return Collections.unmodifiableList(this.arguments);
        }

        public List<String> build(String toolLocation) {
            ArrayList<String> commandLineParts = new ArrayList<String>(this.arguments);
            commandLineParts.add(0, toolLocation);
            return Collections.unmodifiableList(commandLineParts);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < this.arguments.size(); ++i) {
                String arg = this.secretArgumentIndexes.contains(i) ? STARS : this.arguments.get(i);
                builder.append(arg);
                builder.append(" ");
            }
            return builder.toString().trim();
        }
    }

    public static interface Listener {
        public void processStandardOutput(String var1);

        public void processStandardError(String var1);

        public void processException(Throwable var1);

        public void completed(int var1);
    }
}

