/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.external.commands;

import com.microsoft.alm.common.utils.ArgumentHelper;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.exceptions.TeamServicesException;
import com.microsoft.alm.plugin.external.ToolRunner;
import com.microsoft.alm.plugin.external.commands.Command;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckinCommand
extends Command<String> {
    public static final Logger logger = LoggerFactory.getLogger(CheckinCommand.class);
    private static final String CHECKIN_LINE_PREFIX = "Checking in";
    private static final String CHECKIN_FAILED_MSG = "No files checked in";
    private final List<String> files;
    private final String comment;
    private final List<Integer> workItemsToAssociate;

    public CheckinCommand(ServerContext context, List<String> files, String comment, List<Integer> workItemsToAssociate) {
        super("checkin", context);
        ArgumentHelper.checkNotNullOrEmpty(files, (String)"files");
        this.files = files;
        this.comment = comment;
        this.workItemsToAssociate = workItemsToAssociate;
    }

    @Override
    public ToolRunner.ArgumentBuilder getArgumentBuilder() {
        ToolRunner.ArgumentBuilder builder = super.getArgumentBuilder();
        for (String file : this.files) {
            builder.add(file);
        }
        if (StringUtils.isNotEmpty((String)this.comment)) {
            builder.addSwitch("comment", this.getComment());
        }
        if (this.workItemsToAssociate != null && this.workItemsToAssociate.size() > 0) {
            builder.addSwitch("associate", this.getAssociatedWorkItems());
        }
        return builder;
    }

    private String getComment() {
        return this.comment.replace("\r\n", " ").replace("\n", " ");
    }

    private String getAssociatedWorkItems() {
        StringBuilder sb = new StringBuilder();
        for (Integer i : this.workItemsToAssociate) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(i.toString());
        }
        return sb.toString();
    }

    @Override
    public String parseOutput(String stdout, String stderr) {
        if (StringUtils.isNotEmpty((String)stderr)) {
            logger.error("Checkin failed with the following stdout: " + stdout);
            String[] output = this.getLines(stdout);
            for (int i = 0; i < output.length; ++i) {
                if (!this.isOutputLineExpected(output[i], new String[]{CHECKIN_LINE_PREFIX, CHECKIN_FAILED_MSG}, true)) continue;
                throw new RuntimeException(output[i]);
            }
            logger.error("Parsing of the stdout failed to get the error message");
            throw new TeamServicesException(TeamServicesException.KEY_ERROR_UNKNOWN);
        }
        return this.getChangesetNumber(stdout);
    }
}

