/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.external.commands;

import com.microsoft.alm.common.utils.ArgumentHelper;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.external.ToolRunner;
import com.microsoft.alm.plugin.external.commands.Command;
import com.microsoft.alm.plugin.external.exceptions.WorkspaceAlreadyExistsException;
import com.microsoft.alm.plugin.external.models.Workspace;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class CreateWorkspaceCommand
extends Command<String> {
    private static String WORKSPACE_EXISTS_ERROR = "An error occurred: The workspace %s;.* already exists on computer .*";
    private final String workspaceName;
    private final String comment;
    private final Workspace.FileTime fileTime;
    private final Workspace.Permission permission;

    public CreateWorkspaceCommand(ServerContext context, String workspaceName, String comment, Workspace.FileTime fileTime, Workspace.Permission permission) {
        super("workspace", context);
        ArgumentHelper.checkNotEmptyString((String)workspaceName, (String)"workspaceName");
        this.workspaceName = workspaceName;
        this.comment = comment;
        this.fileTime = fileTime;
        this.permission = permission;
    }

    @Override
    public ToolRunner.ArgumentBuilder getArgumentBuilder() {
        ToolRunner.ArgumentBuilder builder = super.getArgumentBuilder().addSwitch("new").addSwitch("location", "local").add(this.workspaceName);
        if (StringUtils.isNotEmpty((String)this.comment)) {
            builder.addSwitch("comment", this.comment);
        }
        if (this.fileTime != null) {
            builder.addSwitch("filetime", this.fileTime.toString());
        }
        if (this.permission != null) {
            builder.addSwitch("permission", this.permission.toString());
        }
        return builder;
    }

    @Override
    public String parseOutput(String stdout, String stderr) {
        this.throwIfError(stderr);
        return "";
    }

    @Override
    protected void throwIfError(String stderr) {
        Pattern pattern;
        Matcher matcher;
        if (StringUtils.isNotEmpty((String)stderr) && (matcher = (pattern = Pattern.compile(String.format(WORKSPACE_EXISTS_ERROR, this.workspaceName))).matcher(stderr)).find()) {
            throw new WorkspaceAlreadyExistsException(this.workspaceName);
        }
        super.throwIfError(stderr);
    }
}

