/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.external.commands;

import com.microsoft.alm.common.utils.ArgumentHelper;
import com.microsoft.alm.helpers.Path;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.external.ToolRunner;
import com.microsoft.alm.plugin.external.commands.Command;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class DeleteCommand
extends Command<List<String>> {
    private final List<String> filePaths;
    private final boolean recursive;
    private final String workspace;

    public DeleteCommand(ServerContext context, List<String> filePaths, String workspace, boolean recursive) {
        super("delete", context);
        ArgumentHelper.checkNotNullOrEmpty(filePaths, (String)"filePaths");
        this.filePaths = filePaths;
        this.workspace = workspace;
        this.recursive = recursive;
    }

    @Override
    public ToolRunner.ArgumentBuilder getArgumentBuilder() {
        ToolRunner.ArgumentBuilder builder = super.getArgumentBuilder();
        for (String file : this.filePaths) {
            builder.add(file);
        }
        if (this.recursive) {
            builder.addSwitch("recursive");
        }
        if (StringUtils.isNotEmpty((String)this.workspace)) {
            builder.addSwitch("workspace", this.workspace);
        }
        return builder;
    }

    @Override
    public List<String> parseOutput(String stdout, String stderr) {
        super.throwIfError(stderr);
        String[] lines = this.getLines(stdout);
        ArrayList<String> deletedFiles = new ArrayList<String>();
        String path = "";
        for (String line : lines) {
            if (line.endsWith(":")) {
                path = line.substring(0, line.length() - 1);
                continue;
            }
            if (!StringUtils.isNotEmpty((String)line)) continue;
            deletedFiles.add(Path.combine((String)path, (String)line));
        }
        return deletedFiles;
    }
}

