/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.external.commands;

import com.microsoft.alm.common.utils.ArgumentHelper;
import com.microsoft.alm.plugin.external.ToolRunner;
import com.microsoft.alm.plugin.external.commands.Command;
import com.microsoft.alm.plugin.external.models.Workspace;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FindWorkspaceCommand
extends Command<Workspace> {
    protected static final Logger logger = LoggerFactory.getLogger(FindWorkspaceCommand.class);
    private final String localPath;

    public FindWorkspaceCommand(String localPath) {
        super("workfold", null);
        ArgumentHelper.checkNotEmptyString((String)localPath, (String)"localPath");
        this.localPath = localPath;
    }

    @Override
    public ToolRunner.ArgumentBuilder getArgumentBuilder() {
        ToolRunner.ArgumentBuilder builder = super.getArgumentBuilder();
        builder.setWorkingDirectory(this.localPath);
        builder.addSwitch("login", "username,pw", true);
        return builder;
    }

    @Override
    public Workspace parseOutput(String stdout, String stderr) {
        super.throwIfError(stderr);
        String[] lines = this.getLines(stdout);
        for (int x = 0; x < lines.length; ++x) {
            if (lines.length <= x + 2 || !lines[x].contains("==========")) continue;
            String workspaceName = this.getValue(lines[x + 1]);
            String collectionURL = this.getValue(lines[x + 2]);
            ArrayList<Workspace.Mapping> mappings = new ArrayList<Workspace.Mapping>(10);
            for (int i = x + 3; i < lines.length; ++i) {
                Workspace.Mapping mapping = this.getMapping(lines[i]);
                if (mapping == null) continue;
                mappings.add(mapping);
            }
            return new Workspace(collectionURL, workspaceName, "", "", "", mappings);
        }
        return null;
    }

    private String getValue(String line) {
        int index = line.indexOf(": ");
        return line.substring(index + 2).trim();
    }

    private Workspace.Mapping getMapping(String line) {
        int startIndex;
        boolean isCloaked = StringUtils.startsWithIgnoreCase((String)line.trim(), (String)"(cloaked)");
        int endIndex = line.indexOf(":");
        int n = startIndex = isCloaked ? line.indexOf(")") + 1 : 0;
        if (endIndex >= 0) {
            String serverPath = line.substring(startIndex, endIndex).trim();
            String localPath = line.substring(endIndex + 1).trim();
            return new Workspace.Mapping(serverPath, localPath, isCloaked);
        }
        return null;
    }
}

